/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTManager;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactory;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameClassProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameGlobalProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameIncludeProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameLocalProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameMacroProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameMethodProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessorDelegate;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameTypeProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class CRenameProcessor
extends RenameProcessor {
    public static final String IDENTIFIER = "org.eclips.cdt.refactoring.RenameProcessor";
    private final CRefactoringArgument fArgument;
    private CRenameProcessorDelegate fDelegate;
    private String fReplacementText;
    private String fWorkingSet;
    private int fScope;
    private int fSelectedOptions;
    private final CRefactory fManager;
    private final ASTManager fAstManager;
    private IIndex fIndex;
    private RefactoringStatus fInitialConditionsStatus;

    public CRenameProcessor(CRefactory refactoringManager, CRefactoringArgument arg) {
        this.fManager = refactoringManager;
        this.fArgument = arg;
        this.fAstManager = new ASTManager(arg);
    }

    public CRefactoringArgument getArgument() {
        return this.fArgument;
    }

    public Object[] getElements() {
        return new Object[]{this.fArgument.getBinding()};
    }

    public String getProcessorName() {
        String identifier;
        String result = null;
        if (this.fDelegate != null) {
            result = this.fDelegate.getProcessorName();
        }
        if (result == null && (identifier = this.getArgument().getName()) != null && identifier.length() > 0) {
            result = NLS.bind((String)RenameMessages.CRenameTopProcessor_wizard_title, (Object)identifier);
        }
        if (result == null) {
            result = RenameMessages.CRenameTopProcessor_wizard_backup_title;
        }
        return result;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fInitialConditionsStatus != null) {
            return this.fInitialConditionsStatus;
        }
        String identifier = null;
        this.fInitialConditionsStatus = new RefactoringStatus();
        if (this.fArgument != null) {
            this.fAstManager.analyzeArgument(this.fIndex, pm, this.fInitialConditionsStatus);
            identifier = this.fArgument.getName();
        }
        if (identifier == null || identifier.length() == 0) {
            this.fInitialConditionsStatus.addFatalError(RenameMessages.CRenameTopProcessor_error_invalidTextSelection);
            return this.fInitialConditionsStatus;
        }
        IFile file = this.fArgument.getSourceFile();
        IPath path = null;
        if (file != null) {
            path = file.getLocation();
        }
        if (path == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RenameMessages.CRenameTopProcessor_error_renameWithoutSourceFile);
        }
        this.fDelegate = this.createDelegate();
        if (this.fDelegate == null) {
            this.fInitialConditionsStatus.addFatalError(RenameMessages.CRenameTopProcessor_error_invalidName);
            return this.fInitialConditionsStatus;
        }
        RefactoringStatus status = this.fDelegate.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        this.fInitialConditionsStatus.merge(status);
        return this.fInitialConditionsStatus;
    }

    private CRenameProcessorDelegate createDelegate() {
        switch (this.fArgument.getArgumentKind()) {
            case 1: {
                return new CRenameLocalProcessor(this, RenameMessages.CRenameTopProcessor_localVar, this.fArgument.getScope());
            }
            case 2: {
                return new CRenameLocalProcessor(this, RenameMessages.CRenameTopProcessor_parameter, this.fArgument.getScope());
            }
            case 3: {
                return new CRenameLocalProcessor(this, RenameMessages.CRenameTopProcessor_filelocalVar, null);
            }
            case 4: {
                return new CRenameGlobalProcessor(this, RenameMessages.CRenameTopProcessor_globalVar);
            }
            case 13: {
                return new CRenameGlobalProcessor(this, RenameMessages.CRenameTopProcessor_enumerator);
            }
            case 5: {
                return new CRenameGlobalProcessor(this, RenameMessages.CRenameTopProcessor_field);
            }
            case 6: {
                return new CRenameLocalProcessor(this, RenameMessages.CRenameTopProcessor_filelocalFunction, null);
            }
            case 7: {
                return new CRenameGlobalProcessor(this, RenameMessages.CRenameTopProcessor_globalFunction);
            }
            case 8: {
                return new CRenameMethodProcessor(this, RenameMessages.CRenameTopProcessor_virtualMethod, true);
            }
            case 9: {
                return new CRenameMethodProcessor(this, RenameMessages.CRenameTopProcessor_method, false);
            }
            case 14: {
                return new CRenameClassProcessor(this, RenameMessages.CRenameTopProcessor_type);
            }
            case 15: {
                return new CRenameTypeProcessor(this, RenameMessages.CRenameTopProcessor_namespace);
            }
            case 10: {
                return new CRenameTypeProcessor(this, RenameMessages.CRenameTopProcessor_type);
            }
            case 11: {
                return new CRenameMacroProcessor(this, RenameMessages.CRenameTopProcessor_macro);
            }
            case 12: {
                return new CRenameIncludeProcessor(this, RenameMessages.CRenameIncludeProcessor_includeDirective);
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return this.fDelegate.checkFinalConditions(pm, context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fDelegate.createChange(pm);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments arguments = new RenameArguments(this.getReplacementText(), true);
        String[] natures = new String[]{"org.eclipse.cdt.core.ccnature", "org.eclipse.cdt.core.cnature"};
        ArrayList<RenameParticipant> result = new ArrayList<RenameParticipant>();
        IBinding binding = this.getArgument().getBinding();
        if (binding != null) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)binding, (RenameArguments)arguments, (String[])natures, (SharableParticipants)sharedParticipants)));
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public int getAvailableOptions() {
        if (this.fDelegate == null) {
            return 0;
        }
        return this.fDelegate.getAvailableOptions();
    }

    public int getOptionsForcingPreview() {
        if (this.fDelegate == null) {
            return 0;
        }
        return this.fDelegate.getOptionsForcingPreview();
    }

    public int getOptionsEnablingScope() {
        if (this.fDelegate == null) {
            return 0;
        }
        return this.fDelegate.getOptionsEnablingScope();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public int getScope() {
        return this.fScope;
    }

    public void setScope(int scope) {
        this.fScope = scope;
    }

    public int getSelectedOptions() {
        return this.fSelectedOptions;
    }

    public void setSelectedOptions(int selectedOptions) {
        this.fSelectedOptions = selectedOptions;
    }

    public String getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(String workingSet) {
        this.fWorkingSet = this.checkWorkingSet(workingSet);
    }

    public String getReplacementText() {
        return this.fReplacementText;
    }

    public void setReplacementText(String replacementText) {
        this.fReplacementText = replacementText;
    }

    public CRefactory getManager() {
        return this.fManager;
    }

    public ASTManager getAstManager() {
        return this.fAstManager;
    }

    public void lockIndex() throws CoreException, InterruptedException {
        if (this.fIndex == null) {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            this.fIndex = CCorePlugin.getIndexManager().getIndex(projects);
        }
        this.fIndex.acquireReadLock();
    }

    public void unlockIndex() {
        if (this.fAstManager != null) {
            this.fAstManager.dispose();
        }
        if (this.fIndex != null) {
            this.fIndex.releaseReadLock();
        }
        this.fIndex = null;
    }

    public IIndex getIndex() {
        return this.fIndex;
    }

    public int getSaveMode() {
        return this.fDelegate.getSaveMode();
    }

    private String checkWorkingSet(String workingSet) {
        IWorkingSetManager wsManager;
        if (workingSet != null && workingSet.length() > 0 && (wsManager = PlatformUI.getWorkbench().getWorkingSetManager()).getWorkingSet(workingSet) != null) {
            return workingSet;
        }
        return "";
    }
}

