/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class AbstractCEditorTextHover
implements ICEditorTextHover,
ITextHoverExtension,
ITextHoverExtension2,
IInformationProviderExtension2 {
    private IEditorPart fEditor;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            Point selectedRange = textViewer.getSelectedRange();
            if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
                return new Region(selectedRange.x, selectedRange.y);
            }
            return CWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public abstract String getHoverInfo(ITextViewer var1, IRegion var2);

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(textViewer, hoverRegion);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, AbstractCEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, true);
            }
        };
    }

    protected String getTooltipAffordanceString() {
        return EditorsUI.getTooltipAffordanceString();
    }
}

