/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.CBreakIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameComposer {
    private static final int CAPITALIZATION_ORIGINAL = 0;
    private static final int CAPITALIZATION_UPPER_CASE = 1;
    private static final int CAPITALIZATION_LOWER_CASE = 2;
    private static final int CAPITALIZATION_CAMEL_CASE = 3;
    private static final int CAPITALIZATION_LOWER_CAMEL_CASE = 4;
    private final int capitalization;
    private final String wordDelimiter;
    private final String prefix;
    private final String suffix;

    public NameComposer(int capitalization, String wordDelimiter, String prefix, String suffix) {
        this.capitalization = capitalization;
        this.wordDelimiter = wordDelimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String compose(String seedName) {
        List<CharSequence> words = this.splitIntoWords(seedName);
        return this.compose(words);
    }

    public String compose(List<CharSequence> words) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.prefix);
        int i = 0;
        while (i < words.size()) {
            if (i > 0) {
                buf.append(this.wordDelimiter);
            }
            CharSequence word = words.get(i);
            switch (this.capitalization) {
                case 0: {
                    buf.append(word);
                    break;
                }
                case 1: {
                    this.appendUpperCase(buf, word);
                    break;
                }
                case 2: {
                    this.appendLowerCase(buf, word);
                    break;
                }
                case 3: {
                    this.appendTitleCase(buf, word);
                    break;
                }
                case 4: {
                    if (i == 0) {
                        this.appendLowerCase(buf, word);
                        break;
                    }
                    this.appendTitleCase(buf, word);
                }
            }
            ++i;
        }
        buf.append(this.suffix);
        return buf.toString();
    }

    public List<CharSequence> splitIntoWords(CharSequence name) {
        int end;
        ArrayList<CharSequence> words = new ArrayList<CharSequence>();
        CBreakIterator iterator = new CBreakIterator();
        iterator.setText(name);
        int start = iterator.first();
        while ((end = iterator.next()) != -1) {
            if (Character.isLetterOrDigit(name.charAt(start))) {
                int pos = end;
                while (--pos >= start && !Character.isLetterOrDigit(name.charAt(pos))) {
                }
                words.add(name.subSequence(start, pos + 1));
            }
            start = end;
        }
        return words;
    }

    private void appendUpperCase(StringBuilder buf, CharSequence word) {
        int i = 0;
        while (i < word.length()) {
            buf.append(Character.toUpperCase(word.charAt(i)));
            ++i;
        }
    }

    private void appendLowerCase(StringBuilder buf, CharSequence word) {
        int i = 0;
        while (i < word.length()) {
            buf.append(Character.toLowerCase(word.charAt(i)));
            ++i;
        }
    }

    private void appendTitleCase(StringBuilder buf, CharSequence word) {
        int i = 0;
        while (i < word.length()) {
            buf.append(i == 0 ? Character.toUpperCase(word.charAt(i)) : Character.toLowerCase(word.charAt(i)));
            ++i;
        }
    }
}

