/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.parser.CodeReaderCache;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CacheSizeBlock
extends AbstractCOptionPage {
    private IntegerFieldEditor fDBLimitPct;
    private IntegerFieldEditor fDBAbsoluteLimit;
    private IntegerFieldEditor fCodeReaderLimit;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                CacheSizeBlock.this.updateValidState();
            }
        }
    };

    public CacheSizeBlock(ICOptionContainer container) {
        this.setContainer(container);
    }

    public void createControl(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite composite = ControlFactory.createComposite(parent, 1);
        GridLayout gl = (GridLayout)composite.getLayout();
        gl.marginWidth = 0;
        GridData gd = (GridData)composite.getLayoutData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 4;
        this.setControl((Control)composite);
        Group group = ControlFactory.createGroup(composite, DialogsMessages.CacheSizeBlock_cacheLimitGroup, 1);
        gd = (GridData)group.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Composite cacheComp = ControlFactory.createComposite((Composite)group, 3);
        Label dbCacheLabel = ControlFactory.createLabel(cacheComp, DialogsMessages.CacheSizeBlock_indexDatabaseCache);
        this.fDBLimitPct = new IntegerFieldEditor("org.eclipse.cdt.core.indexDBCacheSizePct", DialogsMessages.CacheSizeBlock_limitRelativeToMaxHeapSize, cacheComp, 3);
        this.fDBLimitPct.setValidRange(1, 75);
        Text control = this.fDBLimitPct.getTextControl(cacheComp);
        LayoutUtil.setWidthHint((Control)control, pixelConverter.convertWidthInCharsToPixels(10));
        LayoutUtil.setHorizontalGrabbing((Control)control, false);
        ControlFactory.createLabel(cacheComp, "%");
        this.fDBAbsoluteLimit = new IntegerFieldEditor("org.eclipse.cdt.core.maxIndexDBCacheSizeMB", DialogsMessages.CacheSizeBlock_absoluteLimit, cacheComp, 4);
        this.fDBAbsoluteLimit.setValidRange(1, 10000);
        control = this.fDBAbsoluteLimit.getTextControl(cacheComp);
        LayoutUtil.setWidthHint((Control)control, pixelConverter.convertWidthInCharsToPixels(10));
        LayoutUtil.setHorizontalGrabbing((Control)control, false);
        ControlFactory.createLabel(cacheComp, DialogsMessages.CacheSizeBlock_MB);
        Label codeReaderLabel = ControlFactory.createLabel(cacheComp, DialogsMessages.CacheSizeBlock_headerFileCache);
        this.fCodeReaderLimit = new IntegerFieldEditor("org.eclipse.cdt.core.codeReaderCache", DialogsMessages.CacheSizeBlock_absoluteLimit, cacheComp, 4);
        this.fCodeReaderLimit.setValidRange(1, 10000);
        control = this.fCodeReaderLimit.getTextControl(cacheComp);
        LayoutUtil.setWidthHint((Control)control, pixelConverter.convertWidthInCharsToPixels(10));
        LayoutUtil.setHorizontalGrabbing((Control)control, false);
        ControlFactory.createLabel(cacheComp, DialogsMessages.CacheSizeBlock_MB);
        gl = (GridLayout)cacheComp.getLayout();
        gl.numColumns = 3;
        gl.makeColumnsEqualWidth = false;
        gl.marginLeft = 0;
        gl.verticalSpacing = 2;
        gd = (GridData)dbCacheLabel.getLayoutData();
        gd.horizontalSpan = 3;
        int vindent = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        gd = (GridData)codeReaderLabel.getLayoutData();
        gd.verticalIndent = vindent;
        gd.horizontalSpan = 3;
        int hindent = pixelConverter.convertWidthInCharsToPixels(2);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = hindent;
        this.fDBLimitPct.getLabelControl(cacheComp).setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = hindent;
        this.fDBAbsoluteLimit.getLabelControl(cacheComp).setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = hindent;
        this.fCodeReaderLimit.getLabelControl(cacheComp).setLayoutData((Object)gd);
        this.initializeValues();
    }

    private void initializeValues() {
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.cdt.core");
        this.fDBLimitPct.setPreferenceStore((IPreferenceStore)prefStore);
        this.fDBLimitPct.setPropertyChangeListener(this.validityChangeListener);
        this.fDBAbsoluteLimit.setPreferenceStore((IPreferenceStore)prefStore);
        this.fDBAbsoluteLimit.setPropertyChangeListener(this.validityChangeListener);
        this.fCodeReaderLimit.setPreferenceStore((IPreferenceStore)prefStore);
        this.fCodeReaderLimit.setPropertyChangeListener(this.validityChangeListener);
        this.fDBLimitPct.load();
        this.fDBAbsoluteLimit.load();
        this.fCodeReaderLimit.load();
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        this.fDBLimitPct.store();
        this.fDBAbsoluteLimit.store();
        this.fCodeReaderLimit.store();
        ICodeReaderCache cache = CDOM.getInstance().getCodeReaderFactory(0).getCodeReaderCache();
        if (cache instanceof CodeReaderCache) {
            ((CodeReaderCache)cache).setCacheSize(this.fCodeReaderLimit.getIntValue());
        }
    }

    public void performDefaults() {
        this.fDBLimitPct.loadDefault();
        this.fDBAbsoluteLimit.loadDefault();
        this.fCodeReaderLimit.loadDefault();
    }

    private void updateValidState() {
        if (!this.fDBLimitPct.isValid()) {
            this.setErrorMessage(this.fDBLimitPct.getErrorMessage());
            this.setValid(false);
        } else if (!this.fDBAbsoluteLimit.isValid()) {
            this.setErrorMessage(this.fDBAbsoluteLimit.getErrorMessage());
            this.setValid(false);
        } else if (!this.fCodeReaderLimit.isValid()) {
            this.setErrorMessage(this.fCodeReaderLimit.getErrorMessage());
            this.setValid(false);
        } else {
            this.setValid(true);
        }
        this.getContainer().updateContainer();
    }
}

