/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.actions.ActionUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionAssistant;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionProcessor;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.cdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.cdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.cdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IInvocationContext;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class CorrectionCommandHandler
extends AbstractHandler {
    private final CEditor fEditor;
    private final String fId;
    private final boolean fIsAssist;

    public CorrectionCommandHandler(CEditor editor, String id, boolean isAssist) {
        this.fEditor = editor;
        this.fId = id;
        this.fIsAssist = isAssist;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doExecute();
        return null;
    }

    public boolean doExecute() {
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        IWorkingCopy tu = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        IAnnotationModel model = CUIPlugin.getDefault().getDocumentProvider().getAnnotationModel(this.fEditor.getEditorInput());
        if (selection instanceof ITextSelection && tu != null && model != null) {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return false;
            }
            ICompletionProposal proposal = this.findCorrection(this.fId, this.fIsAssist, (ITextSelection)selection, (ITranslationUnit)tu, model);
            if (proposal != null) {
                this.invokeProposal(proposal, ((ITextSelection)selection).getOffset());
            }
        }
        return false;
    }

    private ICompletionProposal findCorrection(String id, boolean isAssist, ITextSelection selection, ITranslationUnit tu, IAnnotationModel model) {
        CorrectionContext context = new CorrectionContext(tu, selection.getOffset(), selection.getLength());
        ArrayList<ICCompletionProposal> proposals = new ArrayList<ICCompletionProposal>(10);
        if (isAssist) {
            if (id.equals("org.eclipse.cdt.ui.correction.renameInFile.assist")) {
                return this.getLocalRenameProposal(context);
            }
            CCorrectionProcessor.collectAssists(context, new ProblemLocation[0], proposals);
        } else {
            try {
                boolean goToClosest = selection.getLength() == 0;
                Annotation[] annotationArray = this.getAnnotations(selection.getOffset(), goToClosest);
                CCorrectionProcessor.collectProposals(context, model, annotationArray, true, false, proposals);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        for (Object e : proposals) {
            if (!(e instanceof ICommandAccess) || !id.equals(((ICommandAccess)e).getCommandId())) continue;
            return (ICompletionProposal)e;
        }
        return null;
    }

    private Annotation[] getAnnotations(int offset, boolean goToClosest) throws BadLocationException {
        ArrayList<Annotation> resultingAnnotations = new ArrayList<Annotation>();
        CCorrectionAssistant.collectQuickFixableAnnotations((ITextEditor)this.fEditor, offset, goToClosest, resultingAnnotations);
        return resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
    }

    private ICompletionProposal getLocalRenameProposal(final IInvocationContext context) {
        final ICCompletionProposal[] proposals = new ICCompletionProposal[1];
        ASTProvider.getASTProvider().runOnAST((ICElement)context.getTranslationUnit(), ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor(), new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) throws CoreException {
                IBinding binding;
                IASTNodeSelector selector = astRoot.getNodeSelector(null);
                IASTName name = selector.findEnclosingName(context.getSelectionOffset(), context.getSelectionLength());
                if (name != null && name == name.getLastName() && (binding = name.resolveBinding()) != null) {
                    proposals[0] = new LinkedNamesAssistProposal(context.getTranslationUnit());
                }
                return Status.OK_STATUS;
            }
        });
        return proposals[0];
    }

    private IDocument getDocument() {
        return CUIPlugin.getDefault().getDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void invokeProposal(ICompletionProposal proposal, int offset) {
        IDocument document;
        if (proposal instanceof ICompletionProposalExtension2) {
            ISourceViewer viewer = this.fEditor.getViewer();
            if (viewer != null) {
                ((ICompletionProposalExtension2)proposal).apply((ITextViewer)viewer, '\u0000', 0, offset);
                return;
            }
        } else if (proposal instanceof ICompletionProposalExtension && (document = this.getDocument()) != null) {
            ((ICompletionProposalExtension)proposal).apply(document, '\u0000', offset);
            return;
        }
        if ((document = this.getDocument()) != null) {
            proposal.apply(document);
        }
    }

    public static String getShortCutString(String proposalId) {
        TriggerSequence[] activeBindingsFor;
        IBindingService bindingService;
        if (proposalId != null && (bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)) != null && (activeBindingsFor = bindingService.getActiveBindingsFor(proposalId)).length > 0) {
            return activeBindingsFor[0].format();
        }
        return null;
    }
}

