/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction.proposals;

import org.eclipse.cdt.internal.corext.util.Messages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.cdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.refactoring.actions.CRenameAction;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class RenameRefactoringProposal
implements ICCompletionProposal,
ICompletionProposalExtension6,
ICommandAccess {
    private final CEditor fEditor;
    private final String fLabel;
    private int fRelevance;

    public RenameRefactoringProposal(CEditor editor) {
        this.fEditor = editor;
        this.fLabel = CorrectionMessages.RenameRefactoringProposal_name;
        this.fRelevance = 8;
    }

    public void apply(IDocument document) {
        CRenameAction action = new CRenameAction();
        action.setEditor((IEditorPart)this.fEditor);
        action.run();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.RenameRefactoringProposal_additionalInfo;
    }

    public String getDisplayString() {
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            return Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.fLabel, shortCutString});
        }
        return this.fLabel;
    }

    public StyledString getStyledDisplayString() {
        StyledString str = new StyledString(this.fLabel);
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            String decorated = Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.fLabel, shortCutString});
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)str);
        }
        return str;
    }

    public Image getImage() {
        return CDTSharedImages.getImage("icons/obj16/correction_linked_rename.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public String getIdString() {
        return this.getCommandId();
    }

    public String getCommandId() {
        return "org.eclipse.cdt.ui.edit.text.rename.element";
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }
}

