/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.corext.util.Strings;
import org.eclipse.cdt.internal.formatter.scanner.Scanner;
import org.eclipse.cdt.internal.formatter.scanner.Token;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardPrefs;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewClassCodeGenerator {
    private final IPath fHeaderPath;
    private final IPath fSourcePath;
    private final IPath fTestPath;
    private String fClassName;
    private IQualifiedTypeName fNamespace;
    private final IBaseClassInfo[] fBaseClasses;
    private final IMethodStub[] fMethodStubs;
    private ITranslationUnit fCreatedHeaderTU;
    private ITranslationUnit fCreatedSourceTU;
    private ITranslationUnit fCreatedTestTU;
    private ICElement fCreatedClass;
    private String fFullyQualifiedClassName;
    private boolean fForceSourceFileCreation;

    public void setForceSourceFileCreation(boolean force) {
        this.fForceSourceFileCreation = force;
    }

    public NewClassCodeGenerator(IPath headerPath, IPath sourcePath, IPath testPath, String className, String namespace, IBaseClassInfo[] baseClasses, IMethodStub[] methodStubs) {
        this.fHeaderPath = headerPath;
        this.fSourcePath = sourcePath;
        this.fTestPath = testPath;
        if (className != null && className.length() > 0) {
            this.fClassName = className;
        }
        if (namespace != null && namespace.length() > 0) {
            this.fNamespace = new QualifiedTypeName(namespace);
        }
        this.fFullyQualifiedClassName = this.fNamespace != null ? this.fNamespace.append(this.fClassName).getFullyQualifiedName() : this.fClassName;
        this.fBaseClasses = baseClasses;
        this.fMethodStubs = methodStubs;
    }

    public ICElement getCreatedClass() {
        return this.fCreatedClass;
    }

    public ITranslationUnit getCreatedHeaderTU() {
        return this.fCreatedHeaderTU;
    }

    public IFile getCreatedHeaderFile() {
        if (this.fCreatedHeaderTU != null) {
            return (IFile)this.fCreatedHeaderTU.getResource();
        }
        return null;
    }

    public ITranslationUnit getCreatedSourceTU() {
        return this.fCreatedSourceTU;
    }

    public IFile getCreatedSourceFile() {
        if (this.fCreatedSourceTU != null) {
            return (IFile)this.fCreatedSourceTU.getResource();
        }
        return null;
    }

    public IFile getCreatedTestFile() {
        if (this.fCreatedTestTU != null) {
            return (IFile)this.fCreatedTestTU.getResource();
        }
        return null;
    }

    public ICElement createClass(IProgressMonitor monitor) throws CodeGeneratorException, CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_mainTask, 400);
        ITranslationUnit headerTU = null;
        ITranslationUnit sourceTU = null;
        ITranslationUnit testTU = null;
        ICElement createdClass = null;
        IWorkingCopy headerWorkingCopy = null;
        IWorkingCopy sourceWorkingCopy = null;
        IWorkingCopy testWorkingCopy = null;
        try {
            List<IMethodStub> privateMethods;
            List<IMethodStub> protectedMethods;
            List<IMethodStub> publicMethods;
            if (this.fHeaderPath != null) {
                publicMethods = this.getStubs(ASTAccessVisibility.PUBLIC, false);
                protectedMethods = this.getStubs(ASTAccessVisibility.PROTECTED, false);
                privateMethods = this.getStubs(ASTAccessVisibility.PRIVATE, false);
                IFile headerFile = NewSourceFileGenerator.createHeaderFile(this.fHeaderPath, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                if (headerFile != null) {
                    headerTU = (ITranslationUnit)CoreModel.getDefault().create(headerFile);
                    String headerContent = this.constructHeaderFileContent(headerTU, publicMethods, protectedMethods, privateMethods, (headerWorkingCopy = headerTU.getWorkingCopy()).getBuffer().getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    headerContent = headerContent != null ? this.formatSource(headerContent, headerTU) : "";
                    headerWorkingCopy.getBuffer().setContents(headerContent);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    headerWorkingCopy.reconcile();
                    headerWorkingCopy.commit(true, monitor);
                    monitor.worked(50);
                    createdClass = headerWorkingCopy.getElement(this.fFullyQualifiedClassName);
                }
                this.fCreatedClass = createdClass;
                this.fCreatedHeaderTU = headerTU;
            }
            if (this.fSourcePath != null) {
                publicMethods = this.getStubs(ASTAccessVisibility.PUBLIC, true);
                protectedMethods = this.getStubs(ASTAccessVisibility.PROTECTED, true);
                privateMethods = this.getStubs(ASTAccessVisibility.PRIVATE, true);
                if (!this.fForceSourceFileCreation && publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty()) {
                    monitor.worked(100);
                } else {
                    IFile sourceFile = NewSourceFileGenerator.createSourceFile(this.fSourcePath, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (sourceFile != null) {
                        sourceTU = (ITranslationUnit)CoreModel.getDefault().create(sourceFile);
                        monitor.worked(50);
                        sourceWorkingCopy = sourceTU.getWorkingCopy();
                        String sourceContent = this.constructSourceFileContent(sourceTU, headerTU, publicMethods, protectedMethods, privateMethods, sourceWorkingCopy.getBuffer().getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        sourceContent = sourceContent != null ? this.formatSource(sourceContent, sourceTU) : "";
                        sourceWorkingCopy.getBuffer().setContents(sourceContent);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        sourceWorkingCopy.reconcile();
                        sourceWorkingCopy.commit(true, monitor);
                        monitor.worked(50);
                    }
                    this.fCreatedSourceTU = sourceTU;
                }
            }
            if (this.fTestPath != null) {
                IFile testFile = NewSourceFileGenerator.createTestFile(this.fTestPath, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                if (testFile != null) {
                    testTU = (ITranslationUnit)CoreModel.getDefault().create(testFile);
                    monitor.worked(50);
                    testWorkingCopy = testTU.getWorkingCopy();
                    String testContent = this.constructTestFileContent(testTU, headerTU, testWorkingCopy.getBuffer().getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    testContent = this.formatSource(testContent, testTU);
                    testWorkingCopy.getBuffer().setContents(testContent);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    testWorkingCopy.reconcile();
                    testWorkingCopy.commit(true, monitor);
                    monitor.worked(50);
                }
                this.fCreatedTestTU = testTU;
            }
        }
        finally {
            if (headerWorkingCopy != null) {
                headerWorkingCopy.destroy();
            }
            if (sourceWorkingCopy != null) {
                sourceWorkingCopy.destroy();
            }
            if (testWorkingCopy != null) {
                testWorkingCopy.destroy();
            }
            monitor.done();
        }
        return this.fCreatedClass;
    }

    private String formatSource(String content, ITranslationUnit tu) throws CModelException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)tu);
        TextEdit edit = CodeFormatterUtil.format(8, content, 0, lineDelimiter, tu.getCProject().getOptions(true));
        if (edit != null) {
            Document doc = new Document(content);
            try {
                edit.apply((IDocument)doc);
                content = doc.get();
            }
            catch (MalformedTreeException exc) {
                CUIPlugin.log(exc);
            }
            catch (BadLocationException exc) {
                CUIPlugin.log(exc);
            }
        }
        return content;
    }

    public String constructHeaderFileContent(ITranslationUnit headerTU, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, String oldContents, IProgressMonitor monitor) throws CoreException {
        String fileContent;
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_header, 100);
        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)headerTU);
        String namespaceBegin = this.fNamespace == null ? null : this.constructNamespaceBegin(headerTU, lineDelimiter);
        String namespaceEnd = this.fNamespace == null ? null : this.constructNamespaceEnd(headerTU, lineDelimiter);
        String classDefinition = this.constructClassDefinition(headerTU, publicMethods, protectedMethods, privateMethods, lineDelimiter);
        String includes = null;
        if (this.fBaseClasses != null && this.fBaseClasses.length > 0) {
            includes = this.constructBaseClassIncludes(headerTU, lineDelimiter, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        if (oldContents != null) {
            if (oldContents.length() == 0) {
                oldContents = null;
            } else if (!oldContents.endsWith(lineDelimiter)) {
                oldContents = String.valueOf(oldContents) + lineDelimiter;
            }
        }
        if (oldContents != null) {
            int appendFirstCharPos = -1;
            StringBuilder text = new StringBuilder();
            int insertionPos = this.getClassDefInsertionPos(oldContents);
            if (insertionPos == -1) {
                text.append(oldContents);
            } else {
                int prependLastCharPos = insertionPos - 1;
                while (prependLastCharPos >= 0 && Character.isWhitespace(oldContents.charAt(prependLastCharPos))) {
                    --prependLastCharPos;
                }
                if (prependLastCharPos >= 0) {
                    text.append(oldContents.substring(0, prependLastCharPos + 1));
                }
                appendFirstCharPos = prependLastCharPos + 1;
            }
            text.append(lineDelimiter);
            text.append(lineDelimiter);
            if (namespaceBegin != null) {
                text.append(namespaceBegin);
                text.append(lineDelimiter);
                text.append(lineDelimiter);
            }
            text.append(classDefinition);
            if (namespaceEnd != null) {
                if (!classDefinition.endsWith(lineDelimiter)) {
                    text.append(lineDelimiter);
                }
                text.append(lineDelimiter);
                text.append(namespaceEnd);
            }
            if (appendFirstCharPos != -1) {
                text.append(lineDelimiter);
                int len = oldContents.length();
                while (appendFirstCharPos < len && Character.isWhitespace(oldContents.charAt(appendFirstCharPos))) {
                    ++appendFirstCharPos;
                }
                if (appendFirstCharPos < len) {
                    text.append(oldContents.substring(appendFirstCharPos));
                }
            }
            if (Strings.endsWith(text, lineDelimiter)) {
                text.append(lineDelimiter);
            }
            fileContent = text.toString();
        } else {
            String namespaceName = this.fNamespace == null ? null : this.fNamespace.getFullyQualifiedName();
            String classComment = this.getClassComment(headerTU, lineDelimiter);
            fileContent = CodeGeneration.getHeaderFileContent(headerTU, includes, namespaceBegin, namespaceEnd, namespaceName, classComment, classDefinition, this.fClassName, lineDelimiter);
        }
        monitor.done();
        return fileContent;
    }

    public String constructNamespaceBegin(ITranslationUnit tu, String lineDelimiter) throws CoreException {
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < this.fNamespace.segmentCount()) {
            String namespaceName = this.fNamespace.segment(i);
            if (i > 0) {
                text.append(lineDelimiter);
            }
            text.append(CodeGeneration.getNamespaceBeginContent(tu, namespaceName, lineDelimiter));
            ++i;
        }
        return text.toString();
    }

    public String constructNamespaceEnd(ITranslationUnit tu, String lineDelimiter) throws CoreException {
        StringBuilder text = new StringBuilder();
        int i = this.fNamespace.segmentCount();
        while (--i >= 0) {
            String namespaceName = this.fNamespace.segment(i);
            text.append(CodeGeneration.getNamespaceEndContent(tu, namespaceName, lineDelimiter));
            if (i <= 0) continue;
            text.append(lineDelimiter);
        }
        return text.toString();
    }

    public String constructClassDefinition(ITranslationUnit tu, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, String lineDelimiter) throws CoreException {
        StringBuilder code = new StringBuilder();
        String comment = this.getClassComment(tu, lineDelimiter);
        if (comment != null) {
            code.append(comment);
            code.append(lineDelimiter);
        }
        code.append("class ");
        code.append(this.fClassName);
        code.append(this.constructBaseClassInheritance());
        code.append(" {");
        code.append(lineDelimiter);
        String body = this.constructMethodDeclarations(tu, publicMethods, protectedMethods, privateMethods, lineDelimiter);
        body = CodeGeneration.getClassBodyContent(tu, this.fClassName, body, lineDelimiter);
        if (body != null) {
            code.append(body);
            if (!body.endsWith(lineDelimiter)) {
                code.append(lineDelimiter);
            }
        }
        code.append("};");
        return this.removeRedundantVisibilityLabels(code.toString());
    }

    private String removeRedundantVisibilityLabels(String code) {
        Scanner scanner = new Scanner();
        scanner.setSource(code.toCharArray());
        scanner.resetTo(0, code.length());
        Document doc = new Document(code);
        try {
            Token token;
            MultiTextEdit edit = new MultiTextEdit();
            int sectionType = 1006;
            int previousTokenType = 1006;
            int previousTokenOffset = -1;
            while ((token = scanner.nextToken()) != null) {
                if (token.type == 4) {
                    switch (previousTokenType) {
                        case 98: 
                        case 99: 
                        case 100: {
                            if (previousTokenType == sectionType) {
                                IRegion region1 = doc.getLineInformationOfOffset(previousTokenOffset);
                                IRegion region2 = doc.getLineInformationOfOffset(token.offset);
                                edit.addChild((TextEdit)new DeleteEdit(region1.getOffset(), region2.getOffset() + region2.getLength() - region1.getOffset()));
                            }
                            sectionType = previousTokenType;
                        }
                    }
                }
                previousTokenType = token.type;
                previousTokenOffset = token.offset;
            }
            edit.apply((IDocument)doc, 0);
        }
        catch (MalformedTreeException e) {
            CUIPlugin.log(e);
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
        return doc.get();
    }

    private int getClassDefInsertionPos(String contents) {
        if (contents.length() == 0) {
            return -1;
        }
        int insertPos = contents.lastIndexOf("#endif");
        if (insertPos != -1 && (contents.indexOf(125, insertPos) != -1 || contents.indexOf(59, insertPos) != -1)) {
            return -1;
        }
        return insertPos;
    }

    private String getClassComment(ITranslationUnit tu, String lineDelimiter) {
        if (this.isAddComments(tu)) {
            try {
                String fqName = this.fFullyQualifiedClassName;
                String comment = CodeGeneration.getClassComment(tu, fqName, lineDelimiter);
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        return null;
    }

    private boolean isValidComment(String template) {
        return true;
    }

    public boolean isAddComments(ITranslationUnit tu) {
        return StubUtility.doAddComments(tu.getCProject());
    }

    private String constructMethodDeclarations(ITranslationUnit tu, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, String lineDelimiter) throws CoreException {
        String code;
        StringBuilder text = new StringBuilder();
        if (!publicMethods.isEmpty()) {
            text.append("public:");
            text.append(lineDelimiter);
            for (IMethodStub stub : publicMethods) {
                code = stub.createMethodDeclaration(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(lineDelimiter);
            }
        }
        if (!protectedMethods.isEmpty()) {
            if (text.length() > 0) {
                text.append(lineDelimiter);
            }
            text.append("protected:");
            text.append(lineDelimiter);
            for (IMethodStub stub : protectedMethods) {
                code = stub.createMethodDeclaration(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(lineDelimiter);
            }
        }
        if (!privateMethods.isEmpty()) {
            if (text.length() > 0) {
                text.append(lineDelimiter);
            }
            text.append("private:");
            text.append(lineDelimiter);
            for (IMethodStub stub : privateMethods) {
                code = stub.createMethodDeclaration(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(lineDelimiter);
            }
        }
        return text.toString();
    }

    private List<IMethodStub> getStubs(ASTAccessVisibility access, boolean skipInline) {
        ArrayList<IMethodStub> list = new ArrayList<IMethodStub>();
        if (this.fMethodStubs != null) {
            int i = 0;
            while (i < this.fMethodStubs.length) {
                IMethodStub stub = this.fMethodStubs[i];
                if (!(stub.getAccess() != access || skipInline && stub.isInline())) {
                    list.add(stub);
                }
                ++i;
            }
        }
        return list;
    }

    private String constructBaseClassInheritance() {
        if (this.fBaseClasses == null || this.fBaseClasses.length == 0) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        text.append(" : ");
        int i = 0;
        while (i < this.fBaseClasses.length) {
            IBaseClassInfo baseClass = this.fBaseClasses[i];
            String baseClassName = baseClass.getType().getQualifiedTypeName().getFullyQualifiedName();
            if (i > 0) {
                text.append(", ");
            }
            if (baseClass.getAccess() == ASTAccessVisibility.PRIVATE) {
                text.append("private");
            } else if (baseClass.getAccess() == ASTAccessVisibility.PROTECTED) {
                text.append("private");
            } else {
                text.append("public");
            }
            text.append(' ');
            if (baseClass.isVirtual()) {
                text.append("virtual ");
            }
            text.append(baseClassName);
            ++i;
        }
        return text.toString();
    }

    private String constructBaseClassIncludes(ITranslationUnit headerTU, String lineDelimiter, IProgressMonitor monitor) throws CodeGeneratorException {
        String include;
        List<IPath> newIncludePaths;
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_header_includePaths, 100);
        ICProject cProject = headerTU.getCProject();
        IProject project = cProject.getProject();
        Path projectLocation = new Path(project.getLocationURI().getPath());
        Path headerLocation = new Path(headerTU.getResource().getLocationURI().getPath());
        List<IPath> includePaths = this.getIncludePaths(headerTU);
        List<IPath> baseClassPaths = this.getBaseClassPaths(this.verifyBaseClasses());
        if (this.createIncludePaths() && !(newIncludePaths = this.getMissingIncludePaths((IPath)projectLocation, includePaths, baseClassPaths)).isEmpty()) {
            this.addIncludePaths(cProject, newIncludePaths, monitor);
        }
        ArrayList<IPath> systemIncludes = new ArrayList<IPath>();
        ArrayList<IPath> localIncludes = new ArrayList<IPath>();
        for (IPath baseClassLocation : baseClassPaths) {
            boolean isSystemIncludePath = false;
            IPath includePath = PathUtil.makeRelativePathToProjectIncludes((IPath)baseClassLocation, (IProject)project);
            if (includePath != null && !projectLocation.isPrefixOf(baseClassLocation)) {
                isSystemIncludePath = true;
            } else if (projectLocation.isPrefixOf(baseClassLocation) && projectLocation.isPrefixOf((IPath)headerLocation)) {
                includePath = PathUtil.makeRelativePath((IPath)baseClassLocation, (IPath)headerLocation.removeLastSegments(1));
            }
            if (includePath == null) {
                includePath = baseClassLocation;
            }
            includePath = includePath.removeFirstSegments(includePath.segmentCount() - 1).setDevice(null);
            if (isSystemIncludePath) {
                systemIncludes.add(includePath);
                continue;
            }
            localIncludes.add(includePath);
        }
        StringBuilder text = new StringBuilder();
        for (IPath includePath : systemIncludes) {
            if (headerTU.getElementName().equals(includePath.toString())) continue;
            include = this.getIncludeString(includePath.toString(), true);
            text.append(include);
            text.append(lineDelimiter);
        }
        for (IPath includePath : localIncludes) {
            if (headerTU.getElementName().equals(includePath.toString())) continue;
            include = this.getIncludeString(includePath.toString(), false);
            text.append(include);
            text.append(lineDelimiter);
        }
        monitor.done();
        return text.toString();
    }

    private boolean verifyBaseClasses() {
        return NewClassWizardPrefs.verifyBaseClasses();
    }

    private boolean createIncludePaths() {
        return NewClassWizardPrefs.createIncludePaths();
    }

    private void addIncludePaths(ICProject cProject, List<IPath> newIncludePaths, IProgressMonitor monitor) throws CodeGeneratorException {
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_header_addIncludePaths, 100);
        IPath addToResourcePath = cProject.getPath();
        try {
            ArrayList<Object> pathEntryList = new ArrayList<Object>();
            ArrayList<IPathEntry> checkEntryList = new ArrayList<IPathEntry>();
            IPathEntry[] checkEntries = cProject.getResolvedPathEntries();
            IPathEntry[] pathEntries = cProject.getRawPathEntries();
            if (pathEntries != null) {
                int i = 0;
                while (i < pathEntries.length) {
                    pathEntryList.add(pathEntries[i]);
                    ++i;
                }
            }
            IPathEntry[] iPathEntryArray = checkEntries;
            int n = checkEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IPathEntry checkEntrie = iPathEntryArray[n2];
                if (checkEntrie instanceof IIncludeEntry) {
                    checkEntryList.add(checkEntrie);
                }
                ++n2;
            }
            for (IPath folderToAdd : newIncludePaths) {
                IIncludeEntry entry;
                ICProject includeProject;
                if (cProject.getPath().segment(0).equals(folderToAdd.segment(0)) || (includeProject = this.toCProject(PathUtil.getEnclosingProject((IPath)folderToAdd))) == null || checkEntryList.contains(entry = CoreModel.newIncludeEntry((IPath)addToResourcePath, null, (IPath)new Path(includeProject.getProject().getLocationURI().getPath()), (boolean)true))) continue;
                pathEntryList.add(entry);
            }
            pathEntries = pathEntryList.toArray(new IPathEntry[pathEntryList.size()]);
            cProject.setRawPathEntries(pathEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
        catch (CModelException e) {
            throw new CodeGeneratorException(e);
        }
        monitor.done();
    }

    private ICProject toCProject(IProject enclosingProject) {
        if (enclosingProject != null) {
            return CoreModel.getDefault().create(enclosingProject);
        }
        return null;
    }

    private List<IPath> getMissingIncludePaths(IPath projectLocation, List<IPath> includePaths, List<IPath> baseClassPaths) {
        ArrayList<IPath> newIncludePaths = new ArrayList<IPath>();
        for (IPath baseClassLocation : baseClassPaths) {
            if (projectLocation.isPrefixOf(baseClassLocation)) continue;
            IPath folderToAdd = baseClassLocation.removeLastSegments(1);
            IPath canonPath = PathUtil.getCanonicalPath((IPath)folderToAdd);
            if (canonPath != null) {
                folderToAdd = canonPath;
            }
            for (IPath newFolder : newIncludePaths) {
                if (!newFolder.isPrefixOf(folderToAdd)) continue;
                folderToAdd = null;
                break;
            }
            if (folderToAdd == null) continue;
            boolean foundPath = false;
            for (IPath includePath : includePaths) {
                if (!includePath.isPrefixOf(folderToAdd) && !includePath.equals((Object)folderToAdd)) continue;
                foundPath = true;
                break;
            }
            if (foundPath) continue;
            Iterator newIter = newIncludePaths.iterator();
            while (newIter.hasNext()) {
                IPath newFolder = (IPath)newIter.next();
                if (!folderToAdd.isPrefixOf(newFolder)) continue;
                newIter.remove();
            }
            if (newIncludePaths.contains(folderToAdd)) continue;
            newIncludePaths.add(folderToAdd);
        }
        return newIncludePaths;
    }

    private List<IPath> getIncludePaths(ITranslationUnit headerTU) throws CodeGeneratorException {
        String[] includePaths;
        IScannerInfo info;
        IProject project = headerTU.getCProject().getProject();
        ICContainer sourceFolder = CModelUtil.getSourceFolder((ICElement)headerTU);
        if (sourceFolder == null) {
            throw new CodeGeneratorException("Could not find source folder");
        }
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null && (info = provider.getScannerInformation(sourceFolder.getResource())) != null && (includePaths = info.getIncludePaths()) != null) {
            ArrayList<IPath> list = new ArrayList<IPath>();
            int i = 0;
            while (i < includePaths.length) {
                Path path = new Path(includePaths[i]);
                if (!list.contains(path)) {
                    list.add((IPath)path);
                }
                ++i;
            }
            return list;
        }
        return null;
    }

    private List<IPath> getBaseClassPaths(boolean verifyLocation) throws CodeGeneratorException {
        ArrayList<IPath> list = new ArrayList<IPath>();
        int i = 0;
        while (i < this.fBaseClasses.length) {
            IBaseClassInfo baseClass = this.fBaseClasses[i];
            ITypeReference ref = baseClass.getType().getResolvedReference();
            IPath baseClassLocation = null;
            if (ref != null) {
                baseClassLocation = ref.getLocation();
            }
            if (baseClassLocation == null) {
                if (verifyLocation) {
                    throw new CodeGeneratorException("Could not find base class " + baseClass.toString());
                }
            } else if (!list.contains(baseClassLocation)) {
                list.add(baseClassLocation);
            }
            ++i;
        }
        return list;
    }

    public String constructSourceFileContent(ITranslationUnit sourceTU, ITranslationUnit headerTU, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, String oldContents, IProgressMonitor monitor) throws CoreException {
        String fileContent;
        String namespaceEnd;
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_source, 150);
        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)sourceTU);
        String includeString = null;
        if (headerTU != null && (includeString = this.getHeaderIncludeString(sourceTU, headerTU, (IProgressMonitor)new SubProgressMonitor(monitor, 50))) != null && oldContents != null && this.hasInclude(oldContents, includeString)) {
            includeString = null;
        }
        String methodBodies = null;
        if (!(publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty())) {
            methodBodies = this.constructMethodBodies(sourceTU, publicMethods, protectedMethods, privateMethods, lineDelimiter, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        String namespaceBegin = this.fNamespace == null ? null : this.constructNamespaceBegin(sourceTU, lineDelimiter);
        String string = namespaceEnd = this.fNamespace == null ? null : this.constructNamespaceEnd(sourceTU, lineDelimiter);
        if (oldContents != null) {
            if (oldContents.length() == 0) {
                oldContents = null;
            } else if (!oldContents.endsWith(lineDelimiter)) {
                oldContents = String.valueOf(oldContents) + lineDelimiter;
            }
        }
        if (oldContents != null) {
            StringBuilder text = new StringBuilder();
            if (includeString != null) {
                int insertionPos = this.getIncludeInsertionPos(oldContents);
                if (insertionPos == -1) {
                    text.append(oldContents);
                    text.append(lineDelimiter);
                    text.append(includeString);
                    text.append(lineDelimiter);
                } else {
                    text.append(oldContents.substring(0, insertionPos));
                    text.append(includeString);
                    text.append(lineDelimiter);
                    text.append(oldContents.substring(insertionPos));
                }
            } else {
                text.append(oldContents);
            }
            text.append(lineDelimiter);
            if (methodBodies != null) {
                if (namespaceBegin != null) {
                    text.append(namespaceBegin);
                    text.append(lineDelimiter);
                    text.append(lineDelimiter);
                }
                text.append(methodBodies);
                if (namespaceEnd != null) {
                    if (!methodBodies.endsWith(lineDelimiter)) {
                        text.append(lineDelimiter);
                    }
                    text.append(lineDelimiter);
                    text.append(namespaceEnd);
                }
            }
            if (Strings.endsWith(text, lineDelimiter)) {
                text.append(lineDelimiter);
            }
            fileContent = text.toString();
        } else {
            String namespaceName = this.fNamespace == null ? null : this.fNamespace.getFullyQualifiedName();
            fileContent = CodeGeneration.getBodyFileContent(sourceTU, includeString, namespaceBegin, namespaceEnd, namespaceName, null, methodBodies, this.fClassName, lineDelimiter);
        }
        monitor.done();
        return fileContent;
    }

    public String constructTestFileContent(ITranslationUnit testTU, ITranslationUnit headerTU, String oldContents, IProgressMonitor monitor) throws CoreException {
        String fileContent;
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_source, 150);
        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)testTU);
        String includeString = null;
        if (headerTU != null && (includeString = this.getHeaderIncludeString(testTU, headerTU, (IProgressMonitor)new SubProgressMonitor(monitor, 50))) != null && oldContents != null && this.hasInclude(oldContents, includeString)) {
            includeString = null;
        }
        if (oldContents != null) {
            if (oldContents.length() == 0) {
                oldContents = null;
            } else if (!oldContents.endsWith(lineDelimiter)) {
                oldContents = String.valueOf(oldContents) + lineDelimiter;
            }
        }
        if (oldContents != null) {
            StringBuilder text = new StringBuilder();
            if (includeString != null) {
                int insertionPos = this.getIncludeInsertionPos(oldContents);
                if (insertionPos == -1) {
                    text.append(oldContents);
                    text.append(lineDelimiter);
                    text.append(includeString);
                    text.append(lineDelimiter);
                } else {
                    text.append(oldContents.substring(0, insertionPos));
                    text.append(includeString);
                    text.append(lineDelimiter);
                    text.append(oldContents.substring(insertionPos));
                }
            } else {
                text.append(oldContents);
            }
            if (Strings.endsWith(text, lineDelimiter)) {
                text.append(lineDelimiter);
            }
            fileContent = text.toString();
        } else {
            String namespaceBegin = this.fNamespace == null ? null : this.constructNamespaceBegin(testTU, lineDelimiter);
            String namespaceEnd = this.fNamespace == null ? null : this.constructNamespaceEnd(testTU, lineDelimiter);
            String namespaceName = this.fNamespace == null ? null : this.fNamespace.getFullyQualifiedName();
            fileContent = CodeGeneration.getTestFileContent(testTU, includeString, namespaceBegin, namespaceEnd, namespaceName, null, this.fClassName, lineDelimiter);
        }
        monitor.done();
        return fileContent;
    }

    private String getHeaderIncludeString(ITranslationUnit sourceTU, ITranslationUnit headerTU, IProgressMonitor monitor) {
        IProject project = headerTU.getCProject().getProject();
        Path projectLocation = new Path(project.getLocationURI().getPath());
        Path headerLocation = new Path(headerTU.getResource().getLocationURI().getPath());
        Path sourceLocation = new Path(sourceTU.getResource().getLocationURI().getPath());
        IPath includePath = PathUtil.makeRelativePathToProjectIncludes((IPath)headerLocation, (IProject)project);
        boolean isSystemIncludePath = false;
        if (headerTU.getResource() == null && includePath != null && !projectLocation.isPrefixOf((IPath)headerLocation)) {
            isSystemIncludePath = true;
        } else if (projectLocation.isPrefixOf((IPath)headerLocation) && projectLocation.isPrefixOf((IPath)sourceLocation)) {
            includePath = PathUtil.makeRelativePath((IPath)headerLocation, (IPath)sourceLocation.removeLastSegments(1));
        }
        if (includePath == null) {
            includePath = headerLocation;
        }
        return this.getIncludeString(includePath.toString(), isSystemIncludePath);
    }

    private boolean hasInclude(String contents, String include) {
        int maxStartPos = contents.length() - include.length() - 1;
        if (maxStartPos < 0) {
            return false;
        }
        int startPos = 0;
        while (startPos <= maxStartPos) {
            int includePos = contents.indexOf(include, startPos);
            if (includePos == -1) {
                return false;
            }
            if (includePos == startPos) {
                return true;
            }
            int linePos = this.findFirstLineChar(contents, includePos);
            if (linePos == -1 || linePos == includePos) {
                return true;
            }
            boolean badLine = false;
            int pos = linePos;
            while (pos < includePos) {
                char c = contents.charAt(pos);
                if (!Character.isWhitespace(c)) {
                    badLine = true;
                    break;
                }
                ++pos;
            }
            if (!badLine) {
                return true;
            }
            startPos = includePos + include.length();
        }
        return false;
    }

    private int getIncludeInsertionPos(String contents) {
        int insertPos;
        int startPos;
        int eolPos;
        if (contents.length() == 0) {
            return -1;
        }
        int includePos = contents.lastIndexOf("#include ");
        if (includePos != -1 && (eolPos = this.findLastLineChar(contents, startPos = includePos + "#include ".length())) != -1 && (insertPos = eolPos + 1) < contents.length() - 1) {
            return insertPos;
        }
        return -1;
    }

    private String constructMethodBodies(ITranslationUnit tu, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, String lineDelimiter, IProgressMonitor monitor) throws CoreException {
        String code;
        IMethodStub stub;
        Iterator<IMethodStub> i;
        StringBuilder text = new StringBuilder();
        if (!publicMethods.isEmpty()) {
            i = publicMethods.iterator();
            while (i.hasNext()) {
                stub = i.next();
                code = stub.createMethodImplementation(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append(code);
                text.append(lineDelimiter);
                if (!i.hasNext()) continue;
                text.append(lineDelimiter);
            }
        }
        if (!protectedMethods.isEmpty()) {
            i = protectedMethods.iterator();
            while (i.hasNext()) {
                stub = i.next();
                code = stub.createMethodImplementation(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append(code);
                text.append(lineDelimiter);
                if (!i.hasNext()) continue;
                text.append(lineDelimiter);
            }
        }
        if (!privateMethods.isEmpty()) {
            i = privateMethods.iterator();
            while (i.hasNext()) {
                stub = i.next();
                code = stub.createMethodImplementation(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append(code);
                text.append(lineDelimiter);
                if (!i.hasNext()) continue;
                text.append(lineDelimiter);
            }
        }
        return text.toString();
    }

    private String getIncludeString(String fileName, boolean isSystemInclude) {
        StringBuilder buf = new StringBuilder();
        buf.append("#include ");
        if (isSystemInclude) {
            buf.append('<');
        } else {
            buf.append('\"');
        }
        buf.append(fileName);
        if (isSystemInclude) {
            buf.append('>');
        } else {
            buf.append('\"');
        }
        return buf.toString();
    }

    private int findLastLineChar(String contents, int startPos) {
        int endPos = contents.length() - 1;
        int linePos = startPos;
        while (linePos <= endPos) {
            char c = contents.charAt(linePos);
            if (c == '\r') {
                if (linePos < endPos && contents.charAt(linePos + 1) == '\n') {
                    return linePos + 1;
                }
                return linePos;
            }
            if (c == '\n') {
                return linePos;
            }
            ++linePos;
        }
        return -1;
    }

    private int findFirstLineChar(String contents, int startPos) {
        int linePos = startPos;
        while (linePos >= 0) {
            char c = contents.charAt(linePos);
            if (c == '\n' || c == '\r') {
                if (linePos + 1 < startPos) {
                    return linePos + 1;
                }
                return -1;
            }
            --linePos;
        }
        return -1;
    }

    public static class CodeGeneratorException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public CodeGeneratorException(String message) {
            super((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, message, null));
        }

        public CodeGeneratorException(Throwable e) {
            super((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, e.getMessage(), e));
        }
    }
}

