/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.Comparator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.MultiItemsHolder;
import org.eclipse.cdt.internal.core.envvar.ContributedEnvironment;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;

public class MultiCfgContributedEnvironment
implements IContributedEnvironment {
    private static final IContributedEnvironment ice = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
    private boolean isMulti = false;
    private ICConfigurationDescription[] mono = new ICConfigurationDescription[1];
    private static final EnvCmp comparator = new EnvCmp();

    public void setMulti(boolean val) {
        this.isMulti = val;
    }

    public IEnvironmentVariable addVariable(String name, String value, int op, String delimiter, ICConfigurationDescription des) {
        IEnvironmentVariable v = null;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            v = ice.addVariable(name, value, op, delimiter, c);
            ++n2;
        }
        this.doReplace(des);
        return v;
    }

    private void doReplace(ICConfigurationDescription des) {
        if (this.isMulti && !this.isModifyMode()) {
            IEnvironmentVariable[] vars = this.getVariables(des);
            int i = 0;
            while (i < vars.length) {
                if (!ice.isUserVariable(des, vars[i])) {
                    vars[i] = null;
                }
                ++i;
            }
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
                ice.restoreDefaults(c);
                IEnvironmentVariable[] iEnvironmentVariableArray = vars;
                int n3 = vars.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEnvironmentVariable v = iEnvironmentVariableArray[n4];
                    if (v != null) {
                        ice.addVariable(v, c);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public boolean appendEnvironment(ICConfigurationDescription des) {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            if (!ice.appendEnvironment(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IEnvironmentVariable getVariable(String name, ICConfigurationDescription des) {
        ICConfigurationDescription[] cfs;
        IEnvironmentVariable v;
        if (!this.isMulti) {
            return ice.getVariable(name, des);
        }
        boolean any = this.getDispMode(des) == 2;
        if (any ^ (v = ice.getVariable(name, (cfs = this.getCfs(des))[0])) == null) {
            return v;
        }
        int i = 1;
        while (i < cfs.length) {
            IEnvironmentVariable w = ice.getVariable(name, cfs[i]);
            if (any && w != null) {
                return w;
            }
            if (!(any || v == null && w == null || v != null && v.equals(w))) {
                return null;
            }
            ++i;
        }
        return v;
    }

    public IEnvironmentVariable[] getVariables(ICConfigurationDescription des) {
        if (!this.isMulti) {
            return ice.getVariables(des);
        }
        ICConfigurationDescription[] cfs = this.getCfs(des);
        Object[][] evs = new IEnvironmentVariable[cfs.length][];
        int i = 0;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfs;
        int n = cfs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            evs[i++] = ice.getVariables(c);
            ++n2;
        }
        Object[] obs = CDTPrefUtil.getListForDisplay(evs, comparator);
        IEnvironmentVariable[] ev = new IEnvironmentVariable[obs.length];
        System.arraycopy(obs, 0, ev, 0, obs.length);
        return ev;
    }

    public boolean isUserVariable(ICConfigurationDescription des, IEnvironmentVariable var) {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            if (!ice.isUserVariable(c, var)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IEnvironmentVariable removeVariable(String name, ICConfigurationDescription des) {
        IEnvironmentVariable res = null;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            res = ice.removeVariable(name, c);
            ++n2;
        }
        this.doReplace(des);
        return res;
    }

    public void restoreDefaults(ICConfigurationDescription des) {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            ice.restoreDefaults(c);
            ++n2;
        }
    }

    public void setAppendEnvironment(boolean append, ICConfigurationDescription des) {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            ice.setAppendEnvironment(append, c);
            ++n2;
        }
    }

    private ICConfigurationDescription[] getCfs(ICConfigurationDescription des) {
        if (this.isMulti && des instanceof ICMultiConfigDescription) {
            return (ICConfigurationDescription[])((ICMultiConfigDescription)des).getItems();
        }
        this.mono[0] = des;
        return this.mono;
    }

    private int getDispMode(ICConfigurationDescription des) {
        if (this.isMulti && des instanceof MultiItemsHolder) {
            return CDTPrefUtil.getMultiCfgStringListDisplayMode();
        }
        return 0;
    }

    private boolean isModifyMode() {
        int wmode = CDTPrefUtil.getMultiCfgStringListWriteMode();
        return wmode == 4;
    }

    public IEnvironmentVariable addVariable(IEnvironmentVariable var, ICConfigurationDescription des) {
        IEnvironmentVariable v = null;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            v = ice.addVariable(var, c);
            ++n2;
        }
        this.doReplace(des);
        return v;
    }

    public void addVariables(IEnvironmentVariable[] vars, ICConfigurationDescription des) {
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs(des);
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            ice.addVariables(vars, c);
            ++n2;
        }
        this.doReplace(des);
    }

    public String getOrigin(IEnvironmentVariable var) {
        if (ice instanceof ContributedEnvironment) {
            return ((ContributedEnvironment)ice).getOrigin(var);
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvCmp
    implements Comparator<Object> {
        private EnvCmp() {
        }

        @Override
        public int compare(Object a0, Object a1) {
            if (a0 == null || a1 == null) {
                return 0;
            }
            if (a0 instanceof IEnvironmentVariable && a1 instanceof IEnvironmentVariable) {
                String s1;
                IEnvironmentVariable x0 = (IEnvironmentVariable)a0;
                IEnvironmentVariable x1 = (IEnvironmentVariable)a1;
                String s0 = x0.getName();
                if (s0 == null) {
                    s0 = "";
                }
                if ((s1 = x1.getName()) == null) {
                    s1 = "";
                }
                return s0.compareTo(s1);
            }
            return 0;
        }
    }
}

