/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui.hover;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.cdt.debug.ui.editors.AbstractDebugTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.cdt.ui.hover.ExpressionInformationControlCreator;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IExpressions;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

public class TCFDebugTextHover
extends AbstractDebugTextHover
implements ITextHoverExtension2 {
    public IInformationControlCreator getHoverControlCreator() {
        if (this.useExpressionExplorer()) {
            return this.createExpressionInformationControlCreator();
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    private IInformationControlCreator createExpressionInformationControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    protected boolean useExpressionExplorer() {
        return true;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (!this.useExpressionExplorer()) {
            return this.getHoverInfo(textViewer, hoverRegion);
        }
        final TCFNodeStackFrame activeFrame = this.getActiveFrame();
        if (activeFrame == null) {
            return null;
        }
        final String text = this.getExpressionText(textViewer, hoverRegion);
        if (text == null || text.length() == 0) {
            return null;
        }
        TCFNode hoverNode = (TCFNode)new TCFTask<TCFNode>(){

            public void run() {
                Object evalContext = activeFrame.isEmulated() ? activeFrame.getParent() : activeFrame;
                TCFChildren cache = evalContext.getModel().getHoverExpressionCache((TCFNode)evalContext, text);
                if (!cache.validate((Runnable)((Object)this))) {
                    return;
                }
                Map nodes = (Map)cache.getData();
                if (nodes != null) {
                    for (TCFNode node : nodes.values()) {
                        TCFDataCache value = ((TCFNodeExpression)node).getValue();
                        if (!value.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (value.getData() == null) continue;
                        this.done(node.getParent());
                        return;
                    }
                }
                this.done(null);
            }
        }.getE();
        return hoverNode;
    }

    protected boolean canEvaluate() {
        return this.getActiveFrame() != null;
    }

    private TCFNodeStackFrame getActiveFrame() {
        IAdaptable context = this.getSelectionAdaptable();
        if (context instanceof TCFNodeStackFrame) {
            return (TCFNodeStackFrame)context;
        }
        if (context instanceof TCFNodeExecContext) {
            final TCFNodeExecContext _execContext = (TCFNodeExecContext)context;
            TCFNodeStackFrame frame = (TCFNodeStackFrame)new TCFTask<TCFNodeStackFrame>(){

                public void run() {
                    TCFChildrenStackTrace stack = _execContext.getStackTrace();
                    if (!stack.validate((Runnable)((Object)this))) {
                        return;
                    }
                    this.done(stack.getTopFrame());
                }
            }.getE();
            return frame;
        }
        return null;
    }

    protected String evaluateExpression(final String expression) {
        final TCFNodeStackFrame activeFrame = this.getActiveFrame();
        if (activeFrame == null) {
            return null;
        }
        String value = (String)new TCFTask<String>(){

            public void run() {
                IChannel channel = activeFrame.getChannel();
                final IExpressions exprSvc = (IExpressions)channel.getRemoteService(IExpressions.class);
                if (exprSvc != null) {
                    TCFNodeStackFrame evalContext = activeFrame.isEmulated() ? activeFrame.getParent() : activeFrame;
                    exprSvc.create(evalContext.getID(), null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, final IExpressions.Expression context) {
                            if (error == null) {
                                exprSvc.evaluate(context.getID(), new IExpressions.DoneEvaluate(){

                                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                        if (error == null) {
                                            this.done(TCFDebugTextHover.getValueText(value));
                                        } else {
                                            this.done(null);
                                        }
                                        exprSvc.dispose(context.getID(), new IExpressions.DoneDispose(){

                                            public void doneDispose(IToken token, Exception error) {
                                            }
                                        });
                                    }
                                });
                            } else {
                                this.done(null);
                            }
                        }
                    });
                } else {
                    this.done(null);
                }
            }
        }.getE();
        return value;
    }

    private static String getValueText(IExpressions.Value value) {
        BigInteger bigInteger = TCFDebugTextHover.toBigInteger(value.getValue(), value.isBigEndian(), true);
        switch (value.getTypeClass()) {
            case integer: {
                return bigInteger.toString();
            }
            case real: {
                if (value.getValue().length <= 4) {
                    return String.valueOf(Float.intBitsToFloat(bigInteger.intValue()));
                }
                if (value.getValue().length <= 8) {
                    return String.valueOf(Double.longBitsToDouble(bigInteger.longValue()));
                }
                return "N/A";
            }
        }
        return "0x" + bigInteger.toString(16);
    }

    private static BigInteger toBigInteger(byte[] data, boolean big_endian, boolean sign_extension) {
        byte[] temp = null;
        if (sign_extension) {
            temp = new byte[data.length];
        } else {
            temp = new byte[data.length + 1];
            temp[0] = 0;
        }
        if (big_endian) {
            System.arraycopy(data, 0, temp, sign_extension ? 0 : 1, data.length);
        } else {
            int i = 0;
            while (i < data.length) {
                temp[temp.length - i - 1] = data[i];
                ++i;
            }
        }
        return new BigInteger(temp);
    }
}

