/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.core;

import java.text.DecimalFormatSymbols;
import org.eclipse.tm.tcf.protocol.Protocol;

public class LoggingUtil {
    private static final char DECIMAL_DELIMITER = new DecimalFormatSymbols().getDecimalSeparator();

    public static String getDebugTime() {
        StringBuilder traceBuilder = new StringBuilder();
        long time = System.currentTimeMillis();
        long seconds = time / 1000L % 1000L;
        if (seconds < 100L) {
            traceBuilder.append('0');
        }
        if (seconds < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(seconds);
        traceBuilder.append(DECIMAL_DELIMITER);
        long millis = time % 1000L;
        if (millis < 100L) {
            traceBuilder.append('0');
        }
        if (millis < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(millis);
        return traceBuilder.toString();
    }

    public static void trace(String msg) {
        Protocol.log(String.valueOf(LoggingUtil.getDebugTime()) + ' ' + msg, null);
    }
}

