/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IRegisters;

public class RegistersProxy
implements IRegisters {
    private final IChannel channel;
    private final Map<IRegisters.RegistersListener, IChannel.IEventListener> listeners = new HashMap<IRegisters.RegistersListener, IChannel.IEventListener>();

    static {
        JSON.addObjectWriter(IRegisters.Location.class, new JSON.ObjectWriter<IRegisters.Location>(){

            @Override
            public void write(IRegisters.Location l) throws IOException {
                JSON.write('[');
                JSON.writeObject(l.id);
                JSON.write(',');
                JSON.writeUInt(l.offs);
                JSON.write(',');
                JSON.writeUInt(l.size);
                JSON.write(']');
            }
        });
    }

    public RegistersProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "Registers";
    }

    public IToken getChildren(String parent_context_id, final IRegisters.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = RegistersProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, arr);
            }
        }.token;
    }

    public IToken getContext(String id, final IRegisters.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Context ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new Context((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    public IToken getm(IRegisters.Location[] locs, final IRegisters.DoneGet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getm", (Object[])new Object[]{locs}){

            public void done(Exception error, Object[] args) {
                byte[] val = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    val = JSON.toByteArray(args[1]);
                }
                done.doneGet(this.token, error, val);
            }
        }.token;
    }

    public IToken setm(IRegisters.Location[] locs, byte[] value, final IRegisters.DoneSet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"setm", (Object[])new Object[]{locs, new JSON.Binary((byte[])value, (int)0, (int)value.length)}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneSet(this.token, error);
            }
        }.token;
    }

    public void addListener(final IRegisters.RegistersListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            public void event(String name, byte[] data) {
                block5: {
                    try {
                        Object[] args = JSON.parseSequence(data);
                        if (name.equals("contextChanged")) {
                            listener.contextChanged();
                            break block5;
                        }
                        if (name.equals("registerChanged")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.registerChanged((String)args[0]);
                            break block5;
                        }
                        throw new IOException("Registers service: unknown event: " + name);
                    }
                    catch (Throwable x) {
                        RegistersProxy.this.channel.terminate(x);
                    }
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    public void removeListener(IRegisters.RegistersListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    private int[] toIntArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        int i = 0;
        int[] arr = new int[c.size()];
        for (Number n : c) {
            arr[i++] = n.intValue();
        }
        return arr;
    }

    private String[][] toPathArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        int i = 0;
        String[][] r = new String[c.size()][];
        for (Collection p : c) {
            r[i++] = p.toArray(new String[p.size()]);
        }
        return r;
    }

    private IRegisters.NamedValue[] toValuesArray(Object o) {
        Collection c = (Collection)o;
        if (c == null) {
            return null;
        }
        int i = 0;
        IRegisters.NamedValue[] arr = new IRegisters.NamedValue[c.size()];
        for (Map m : c) {
            arr[i++] = new NamedValueInfo(m);
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context
    implements IRegisters.RegistersContext {
        private final Map<String, Object> props;

        Context(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public int[] getBitNumbers() {
            return RegistersProxy.this.toIntArray(this.props.get("Bits"));
        }

        @Override
        public String getDescription() {
            return (String)this.props.get("Description");
        }

        @Override
        public int getFirstBitNumber() {
            Number n = (Number)this.props.get("FirstBit");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getName() {
            return (String)this.props.get("Name");
        }

        @Override
        public IRegisters.NamedValue[] getNamedValues() {
            return RegistersProxy.this.toValuesArray(this.props.get("Values"));
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public int getSize() {
            Number n = (Number)this.props.get("Size");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        @Override
        public boolean hasSideEffects() {
            Boolean n = (Boolean)this.props.get("SideEffects");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isBigEndian() {
            Boolean n = (Boolean)this.props.get("BigEndian");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isFloat() {
            Boolean n = (Boolean)this.props.get("Float");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isLeftToRight() {
            Boolean n = (Boolean)this.props.get("LeftToRight");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isReadOnce() {
            Boolean n = (Boolean)this.props.get("ReadOnce");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isReadable() {
            Boolean n = (Boolean)this.props.get("Readable");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isVolatile() {
            Boolean n = (Boolean)this.props.get("Volatile");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isWriteOnce() {
            Boolean n = (Boolean)this.props.get("WriteOnce");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean isWriteable() {
            Boolean n = (Boolean)this.props.get("Writeable");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public Collection<String> canSearch() {
            return (Collection)this.props.get("CanSearch");
        }

        @Override
        public Number getMemoryAddress() {
            return (Number)this.props.get("MemoryAddress");
        }

        @Override
        public String getMemoryContext() {
            return (String)this.props.get("MemoryContext");
        }

        @Override
        public String getProcessID() {
            return (String)this.props.get("ProcessID");
        }

        @Override
        public String getRole() {
            return (String)this.props.get("Role");
        }

        @Override
        public IToken get(final IRegisters.DoneGet done) {
            return new Command((IChannel)((RegistersProxy)RegistersProxy.this).channel, (IService)RegistersProxy.this, (String)"get", (Object[])new Object[]{this.getID()}){

                public void done(Exception error, Object[] args) {
                    byte[] val = null;
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 2) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                        val = JSON.toByteArray(args[1]);
                    }
                    done.doneGet(this.token, error, val);
                }
            }.token;
        }

        @Override
        public IToken set(byte[] value, final IRegisters.DoneSet done) {
            return new Command((IChannel)((RegistersProxy)RegistersProxy.this).channel, (IService)RegistersProxy.this, (String)"set", (Object[])new Object[]{this.getID(), new JSON.Binary((byte[])value, (int)0, (int)value.length)}){

                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                    }
                    done.doneSet(this.token, error);
                }
            }.token;
        }

        @Override
        public IToken search(Map<String, Object> filter, final IRegisters.DoneSearch done) {
            return new Command((IChannel)((RegistersProxy)RegistersProxy.this).channel, (IService)RegistersProxy.this, (String)"search", (Object[])new Object[]{this.getID(), filter}){

                public void done(Exception error, Object[] args) {
                    String[][] paths = null;
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 2) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                        paths = RegistersProxy.this.toPathArray(args[1]);
                    }
                    done.doneSearch(this.token, error, paths);
                }
            }.token;
        }

        public String toString() {
            return "[Registers Context " + this.props.toString() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamedValueInfo
    implements IRegisters.NamedValue {
        private final String desc;
        private final String name;
        private final byte[] value;

        NamedValueInfo(Map<String, Object> m) {
            this.desc = (String)m.get("Description");
            this.name = (String)m.get("Name");
            this.value = JSON.toByteArray(m.get("Value"));
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }
    }
}

