/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IStreams;

public class StreamsProxy
implements IStreams {
    private final IChannel channel;
    private final Map<IStreams.StreamsListener, IChannel.IEventListener> listeners = new HashMap<IStreams.StreamsListener, IChannel.IEventListener>();

    public StreamsProxy(IChannel channel) {
        this.channel = channel;
    }

    public IToken connect(String stream_id, final IStreams.DoneConnect done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"connect", (Object[])new Object[]{stream_id}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneConnect(this.token, error);
            }
        }.token;
    }

    public IToken disconnect(String stream_id, final IStreams.DoneDisconnect done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"disconnect", (Object[])new Object[]{stream_id}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneDisconnect(this.token, error);
            }
        }.token;
    }

    public IToken eos(String stream_id, final IStreams.DoneEOS done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"eos", (Object[])new Object[]{stream_id}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneEOS(this.token, error);
            }
        }.token;
    }

    public IToken read(String stream_id, int size, final IStreams.DoneRead done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"read", (Object[])new Object[]{stream_id, Integer.valueOf((int)size)}){

            public void done(Exception error, Object[] args) {
                int lost_size = 0;
                byte[] data = null;
                boolean eos = false;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 4) {
                        throw new AssertionError();
                    }
                    data = JSON.toByteArray(args[0]);
                    error = this.toError(args[1]);
                    lost_size = ((Number)args[2]).intValue();
                    eos = (Boolean)args[3];
                }
                done.doneRead(this.token, error, lost_size, data, eos);
            }
        }.token;
    }

    public IToken subscribe(String stream_type, final IStreams.StreamsListener listener, final IStreams.DoneSubscribe done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"subscribe", (Object[])new Object[]{stream_type}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                if (error == null) {
                    IChannel.IEventListener l = new IChannel.IEventListener(){

                        public void event(String name, byte[] data) {
                            block8: {
                                try {
                                    Object[] args = JSON.parseSequence(data);
                                    if (name.equals("created")) {
                                        if (args.length == 3) {
                                            listener.created((String)args[0], (String)args[1], (String)args[2]);
                                        } else {
                                            if (!$assertionsDisabled && args.length != 2) {
                                                throw new AssertionError();
                                            }
                                            listener.created((String)args[0], (String)args[1], null);
                                        }
                                        break block8;
                                    }
                                    if (name.equals("disposed")) {
                                        if (!$assertionsDisabled && args.length != 2) {
                                            throw new AssertionError();
                                        }
                                        listener.disposed((String)args[0], (String)args[1]);
                                        break block8;
                                    }
                                    throw new IOException("Streams service: unknown event: " + name);
                                }
                                catch (Throwable x) {
                                    StreamsProxy.this.channel.terminate(x);
                                }
                            }
                        }
                    };
                    StreamsProxy.this.listeners.put(listener, l);
                    StreamsProxy.this.channel.addEventListener(StreamsProxy.this, l);
                }
                done.doneSubscribe(this.token, error);
            }
        }.token;
    }

    public IToken unsubscribe(String stream_type, final IStreams.StreamsListener listener, final IStreams.DoneUnsubscribe done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"unsubscribe", (Object[])new Object[]{stream_type}){

            public void done(Exception error, Object[] args) {
                IChannel.IEventListener l;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                if (error == null && (l = (IChannel.IEventListener)StreamsProxy.this.listeners.remove(listener)) != null) {
                    StreamsProxy.this.channel.removeEventListener(StreamsProxy.this, l);
                }
                done.doneUnsubscribe(this.token, error);
            }
        }.token;
    }

    public IToken write(String stream_id, byte[] buf, int offset, int size, final IStreams.DoneWrite done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"write", (Object[])new Object[]{stream_id, Integer.valueOf((int)size), new JSON.Binary((byte[])buf, (int)offset, (int)size)}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneWrite(this.token, error);
            }
        }.token;
    }

    public String getName() {
        return "Streams";
    }
}

