/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.eclipse.tm.internal.tcf.core.Token;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.core.ErrorReport;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command
implements IChannel.ICommandListener {
    private final IService service;
    private final String command;
    private final Object[] args;
    public final IToken token;
    private boolean done;
    private static final SimpleDateFormat timestamp_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public Command(IChannel channel, IService service, String command, Object[] args) {
        this.service = service;
        this.command = command;
        this.args = args;
        IToken t = null;
        try {
            boolean zero_copy = ((AbstractChannel)channel).isZeroCopySupported();
            t = channel.sendCommand(service, command, JSON.toJSONSequence(args, zero_copy), this);
        }
        catch (Throwable y) {
            t = new Token();
            final Exception x = y instanceof Exception ? (Exception)y : new Exception(y);
            Protocol.invokeLater(new Runnable(){

                public void run() {
                    if (!$assertionsDisabled && Command.this.done) {
                        throw new AssertionError();
                    }
                    Command.this.done = true;
                    Command.this.done(x, null);
                }
            });
        }
        this.token = t;
    }

    @Override
    public void progress(IToken token, byte[] data) {
        assert (this.token == token);
    }

    @Override
    public void result(IToken token, byte[] data) {
        assert (this.token == token);
        Exception error = null;
        Object[] args = null;
        try {
            args = JSON.parseSequence(data);
        }
        catch (Exception e) {
            error = e;
        }
        assert (!this.done);
        this.done = true;
        this.done(error, args);
    }

    @Override
    public void terminated(IToken token, Exception error) {
        assert (this.token == token);
        assert (!this.done);
        this.done = true;
        this.done(error, null);
    }

    public abstract void done(Exception var1, Object[] var2);

    public String getCommandString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.service.getName());
        buf.append(' ');
        buf.append(this.command);
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                buf.append(i == 0 ? " " : ", ");
                try {
                    buf.append(JSON.toJSON(this.args[i]));
                }
                catch (IOException x) {
                    buf.append("***");
                    buf.append(x.getMessage());
                    buf.append("***");
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public static String toErrorString(Object data) {
        if (data == null) {
            return null;
        }
        Map map = (Map)data;
        String fmt = (String)map.get("Format");
        if (fmt != null) {
            Collection c = (Collection)map.get("Params");
            if (c != null) {
                return new MessageFormat(fmt).format(c.toArray());
            }
            return fmt;
        }
        Number code = (Number)map.get("Code");
        if (code != null) {
            if (code.intValue() == 1) {
                String alt_org = (String)map.get("AltOrg");
                Number alt_code = (Number)map.get("AltCode");
                if (alt_org != null && alt_code != null) {
                    return String.valueOf(alt_org) + " Error " + alt_code;
                }
            }
            return "TCF Error " + code;
        }
        return "Invalid error report format";
    }

    static void appendErrorProps(StringBuffer bf, Map<String, Object> map) {
        Number time = (Number)map.get("Time");
        Number code = (Number)map.get("Code");
        String service = (String)map.get("Service");
        Number severity = (Number)map.get("Severity");
        Number alt_code = (Number)map.get("AltCode");
        String alt_org = (String)map.get("AltOrg");
        if (time != null) {
            bf.append('\n');
            bf.append("Time: ");
            bf.append(timestamp_format.format(new Date(time.longValue())));
        }
        if (severity != null) {
            bf.append('\n');
            bf.append("Severity: ");
            switch (severity.intValue()) {
                case 0: {
                    bf.append("Error");
                }
                case 2: {
                    bf.append("Fatal");
                }
                case 1: {
                    bf.append("Warning");
                }
            }
            bf.append("Unknown");
        }
        bf.append('\n');
        bf.append("Error text: ");
        bf.append(Command.toErrorString(map));
        bf.append('\n');
        bf.append("Error code: ");
        bf.append(code);
        if (service != null) {
            bf.append('\n');
            bf.append("Service: ");
            bf.append(service);
        }
        if (alt_code != null) {
            bf.append('\n');
            bf.append("Alt code: ");
            bf.append(alt_code);
            if (alt_org != null) {
                bf.append('\n');
                bf.append("Alt org: ");
                bf.append(alt_org);
            }
        }
    }

    public Exception toError(Object data) {
        return this.toError(data, true);
    }

    public Exception toError(Object data, boolean include_command_text) {
        if (data == null) {
            return null;
        }
        Map map = (Map)data;
        StringBuffer bf = new StringBuffer();
        bf.append("TCF error report:");
        bf.append('\n');
        if (include_command_text) {
            String cmd = this.getCommandString();
            if (cmd.length() > 120) {
                cmd = String.valueOf(cmd.substring(0, 120)) + "...";
            }
            bf.append("Command: ");
            bf.append(cmd);
        }
        Command.appendErrorProps(bf, map);
        return new ErrorReport(bf.toString(), map);
    }
}

