/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpoint;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class TCFModelPresentation
implements IDebugModelPresentation {
    private final Collection<ILabelProviderListener> listeners = new HashSet<ILabelProviderListener>();
    private static final TCFModelPresentation default_instance = new TCFModelPresentation();

    public static TCFModelPresentation getDefault() {
        return default_instance;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof TCFBreakpoint) {
            TCFBreakpoint breakpoint = (TCFBreakpoint)element;
            descriptor = ImageCache.getImageDescriptor("icons/full/obj16/brkpd_obj.gif");
            try {
                if (breakpoint.isEnabled()) {
                    descriptor = ImageCache.getImageDescriptor("icons/full/obj16/brkp_obj.gif");
                }
            }
            catch (CoreException coreException) {}
        }
        if (descriptor != null) {
            return ImageCache.getImage(descriptor);
        }
        return null;
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof TCFBreakpoint) {
            final TCFBreakpoint breakpoint = (TCFBreakpoint)element;
            text = breakpoint.getText();
            String status = (String)new TCFTask<String>(){

                public void run() {
                    this.done(Activator.getAnnotationManager().getBreakpointStatus(breakpoint));
                }
            }.getE();
            if (status != null) {
                text = String.valueOf(text) + " (" + status + ")";
            }
        }
        return text;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IEditorRegistry registry;
        IEditorDescriptor descriptor;
        String id = null;
        if (input != null && (descriptor = (registry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(input.getName())) != null) {
            id = descriptor.getId();
        }
        return id;
    }

    public IEditorInput getEditorInput(Object element) {
        IPath fullPath;
        URI uri;
        if (element instanceof ILineBreakpoint) {
            element = ((ILineBreakpoint)element).getMarker();
        }
        if (element instanceof IMarker) {
            element = ((IMarker)element).getResource();
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IStorage && (uri = URIUtil.toURI((IPath)(fullPath = ((IStorage)element).getFullPath()))) != null) {
            try {
                return new FileStoreEditorInput(EFS.getStore((URI)uri));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return null;
    }
}

