/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import java.math.BigInteger;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpoint;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchPart;

public class BreakpointCommand
implements IToggleBreakpointsTargetExtension {
    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        final Object obj = ((IStructuredSelection)selection).getFirstElement();
        return (Boolean)new TCFTask<Boolean>(){

            public void run() {
                TCFDataCache<BigInteger> addr_cache = null;
                if (obj instanceof TCFNodeExecContext) {
                    addr_cache = ((TCFNodeExecContext)obj).getAddress();
                }
                if (obj instanceof TCFNodeStackFrame) {
                    addr_cache = ((TCFNodeStackFrame)obj).getAddress();
                }
                if (addr_cache != null) {
                    if (!addr_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    this.done(addr_cache.getData() != null);
                } else {
                    this.done(false);
                }
            }
        }.getE();
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection.isEmpty()) {
            return;
        }
        final Object obj = ((IStructuredSelection)selection).getFirstElement();
        CoreException x = (CoreException)((Object)new TCFTask<CoreException>(){

            public void run() {
                try {
                    TCFDataCache<BigInteger> addr_cache = null;
                    if (obj instanceof TCFNodeExecContext) {
                        addr_cache = ((TCFNodeExecContext)obj).getAddress();
                    }
                    if (obj instanceof TCFNodeStackFrame) {
                        addr_cache = ((TCFNodeStackFrame)obj).getAddress();
                    }
                    if (addr_cache != null) {
                        if (!addr_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        BigInteger addr = (BigInteger)addr_cache.getData();
                        if (addr != null) {
                            HashMap<String, Object> m = new HashMap<String, Object>();
                            m.put("Enabled", Boolean.TRUE);
                            m.put("Location", addr.toString());
                            new TCFBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), m);
                        }
                    }
                    this.done(null);
                }
                catch (CoreException x) {
                    this.done((Object)x);
                }
            }
        }.getE());
        if (x != null) {
            throw x;
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }
}

