/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.launch.setup;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class TimeOutInputStream
extends FilterInputStream {
    private byte[] buf;
    private int buf_inp = 0;
    private int buf_out = 0;
    private boolean eof = false;
    private IOException err;
    private InputStream inp;
    private long time = 0L;
    private Thread thread;

    TimeOutInputStream(InputStream in, long time) {
        this(in, 4096, time);
    }

    TimeOutInputStream(InputStream in, int size, long time) {
        super(in);
        this.inp = in;
        this.buf = new byte[size];
        this.time = time;
        this.thread = new Prefetch();
        this.thread.start();
    }

    public void setTimeOut(long time) {
        this.time = time;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int read() throws IOException {
        try {
            int cnt = 0;
            while (true) {
                if (this.buf_inp != this.buf_out) {
                    int res = this.buf[this.buf_out] & 0xFF;
                    this.buf_out = (this.buf_out + 1) % this.buf.length;
                    this.notify();
                    return res;
                }
                if (this.err != null) {
                    throw new IOException(this.err.getMessage());
                }
                if (this.eof) {
                    return -1;
                }
                if (this.time != 0L) {
                    if (cnt > 0) {
                        throw new IOException("Time Out");
                    }
                    this.wait(this.time);
                    ++cnt;
                    continue;
                }
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        boolean nfy = false;
        try {
            int res = 0;
            while (res < len) {
                int cnt = 0;
                while (this.buf_inp == this.buf_out) {
                    if (res > 0) {
                        int n = res;
                        return n;
                    }
                    if (this.err != null) {
                        throw new IOException(this.err.getMessage());
                    }
                    if (this.eof) {
                        return -1;
                    }
                    if (nfy) {
                        this.notify();
                        nfy = false;
                    }
                    if (this.time != 0L) {
                        if (cnt > 0) {
                            throw new IOException("Time Out");
                        }
                        this.wait(this.time);
                        ++cnt;
                        continue;
                    }
                    this.wait();
                }
                b[off++] = this.buf[this.buf_out];
                this.buf_out = (this.buf_out + 1) % this.buf.length;
                nfy = true;
                ++res;
            }
            int n = res;
            return n;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
        finally {
            if (nfy) {
                this.notify();
            }
        }
    }

    public synchronized int available() throws IOException {
        return (this.buf_inp - this.buf_out + this.buf.length) % this.buf.length;
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                while (!this.eof) {
                    this.wait();
                }
                this.thread = null;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
    }

    private class Prefetch
    extends Thread {
        private Prefetch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block28: {
                try {
                    int rd;
                    while ((rd = TimeOutInputStream.this.inp.read()) >= 0) {
                        TimeOutInputStream timeOutInputStream = TimeOutInputStream.this;
                        synchronized (timeOutInputStream) {
                            int new_inp = (TimeOutInputStream.this.buf_inp + 1) % TimeOutInputStream.this.buf.length;
                            while (new_inp == TimeOutInputStream.this.buf_out) {
                                TimeOutInputStream.this.wait();
                            }
                            ((TimeOutInputStream)TimeOutInputStream.this).buf[((TimeOutInputStream)TimeOutInputStream.this).buf_inp] = (byte)rd;
                            TimeOutInputStream.this.buf_inp = new_inp;
                            TimeOutInputStream.this.notify();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    TimeOutInputStream.this.err = new InterruptedIOException();
                    TimeOutInputStream timeOutInputStream = TimeOutInputStream.this;
                    synchronized (timeOutInputStream) {
                        TimeOutInputStream.this.eof = true;
                        TimeOutInputStream.this.notify();
                        break block28;
                    }
                }
                catch (InterruptedIOException x) {
                    TimeOutInputStream.this.err = x;
                    TimeOutInputStream timeOutInputStream = TimeOutInputStream.this;
                    synchronized (timeOutInputStream) {
                        TimeOutInputStream.this.eof = true;
                        TimeOutInputStream.this.notify();
                        break block28;
                    }
                }
                catch (IOException x) {
                    TimeOutInputStream.this.err = x;
                    TimeOutInputStream timeOutInputStream = TimeOutInputStream.this;
                    {
                        catch (Throwable throwable) {
                            TimeOutInputStream timeOutInputStream2 = TimeOutInputStream.this;
                            synchronized (timeOutInputStream2) {
                                TimeOutInputStream.this.eof = true;
                                TimeOutInputStream.this.notify();
                            }
                            throw throwable;
                        }
                    }
                    synchronized (timeOutInputStream) {
                        TimeOutInputStream.this.eof = true;
                        TimeOutInputStream.this.notify();
                        break block28;
                    }
                }
                TimeOutInputStream timeOutInputStream = TimeOutInputStream.this;
                synchronized (timeOutInputStream) {
                    TimeOutInputStream.this.eof = true;
                    TimeOutInputStream.this.notify();
                }
            }
        }
    }
}

