/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRunControl;

public class TCFChildrenExecContext
extends TCFChildren {
    private final TCFChildren mem_children;
    private final TCFChildren run_children;

    TCFChildrenExecContext(TCFNode node) {
        super(node);
        this.mem_children = new TCFChildren(node){

            protected boolean startDataRetrieval() {
                IMemory mem = (IMemory)this.node.model.getLaunch().getService(IMemory.class);
                if (mem == null) {
                    this.set(null, null, new HashMap<String, TCFNode>());
                    return true;
                }
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                this.command = mem.getChildren(this.node.id, new IMemory.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                        HashMap<String, TCFNode> data = null;
                        if (command == token && error == null) {
                            int cnt = 0;
                            data = new HashMap<String, TCFNode>();
                            String[] stringArray = contexts;
                            int n = contexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String id = stringArray[n2];
                                TCFNode n3 = node.model.getNode(id);
                                if (n3 == null) {
                                    n3 = new TCFNodeExecContext(node, id);
                                }
                                ((TCFNodeExecContext)n3).setMemSeqNo(cnt++);
                                if (!$assertionsDisabled && n3.parent != node) {
                                    throw new AssertionError();
                                }
                                data.put(id, n3);
                                ++n2;
                            }
                        }
                        this.set(token, (Throwable)error, data);
                    }
                });
                return false;
            }
        };
        this.run_children = new TCFChildren(node){

            protected boolean startDataRetrieval() {
                IRunControl run = (IRunControl)this.node.model.getLaunch().getService(IRunControl.class);
                if (run == null) {
                    this.set(null, null, new HashMap<String, TCFNode>());
                    return true;
                }
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                this.command = run.getChildren(this.node.id, new IRunControl.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                        HashMap<String, TCFNode> data = null;
                        if (command == token && error == null) {
                            int cnt = 0;
                            data = new HashMap<String, TCFNode>();
                            String[] stringArray = contexts;
                            int n = contexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String id = stringArray[n2];
                                TCFNode n3 = node.model.getNode(id);
                                if (n3 == null) {
                                    n3 = new TCFNodeExecContext(node, id);
                                }
                                ((TCFNodeExecContext)n3).setExeSeqNo(cnt++);
                                if (!$assertionsDisabled && n3.parent != node) {
                                    throw new AssertionError();
                                }
                                data.put(id, n3);
                                ++n2;
                            }
                        }
                        this.set(token, (Throwable)error, data);
                    }
                });
                return false;
            }
        };
    }

    protected boolean startDataRetrieval() {
        TCFChildren pending = null;
        if (!this.mem_children.validate()) {
            pending = this.mem_children;
        }
        if (!this.run_children.validate()) {
            pending = this.run_children;
        }
        if (pending != null) {
            pending.wait((Runnable)((Object)this));
            return false;
        }
        Throwable error = this.mem_children.getError();
        if (error == null) {
            error = this.run_children.getError();
        }
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        Map m1 = (Map)this.mem_children.getData();
        Map m2 = (Map)this.run_children.getData();
        if (m1 != null) {
            data.putAll(m1);
        }
        if (m2 != null) {
            data.putAll(m2);
        }
        this.set(null, error, data);
        return true;
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        this.reset();
        this.run_children.reset();
        this.mem_children.reset();
        assert (!this.node.isDisposed());
        String id = context.getID();
        TCFNodeExecContext n = (TCFNodeExecContext)this.node.model.getNode(id);
        if (n == null) {
            n = new TCFNodeExecContext(this.node, id);
            n.postContextAddedDelta();
            this.add(n);
        } else {
            n.postAllChangedDelta();
        }
        this.run_children.add(n);
        n.setRunContext(context);
    }

    void onContextAdded(IMemory.MemoryContext context) {
        this.reset();
        this.run_children.reset();
        this.mem_children.reset();
        assert (!this.node.isDisposed());
        String id = context.getID();
        TCFNodeExecContext n = (TCFNodeExecContext)this.node.model.getNode(id);
        if (n == null) {
            n = new TCFNodeExecContext(this.node, id);
            n.postContextAddedDelta();
            this.add(n);
        } else {
            n.postAllChangedDelta();
        }
        this.mem_children.add(n);
        n.setMemoryContext(context);
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExecContext)n).onMemoryMapChanged();
        }
    }
}

