/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.tcf.Activator;
import org.eclipse.tm.tcf.extensions.TcfExtensionPointComparator;
import org.eclipse.tm.tcf.extensions.TcfExtensionProxy;
import org.eclipse.tm.tcf.internal.nls.TcfPluginMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TcfAbstractExtensionPointManager<V> {
    private boolean fInitialized = false;
    private Map<String, TcfExtensionProxy<V>> fExtensions = new LinkedHashMap<String, TcfExtensionProxy<V>>();
    private TcfExtensionPointComparator fComparator = null;

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    protected Map<String, TcfExtensionProxy<V>> getExtensions() {
        if (!this.isInitialized()) {
            this.loadExtensions();
            this.setInitialized(true);
        }
        return this.fExtensions;
    }

    protected IExtension[] getExtensionsSorted(IExtensionPoint point) {
        assert (point != null);
        ArrayList<IExtension> extensions = new ArrayList<IExtension>(Arrays.asList(point.getExtensions()));
        if (extensions.size() > 0) {
            Collections.sort(extensions, this.getExtensionPointComparator());
        }
        return extensions.toArray(new IExtension[extensions.size()]);
    }

    protected final TcfExtensionPointComparator getExtensionPointComparator() {
        if (this.fComparator == null) {
            this.fComparator = this.doCreateExtensionPointComparator();
        }
        return this.fComparator;
    }

    protected TcfExtensionPointComparator doCreateExtensionPointComparator() {
        return new TcfExtensionPointComparator();
    }

    protected abstract String getExtensionPointId();

    protected abstract String getConfigurationElementName();

    protected TcfExtensionProxy<V> doCreateExtensionProxy(IConfigurationElement element) throws CoreException {
        assert (element != null);
        return new TcfExtensionProxy(element);
    }

    protected void loadExtensions() {
        if (this.isInitialized()) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(this.getExtensionPointId());
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = this.getExtensionsSorted(point);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block9: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (this.getConfigurationElementName().equals(element.getName())) {
                            try {
                                TcfExtensionProxy<V> candidate = this.doCreateExtensionProxy(element);
                                if (candidate.getId() != null) {
                                    if (!this.fExtensions.containsKey(candidate.getId())) {
                                        this.fExtensions.put(candidate.getId(), candidate);
                                        break block9;
                                    }
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.tm.tcf", 0, NLS.bind((String)TcfPluginMessages.Extension_error_duplicateExtension, (Object)candidate.getId(), (Object)element.getContributor().getName()), null));
                                }
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.tm.tcf", 0, NLS.bind((String)TcfPluginMessages.Extension_error_missingRequiredAttribute, (Object)"id", (Object)element.getAttribute("label")), null));
                            }
                            catch (CoreException e) {
                                Status status = new Status(4, "org.eclipse.tm.tcf", NLS.bind((String)TcfPluginMessages.Extension_error_invalidExtensionPoint, (Object)element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e);
                                Activator.getDefault().getLog().log((IStatus)status);
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

