/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core.model;

import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblemMultiple;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemElement;

public class CodanProblem
extends CodanProblemElement
implements IProblemWorkingCopy,
Cloneable,
IProblemMultiple {
    private String id;
    private String name;
    private String messagePattern;
    private CodanSeverity severity = CodanSeverity.Warning;
    private boolean enabled = true;
    private IProblemPreference rootPreference;
    private String description;
    private String markerType = "org.eclipse.cdt.codan.core.codanProblem";
    private boolean multiple;

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public CodanSeverity getSeverity() {
        return this.severity;
    }

    public CodanProblem(String problemId, String name) {
        this.id = problemId;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSeverity(CodanSeverity sev) {
        if (sev == null) {
            throw new NullPointerException();
        }
        this.checkSet();
        this.severity = sev;
        this.notifyChanged("problem");
    }

    public void setEnabled(boolean checked) {
        this.checkSet();
        this.enabled = checked;
        this.notifyChanged("problem");
    }

    public Object clone() {
        CodanProblem prob = (CodanProblem)super.clone();
        if (this.rootPreference != null) {
            prob.rootPreference = (IProblemPreference)this.rootPreference.clone();
        }
        return prob;
    }

    public void setPreference(IProblemPreference value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.rootPreference = value;
        this.notifyChanged("problem_params");
    }

    public IProblemPreference getPreference() {
        return this.rootPreference;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.checkSet();
        this.messagePattern = messagePattern;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.checkSet();
        this.description = desc;
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(String markerType) {
        this.checkSet();
        this.markerType = markerType;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isOriginal() {
        return !this.id.contains(".COPY");
    }
}

