/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.rewrite.DeclarationGenerator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationGeneratorImpl
extends DeclarationGenerator {
    private INodeFactory factory;

    public DeclarationGeneratorImpl(INodeFactory factory) {
        this.factory = factory;
    }

    @Override
    public IASTDeclSpecifier createDeclSpecFromType(IType type) {
        IType inner;
        IASTDeclSpecifier returnedDeclSpec = null;
        if (type instanceof IPointerType) {
            inner = ((IPointerType)type).getType();
            returnedDeclSpec = this.createDeclSpecFromType(inner);
        } else if (type instanceof ICPPReferenceType) {
            inner = ((ICPPReferenceType)type).getType();
            returnedDeclSpec = this.createDeclSpecFromType(inner);
        } else if (type instanceof IArrayType) {
            inner = ((IArrayType)type).getType();
            returnedDeclSpec = this.createDeclSpecFromType(inner);
        } else if (type instanceof IFunctionType) {
            inner = ((IFunctionType)type).getReturnType();
            returnedDeclSpec = this.createDeclSpecFromType(inner);
        } else if (type instanceof IQualifierType) {
            inner = ((IQualifierType)type).getType();
            returnedDeclSpec = this.createDeclSpecFromType(inner);
            if (((IQualifierType)type).isConst()) {
                returnedDeclSpec.setConst(true);
            }
            if (((IQualifierType)type).isVolatile()) {
                returnedDeclSpec.setVolatile(true);
            }
        } else if (type instanceof IBasicType) {
            IBasicType basicType = (IBasicType)type;
            IASTSimpleDeclSpecifier declSpec = this.factory.newSimpleDeclSpecifier();
            declSpec.setType(basicType.getKind());
            declSpec.setComplex(basicType.isComplex());
            declSpec.setImaginary(basicType.isImaginary());
            declSpec.setShort(basicType.isShort());
            declSpec.setLong(basicType.isLong());
            declSpec.setLongLong(basicType.isLongLong());
            declSpec.setSigned(basicType.isSigned());
            declSpec.setUnsigned(basicType.isUnsigned());
            returnedDeclSpec = declSpec;
        } else if (type instanceof ICPPTemplateInstance) {
            returnedDeclSpec = this.getDeclSpecForTemplate((ICPPTemplateInstance)((Object)type));
        } else if (type instanceof IBinding) {
            returnedDeclSpec = this.getDeclSpecForBinding((IBinding)((Object)type));
        }
        if (returnedDeclSpec == null) {
            IASTSimpleDeclSpecifier specifier = this.factory.newSimpleDeclSpecifier();
            specifier.setType(IBasicType.Kind.eVoid);
            returnedDeclSpec = specifier;
        }
        return returnedDeclSpec;
    }

    @Override
    public IASTDeclarator createDeclaratorFromType(IType type, char[] name) {
        IASTDeclarator returnedDeclarator = null;
        try {
            HashMap<IASTDeclarator, LinkedList<IASTPointerOperator>> pointerOperatorMap = new HashMap<IASTDeclarator, LinkedList<IASTPointerOperator>>();
            IASTName newName = name != null ? this.factory.newName(name) : this.factory.newName();
            boolean replaceInitialArrayWithPointer = true;
            boolean changeInitialFunctionToFuncPtr = true;
            while (this.typeNeedsNontrivialDeclarator(type)) {
                if (replaceInitialArrayWithPointer && type instanceof IArrayType) {
                    returnedDeclarator = this.factory.newDeclarator(newName);
                    returnedDeclarator.addPointerOperator(this.factory.newPointer());
                    type = ((IArrayType)type).getType();
                } else if (changeInitialFunctionToFuncPtr && type instanceof IFunctionType) {
                    returnedDeclarator = this.factory.newDeclarator(newName);
                    returnedDeclarator.addPointerOperator(this.factory.newPointer());
                } else if (type instanceof IArrayType) {
                    IArrayType arrayType = (IArrayType)type;
                    IASTArrayDeclarator arrayDeclarator = this.factory.newArrayDeclarator(null);
                    if (returnedDeclarator == null) {
                        arrayDeclarator.setName(newName);
                    } else {
                        arrayDeclarator.setNestedDeclarator(returnedDeclarator);
                        arrayDeclarator.setName(this.factory.newName());
                    }
                    while (type instanceof IArrayType) {
                        arrayType = (IArrayType)type;
                        IASTExpression arraySizeExpression = arrayType.getArraySizeExpression();
                        arrayDeclarator.addArrayModifier(this.factory.newArrayModifier(arraySizeExpression == null ? null : arraySizeExpression.copy()));
                        type = arrayType.getType();
                    }
                    returnedDeclarator = arrayDeclarator;
                } else if (this.isPtrOrRefType(type)) {
                    if (returnedDeclarator == null) {
                        returnedDeclarator = this.factory.newDeclarator(newName);
                    }
                    IASTPointerOperator ptrOp = this.createPointerOperator(type);
                    this.addPointerOperatorDeferred(pointerOperatorMap, returnedDeclarator, ptrOp);
                    type = this.getPtrOrRefSubtype(type);
                } else if (type instanceof IFunctionType) {
                    IFunctionType funcType = (IFunctionType)type;
                    IASTStandardFunctionDeclarator func = this.factory.newFunctionDeclarator(null);
                    IType[] iTypeArray = funcType.getParameterTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType paramType = iTypeArray[n2];
                        IASTDeclSpecifier declspec = this.createDeclSpecFromType(paramType);
                        IASTDeclarator declarator = null;
                        declarator = this.typeNeedsNontrivialDeclarator(paramType) ? this.createDeclaratorFromType(paramType, null) : this.factory.newDeclarator(this.factory.newName());
                        IASTParameterDeclaration parameterDeclaration = this.factory.newParameterDeclaration(declspec, declarator);
                        func.addParameterDeclaration(parameterDeclaration);
                        ++n2;
                    }
                    if (returnedDeclarator == null) {
                        func.setName(newName);
                    } else {
                        func.setNestedDeclarator(returnedDeclarator);
                        func.setName(this.factory.newName());
                    }
                    returnedDeclarator = func;
                    type = funcType.getReturnType();
                }
                replaceInitialArrayWithPointer = false;
                changeInitialFunctionToFuncPtr = false;
            }
            this.finalizePointerOperators(pointerOperatorMap);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
        }
        if (returnedDeclarator == null) {
            returnedDeclarator = this.factory.newDeclarator(this.factory.newName(name));
        }
        return returnedDeclarator;
    }

    private void finalizePointerOperators(Map<IASTDeclarator, LinkedList<IASTPointerOperator>> pointerOperatorMap) {
        for (IASTDeclarator declarator : pointerOperatorMap.keySet()) {
            LinkedList<IASTPointerOperator> list = pointerOperatorMap.get(declarator);
            for (IASTPointerOperator op : list) {
                declarator.addPointerOperator(op);
            }
        }
    }

    private void addPointerOperatorDeferred(Map<IASTDeclarator, LinkedList<IASTPointerOperator>> pointerOperatorMap, IASTDeclarator returnedDeclarator, IASTPointerOperator ptrOp) {
        LinkedList<Object> list;
        if (!pointerOperatorMap.containsKey(returnedDeclarator)) {
            list = new LinkedList();
            pointerOperatorMap.put(returnedDeclarator, list);
        } else {
            list = pointerOperatorMap.get(returnedDeclarator);
        }
        list.addFirst(ptrOp);
    }

    private IType getPtrOrRefSubtype(IType type) {
        if (type instanceof IPointerType) {
            return ((IPointerType)type).getType();
        }
        return ((ICPPReferenceType)type).getType();
    }

    private IASTPointerOperator createPointerOperator(IType type) {
        if (type instanceof ICPPPointerToMemberType) {
            String classStr = ASTTypeUtil.getType(((ICPPPointerToMemberType)type).getMemberOfClass());
            IASTName newName = this.factory.newName((String.valueOf(classStr) + "::").toCharArray());
            ICPPASTPointerToMember member = ((ICPPNodeFactory)this.factory).newPointerToMember(newName);
            member.setConst(((ICPPPointerToMemberType)type).isConst());
            member.setVolatile(((ICPPPointerToMemberType)type).isVolatile());
            return member;
        }
        if (type instanceof IPointerType) {
            IASTPointer pointer = this.factory.newPointer();
            pointer.setConst(((IPointerType)type).isConst());
            pointer.setVolatile(((IPointerType)type).isVolatile());
            return pointer;
        }
        ICPPReferenceType refType = (ICPPReferenceType)type;
        ICPPASTReferenceOperator op = ((ICPPNodeFactory)this.factory).newReferenceOperator(refType.isRValueReference());
        return op;
    }

    private boolean isPtrOrRefType(IType type) {
        return type instanceof IPointerType || type instanceof ICPPReferenceType;
    }

    private boolean typeNeedsNontrivialDeclarator(IType type) {
        return this.isPtrOrRefType(type) || type instanceof IArrayType || type instanceof IFunctionType;
    }

    private IASTDeclSpecifier getDeclSpecForTemplate(ICPPTemplateInstance type) {
        IASTName name = this.getName(type);
        if (this.factory instanceof ICPPNodeFactory) {
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTQualifiedName fullQualifiedName = (ICPPASTQualifiedName)name;
                IASTName templateName = fullQualifiedName.getLastName();
                ICPPASTTemplateId tempId = this.getTemplateId(type, templateName);
                ICPPASTQualifiedName newQualifiedName = ((ICPPNodeFactory)this.factory).newQualifiedName();
                int nbQualifiedNames = fullQualifiedName.getNames().length;
                if (nbQualifiedNames > 1) {
                    int i = 0;
                    while (i < nbQualifiedNames - 1) {
                        newQualifiedName.addName(fullQualifiedName.getNames()[i].copy());
                        ++i;
                    }
                }
                newQualifiedName.addName(tempId);
                return this.factory.newTypedefNameSpecifier(newQualifiedName);
            }
            IASTName templateName = this.getName(type);
            ICPPASTTemplateId tempId = this.getTemplateId(type, templateName);
            return this.factory.newTypedefNameSpecifier(tempId);
        }
        return this.factory.newTypedefNameSpecifier(name);
    }

    private ICPPASTTemplateId getTemplateId(ICPPTemplateInstance type, IASTName templateName) {
        ICPPNodeFactory cppFactory = (ICPPNodeFactory)this.factory;
        ICPPASTTemplateId tempId = cppFactory.newTemplateId(templateName.copy());
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = type.getTemplateArguments();
        int n = iCPPTemplateArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            IASTDeclSpecifier argDeclSpec = this.createDeclSpecFromType(arg.isTypeValue() ? arg.getTypeValue() : arg.getTypeOfNonTypeValue());
            ICPPASTTypeId typeId = cppFactory.newTypeId(argDeclSpec, null);
            tempId.addTemplateArgument(typeId);
            ++n2;
        }
        return tempId;
    }

    private IASTNamedTypeSpecifier getDeclSpecForBinding(IBinding binding) {
        IASTName name = this.getName(binding);
        return this.factory.newTypedefNameSpecifier(name);
    }

    private IASTName getName(IBinding binding) {
        IASTName name;
        char[][] qualifiedNameCharArray = CPPVisitor.getQualifiedNameCharArray(binding);
        if (qualifiedNameCharArray.length > 1) {
            name = ((ICPPNodeFactory)this.factory).newQualifiedName();
            char[][] cArray = qualifiedNameCharArray;
            int n = qualifiedNameCharArray.length;
            int n2 = 0;
            while (n2 < n) {
                char[] cs = cArray[n2];
                name.addName(this.factory.newName(cs));
                ++n2;
            }
        } else {
            name = qualifiedNameCharArray.length == 1 ? this.factory.newName(qualifiedNameCharArray[0]) : this.factory.newName(binding.getName().toCharArray());
        }
        return name;
    }
}

