/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class IndexFileSet
implements IIndexFileSet {
    private IIndexFileSet fInverse;
    private HashMap<IIndexFragment, IIndexFragmentFileSet> fSubSets = new HashMap();

    public void add(IIndexFile indexFile) {
        IIndexFragmentFile fragFile = (IIndexFragmentFile)indexFile;
        IIndexFragment frag = fragFile.getIndexFragment();
        IIndexFragmentFileSet subSet = this.fSubSets.get(frag);
        if (subSet == null) {
            subSet = frag.createFileSet();
            this.fSubSets.put(frag, subSet);
        }
        subSet.add(fragFile);
    }

    public boolean containsDeclaration(IIndexBinding binding) {
        return this.containsDeclaration(binding, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean containsDeclaration(IIndexBinding binding, boolean inverse) {
        for (Map.Entry<IIndexFragment, IIndexFragmentFileSet> entry : this.fSubSets.entrySet()) {
            try {
                IIndexFragmentName[] names;
                IIndexFragmentName[] iIndexFragmentNameArray = names = entry.getKey().findNames(binding, 3);
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFragmentName name = iIndexFragmentNameArray[n2];
                    try {
                        boolean foundDecl = entry.getValue().contains((IIndexFragmentFile)name.getFile());
                        if (foundDecl != inverse) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    public IBinding[] filterFileLocalBindings(IBinding[] bindings) {
        return this.filterFileLocalBindings(bindings, false);
    }

    public IBinding[] filterFileLocalBindings(IBinding[] bindings, boolean invert) {
        int cardinality;
        if (bindings == null || bindings.length == 0) {
            return bindings;
        }
        BitSet ok = new BitSet(bindings.length);
        if (invert) {
            ok.set(0, bindings.length);
        }
        int i = 0;
        while (i < bindings.length) {
            IBinding binding = bindings[i];
            if (binding != null) {
                IIndexFragmentBinding fb = binding instanceof IIndexFragmentBinding ? (IIndexFragmentBinding)binding : (IIndexFragmentBinding)binding.getAdapter(IIndexFragmentBinding.class);
                try {
                    if (fb != null && fb.isFileLocal()) {
                        IIndexFragmentFileSet subSet = this.fSubSets.get(fb.getFragment());
                        if (subSet != null && subSet.containsFileOfLocalBinding(fb)) {
                            ok.set(i);
                        }
                    } else {
                        ok.set(i);
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i;
        }
        if (invert) {
            ok.flip(0, bindings.length);
        }
        if ((cardinality = ok.cardinality()) == bindings.length) {
            return bindings;
        }
        IBinding[] result = new IBinding[cardinality];
        int j = ok.nextSetBit(0);
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = bindings[j];
            j = ok.nextSetBit(j + 1);
            ++i2;
        }
        return result;
    }

    public boolean contains(IIndexFile file) throws CoreException {
        return this.contains(file, false);
    }

    public boolean contains(IIndexFile file, boolean invert) throws CoreException {
        if (!(file instanceof IIndexFragmentFile)) {
            return invert;
        }
        IIndexFragmentFile ifile = (IIndexFragmentFile)file;
        IIndexFragmentFileSet subSet = this.fSubSets.get(ifile.getIndexFragment());
        if (subSet != null && subSet.contains(ifile)) {
            return !invert;
        }
        return invert;
    }

    public IIndexFileSet invert() {
        if (this.fInverse == null) {
            this.fInverse = new IIndexFileSet(){

                public IIndexFileSet invert() {
                    return IndexFileSet.this;
                }

                public IBinding[] filterFileLocalBindings(IBinding[] bindings) {
                    return IndexFileSet.this.filterFileLocalBindings(bindings, true);
                }

                public boolean containsDeclaration(IIndexBinding binding) {
                    return IndexFileSet.this.containsDeclaration(binding, true);
                }

                public boolean contains(IIndexFile file) throws CoreException {
                    return IndexFileSet.this.contains(file, true);
                }

                public void add(IIndexFile indexFile) {
                    Assert.isLegal((boolean)false);
                }
            };
        }
        return this.fInverse;
    }
}

