/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespace;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPUsingDirective
implements ICPPUsingDirective,
IPDOMNode {
    private static final int CONTAINER_NAMESPACE = 0;
    private static final int NOMINATED_NAMESPACE = 4;
    private static final int PREV_DIRECTIVE_OF_FILE = 8;
    private static final int FILE_OFFSET = 12;
    private static final int RECORD_SIZE = 16;
    private final PDOMCPPLinkage fLinkage;
    private final long fRecord;

    PDOMCPPUsingDirective(PDOMCPPLinkage pdom, long record) {
        this.fLinkage = pdom;
        this.fRecord = record;
    }

    public PDOMCPPUsingDirective(PDOMCPPLinkage linkage, long prevRecInFile, PDOMCPPNamespace containerNS, PDOMBinding nominated, int fileOffset) throws CoreException {
        Database db = linkage.getDB();
        long containerRec = containerNS == null ? 0L : containerNS.getRecord();
        long nominatedRec = nominated.getRecord();
        this.fLinkage = linkage;
        this.fRecord = db.malloc(16);
        db.putRecPtr(this.fRecord + 0L, containerRec);
        db.putRecPtr(this.fRecord + 4L, nominatedRec);
        db.putRecPtr(this.fRecord + 8L, prevRecInFile);
        db.putInt(this.fRecord + 12L, fileOffset);
    }

    public ICPPNamespaceScope getNominatedScope() {
        try {
            long rec = this.fLinkage.getDB().getRecPtr(this.fRecord + 4L);
            PDOMNode node = this.fLinkage.getNode(rec);
            if (node instanceof ICPPNamespace) {
                return ((ICPPNamespace)((Object)node)).getNamespaceScope();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public IScope getContainingScope() {
        try {
            PDOMNode node;
            long rec = this.fLinkage.getDB().getRecPtr(this.fRecord + 0L);
            if (rec != 0L && (node = this.fLinkage.getNode(rec)) instanceof PDOMCPPNamespace) {
                return (PDOMCPPNamespace)node;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public int getPointOfDeclaration() {
        Database db = this.fLinkage.getDB();
        try {
            return db.getInt(this.fRecord + 12L);
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public long getRecord() {
        return this.fRecord;
    }

    public long getPreviousRec() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getRecPtr(this.fRecord + 8L);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        this.fLinkage.getDB().free(this.fRecord);
    }
}

