/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.linux.x86;

import org.eclipse.cdt.debug.edc.MessageLogger;
import org.eclipse.cdt.debug.edc.launch.ChooseProcessItem;
import org.eclipse.cdt.debug.edc.ui.ChooseProcessDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

public class LinuxDebugger
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.edc.linux.x86";
    private static LinuxDebugger plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static LinuxDebugger getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return LinuxDebugger.getDefault().getBundle().getBundleContext();
    }

    public static MessageLogger getMessageLogger() {
        return new MessageLogger(){

            public String getPluginID() {
                return LinuxDebugger.PLUGIN_ID;
            }

            public Plugin getPlugin() {
                return plugin;
            }
        };
    }

    public static String getUniqueIdentifier() {
        if (LinuxDebugger.getDefault() == null) {
            return PLUGIN_ID;
        }
        return LinuxDebugger.getDefault().getBundle().getSymbolicName();
    }

    public static ChooseProcessItem chooseProcess(final ChooseProcessItem[] processes) throws CoreException {
        final ChooseProcessItem[] selectedProcessItem = new ChooseProcessItem[1];
        final boolean[] chooseProcessCanceled = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChooseProcessDialog dialog = new ChooseProcessDialog(processes, "", Display.getDefault().getActiveShell());
                int dialogResult = dialog.open();
                if (dialogResult == 0) {
                    selectedProcessItem[0] = dialog.getSelectedProcess();
                } else {
                    chooseProcessCanceled[0] = true;
                }
            }
        });
        if (chooseProcessCanceled[0]) {
            String msg = "user canceled selection of process";
            Status status = new Status(8, PLUGIN_ID, msg);
            throw new CoreException((IStatus)status);
        }
        return selectedProcessItem[0];
    }
}

