/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.MessageFormat;
import org.eclipse.cdt.debug.edc.tcf.extension.transport.ITransportChannel;

public class TransportChannelTCP
implements ITransportChannel {
    private Socket socket;
    private InputStream inp;
    private OutputStream out;
    private boolean closed;
    private String host;
    private int port;

    public TransportChannelTCP(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean isOpen() {
        return this.socket != null && !this.closed;
    }

    public void open() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setTcpNoDelay(true);
        this.inp = new BufferedInputStream(this.socket.getInputStream());
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.closed = false;
    }

    public void close() throws IOException {
        this.closed = true;
        this.socket.close();
        this.out.close();
        this.inp.close();
    }

    public boolean hasInput() throws IOException {
        return this.inp.available() > 0;
    }

    public int get() throws IOException {
        this.checkClosed();
        return this.inp.read();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            String msg = MessageFormat.format("Transport ''{0}'' already closed.", this.toString());
            throw new IOException(msg);
        }
    }

    public void put(int b) throws IOException {
        assert (b >= 0 && b <= 255);
        this.checkClosed();
        this.out.write(b);
    }

    public void put(byte[] a) throws IOException {
        this.checkClosed();
        this.out.write(a);
    }

    public void flush() throws IOException {
        this.checkClosed();
        this.out.flush();
    }

    public String toString() {
        return "TCP::" + this.host + ":" + this.port;
    }

    public byte[] getBytes() throws IOException {
        byte[] result;
        int ret;
        this.checkClosed();
        int avail = this.inp.available();
        if (avail <= 0) {
            avail = 256;
        }
        if ((ret = this.inp.read(result = new byte[avail])) < 0) {
            return null;
        }
        if (ret < result.length) {
            byte[] shortResult = new byte[ret];
            System.arraycopy(result, 0, shortResult, 0, ret);
            result = shortResult;
        }
        return result;
    }
}

