/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.actions;

import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractEDCCommandHandler
extends AbstractHandler
implements IDebugContextListener {
    private final IDebugContextService contextService;
    private ISelection debugSelectionContext;
    private IRunControl.IExecutionDMContext selectionExecutionDMC;
    private IAlbum albumContext;
    private boolean snapshotSession;

    public AbstractEDCCommandHandler() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.contextService = DebugUITools.getDebugContextManager().getContextService(window);
        this.contextService.addPostDebugContextListener((IDebugContextListener)this);
        this.setDebugSelectionContext(this.contextService.getActiveContext());
    }

    private IRunControl.IExecutionDMContext getContext(ISelection selection) {
        Object object;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (object = ss.getFirstElement()) instanceof IDMVMContext) {
            return (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)object).getDMContext(), IRunControl.IExecutionDMContext.class);
        }
        return null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.setDebugSelectionContext(event.getContext());
        this.setBaseEnabled(this.selectionExecutionDMC instanceof IEDCExecutionDMC);
    }

    public IRunControl.IExecutionDMContext getSelectionExecutionDMC() {
        return this.selectionExecutionDMC;
    }

    public void setDebugSelectionContext(ISelection debugSelectionContext) {
        this.debugSelectionContext = debugSelectionContext;
        this.selectionExecutionDMC = this.getContext(this.getDebugSelectionContext());
        if (this.selectionExecutionDMC != null) {
            this.albumContext = Album.getAlbumBySession((String)this.selectionExecutionDMC.getSessionId());
            if (this.albumContext == null) {
                this.albumContext = Album.getRecordingForSession((String)this.selectionExecutionDMC.getSessionId());
            }
            this.snapshotSession = Album.isSnapshotSession((String)this.selectionExecutionDMC.getSessionId());
        }
    }

    public IAlbum getAlbumContext() {
        return this.albumContext;
    }

    public boolean isSnapshotSession() {
        return this.snapshotSession;
    }

    public ISelection getDebugSelectionContext() {
        return this.debugSelectionContext;
    }
}

