/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.actions;

import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;

public class DebugSnapshotPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IDMVMContext testContext = null;
        boolean isEDCSession = false;
        boolean isSnapshotSession = false;
        boolean previousAvailable = false;
        boolean playAvailable = false;
        if (receiver instanceof IWorkbenchPart) {
            Object selection = DebugSnapshotPropertyTester.getContextSelectionForPart((IWorkbenchPart)receiver);
            if (selection instanceof IDMVMContext) {
                testContext = (IDMVMContext)selection;
            } else if (selection instanceof EDCLaunch) {
                isEDCSession = true;
            }
        } else if (receiver instanceof IDMVMContext) {
            testContext = (IDMVMContext)receiver;
        }
        if (testContext != null) {
            String sessionID = testContext.getDMContext().getSessionId();
            isSnapshotSession = Album.isSnapshotSession((String)sessionID);
            IDMContext context = testContext.getDMContext();
            if (context instanceof IEDCDMContext) {
                isEDCSession = true;
                IAlbum album = Album.getAlbumBySession((String)sessionID);
                Album albumRecording = Album.getRecordingForSession((String)sessionID);
                previousAvailable = album != null || albumRecording != null;
                boolean bl = playAvailable = album != null && !album.isPlayingSnapshots();
            }
        }
        if (property.equals("isSnapshotCreationAvailable")) {
            return !isSnapshotSession;
        }
        if (property.equals("isEDCSession")) {
            return isEDCSession;
        }
        if (property.equals("isSnapshotSession")) {
            return isSnapshotSession;
        }
        if (property.equals("isPreviousSnapshotAvailable")) {
            return previousAvailable;
        }
        if (property.equals("isPlaySnapshotsAvailable")) {
            return playAvailable;
        }
        return false;
    }

    private static Object getContextSelectionForPart(IWorkbenchPart part) {
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow());
        ISelection debugContext = contextService.getActiveContext(DebugSnapshotPropertyTester.getPartId(part));
        if (debugContext == null) {
            debugContext = contextService.getActiveContext();
        }
        if (debugContext instanceof IStructuredSelection) {
            return ((IStructuredSelection)debugContext).getFirstElement();
        }
        return null;
    }

    private static String getPartId(IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            IViewSite site = (IViewSite)part.getSite();
            return String.valueOf(site.getId()) + (site.getSecondaryId() != null ? ":" + site.getSecondaryId() : "");
        }
        return part.getSite().getId();
    }
}

