/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.ISnapshotAlbumEventListener;
import org.eclipse.cdt.debug.edc.internal.snapshot.Snapshot;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotView
extends ViewPart
implements ISnapshotAlbumEventListener {
    public static final String ID = "org.eclipse.cdt.debug.edc.ui.views.SnapshotView";
    public static final String CONTEXT_ID = "org.eclipse.cdt.debug.edc.ui.context.SnapshotView";
    private static final ImageDescriptor SNAPSHOT_NODE_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/obj16/snapshot_node.png");
    private static final ImageDescriptor SNAPSHOT_CURRENT_NODE_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/obj16/snapshot_current_node.png");
    private static final ImageDescriptor ALBUM_NODE_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/obj16/album_node.png");
    private static final ImageDescriptor ALBUM_NODE_RECORDING_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/obj16/album_node_recording.png");
    private static final ImageDescriptor ALBUM_NODE_PLAYBACK_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/obj16/album_node_playback.png");
    private static final ImageDescriptor ALBUM_NODE_LIVE_RECORDING_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/obj16/album_node_live_recording.png");
    private static final ImageDescriptor ALBUM_NODE_ERROR_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/obj16/album_node_error.png");
    private static final ImageDescriptor PLAY_SNAPSHOT_IMGDESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/etool16/play_snapshots.gif");
    public static final String SNAPSHOT_VIEW_ID = "org.eclipse.cdt.debug.edc.ui.views.SnapshotView";
    private static final Image ALBUM_NODE_IMAGE = ALBUM_NODE_IMGDESC.createImage();
    private static final Image ALBUM_NODE_RECORDING_IMAGE = ALBUM_NODE_RECORDING_IMGDESC.createImage();
    private static final Image ALBUM_NODE_PLAYBACK_IMAGE = ALBUM_NODE_PLAYBACK_IMGDESC.createImage();
    private static final Image ALBUM_NODE_LIVE_RECORDING_IMAGE = ALBUM_NODE_LIVE_RECORDING_IMGDESC.createImage();
    private static final Image ALBUM_NODE_ERROR_IMAGE = ALBUM_NODE_ERROR_IMGDESC.createImage();
    private static final Image SNAPSHOT_NODE_IMAGE = SNAPSHOT_NODE_IMGDESC.createImage();
    private static final Image SNAPSHOT_CURRENT_NODE_IMAGE = SNAPSHOT_CURRENT_NODE_IMGDESC.createImage();
    private TreeViewer viewer;
    private Action refreshAction;
    private Action launchAction;
    private Action importAction;
    private IContextActivation contextActivation;

    public void createPartControl(Composite parent) {
        Album.addSnapshotAlbumEventListener((ISnapshotAlbumEventListener)this);
        this.viewer = new TreeViewer(parent, 768);
        TreeViewerColumn albumColumn = new TreeViewerColumn(this.viewer, 16384);
        albumColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new ViewLabelProvider()));
        albumColumn.getColumn().setText("Album");
        albumColumn.setEditingSupport((EditingSupport)new NameEditingSupport(albumColumn.getViewer()));
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy(albumColumn.getViewer()){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                if (event.eventType == 3 && SnapshotView.this.getAlbumsFromSnapshotProject().size() == 0) {
                    SnapshotView.this.importAction.run();
                }
                return event.eventType == 3;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)1);
        TreeViewerColumn dateColumn = new TreeViewerColumn(this.viewer, 16384);
        dateColumn.setLabelProvider((CellLabelProvider)new DateLabelProvider());
        dateColumn.getColumn().setText("Date");
        TreeViewerColumn locationCol = new TreeViewerColumn(this.viewer, 16384);
        locationCol.setLabelProvider((CellLabelProvider)new LocationLabelProvider());
        locationCol.getColumn().setText("Location");
        locationCol.setEditingSupport((EditingSupport)new LocationEditingSupport(locationCol.getViewer()));
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.setInput((Object)this.loadAlbums());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Object value1 = ((TreeNode)e1).getValue();
                Object value2 = ((TreeNode)e2).getValue();
                if (value1 instanceof IAlbum) {
                    return ((IAlbum)value1).getDisplayName().compareToIgnoreCase(((IAlbum)value1).getDisplayName());
                }
                if (value1 instanceof Snapshot) {
                    return ((Snapshot)value1).getSnapshotFileName().compareToIgnoreCase(((Snapshot)value2).getSnapshotFileName());
                }
                return 0;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                boolean enabled = false;
                if (!selection.isEmpty()) {
                    enabled = true;
                    TreeNode node = (TreeNode)((IStructuredSelection)selection).getFirstElement();
                    Object value = node.getValue();
                    if (value instanceof IAlbum) {
                        IAlbum album = (IAlbum)value;
                        enabled = !album.isRecording() && !Album.isSnapshotSession((String)album.getSessionID());
                    } else if (value instanceof Snapshot) {
                        Snapshot snapshot = (Snapshot)value;
                        enabled = !snapshot.getAlbum().isRecording() && !Album.isSnapshotSession((String)snapshot.getAlbum().getSessionID());
                    }
                }
                SnapshotView.this.launchAction.setEnabled(enabled);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.cdt.debug.edc.ui.views");
        this.packColumns();
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.contextActivation = ctxService.activateContext(CONTEXT_ID);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void packColumns() {
        TreeColumn[] columns;
        TreeColumn[] treeColumnArray = columns = this.viewer.getTree().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                try {
                    Object[] expanded = SnapshotView.this.viewer.getExpandedElements();
                    TreeNode[] newTree = SnapshotView.this.loadAlbums();
                    SnapshotView.this.viewer.setInput((Object)newTree);
                    SnapshotView.this.packColumns();
                    if (SnapshotView.this.viewer.getTree().getItems().length == 1) {
                        SnapshotView.this.viewer.expandAll();
                    } else {
                        Object[] objectArray = newTree;
                        int n = newTree.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAlbum album;
                            TreeNode newNode = objectArray[n2];
                            if (newNode instanceof TreeNode && newNode.getValue() instanceof IAlbum && ((album = (IAlbum)newNode.getValue()).isRecording() || Album.isSnapshotSession((String)album.getSessionID()))) {
                                SnapshotView.this.viewer.setExpandedState((Object)newNode, true);
                            }
                            ++n2;
                        }
                        objectArray = expanded;
                        n = expanded.length;
                        n2 = 0;
                        while (n2 < n) {
                            TreeNode expandedNode = objectArray[n2];
                            TreeNode[] treeNodeArray = newTree;
                            int n3 = newTree.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                TreeNode newNode = treeNodeArray[n4];
                                if (newNode instanceof TreeNode && newNode.getValue() instanceof IAlbum) {
                                    String oldAlbumName;
                                    IAlbum album = (IAlbum)newNode.getValue();
                                    if (album.isRecording()) {
                                        SnapshotView.this.viewer.setExpandedState((Object)newNode, true);
                                        break;
                                    }
                                    Object t1 = newNode.getValue();
                                    Object t2 = expandedNode.getValue();
                                    String newAlbumName = ((IAlbum)t1).getDisplayName();
                                    if (newAlbumName.equals(oldAlbumName = ((IAlbum)t2).getDisplayName())) {
                                        SnapshotView.this.viewer.setExpandedState((Object)newNode, true);
                                        break;
                                    }
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                    SnapshotView.this.viewer.refresh();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refreshes snapshot information");
        this.refreshAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/etool16/refresh.gif"));
        this.launchAction = new Action(){

            public void run() {
                try {
                    TreeNode node = (TreeNode)((IStructuredSelection)SnapshotView.this.viewer.getSelection()).getFirstElement();
                    Object value = node.getValue();
                    if (value instanceof IAlbum) {
                        SnapshotUtils.launchAlbumSession((Album)((Album)value));
                    } else if (value instanceof Snapshot) {
                        Album album = ((Snapshot)value).getAlbum();
                        int index = album.getIndexOfSnapshot((Snapshot)value);
                        SnapshotUtils.launchAlbumSession((Album)((Snapshot)value).getAlbum());
                        album.setCurrentSnapshotIndex(index);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        this.launchAction.setText("Launch Snapshot");
        this.launchAction.setToolTipText("Launches the selected snapshot");
        this.launchAction.setImageDescriptor(PLAY_SNAPSHOT_IMGDESC);
        this.importAction = new Action(){

            public void run() {
                try {
                    FileDialog fd = new FileDialog(SnapshotView.this.viewer.getControl().getShell());
                    fd.setFilterExtensions(new String[]{"*.dsa"});
                    String fileSelected = fd.open();
                    if (fileSelected != null) {
                        IProject project = SnapshotUtils.getSnapshotsProject();
                        IFile f = project.getFile(new File(fileSelected).getName());
                        f.createLink(Path.fromOSString((String)fileSelected), 144, null);
                        f.refreshLocal(1, null);
                        project.refreshLocal(2, null);
                        SnapshotView.this.refreshAction.run();
                    }
                }
                catch (CoreException x) {
                    ErrorDialog.openError((Shell)SnapshotView.this.viewer.getControl().getShell(), (String)"Import Error", (String)"Failed to import snapshot.", (IStatus)x.getStatus());
                }
                catch (Exception x) {
                    ErrorDialog.openError((Shell)SnapshotView.this.viewer.getControl().getShell(), (String)"Import Error", null, (IStatus)EDCDebugUI.dsfRequestFailedStatus("Failed to import snapshot.", x));
                }
            }
        };
        this.importAction.setText("Import album");
        this.importAction.setToolTipText("Import an existing snapshot album");
        this.importAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.launchAction);
        manager.add((IAction)this.importAction);
        this.launchAction.setEnabled(false);
        manager.add((IContributionItem)new Separator());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SnapshotView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.launchAction);
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        TreeNode node = (TreeNode)((IStructuredSelection)selection).getFirstElement();
        Object value = node.getValue();
        boolean enabled = false;
        if (value instanceof IAlbum) {
            this.launchAction.setText("Launch Album");
            IAlbum album = (IAlbum)value;
            enabled = !Album.isSnapshotSession((String)album.getSessionID());
        } else if (value instanceof Snapshot) {
            this.launchAction.setText("Launch Snapshot");
            Snapshot snapshot = (Snapshot)value;
            enabled = !Album.isSnapshotSession((String)snapshot.getAlbum().getSessionID());
        }
        this.launchAction.setEnabled(enabled);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.importAction);
        manager.add((IAction)this.launchAction);
        manager.add((IContributionItem)new Separator());
    }

    private TreeNode[] loadAlbums() {
        List<Album> albumList = this.getAlbumsFromSnapshotProject();
        ArrayList<TreeNode> albumNodes = new ArrayList<TreeNode>();
        if (albumList.size() == 0) {
            TreeNode treeNode = new TreeNode((Object)"Click the Camera button in the Debug View to create a new Album or double-click here to import an existing one.");
            albumNodes.add(treeNode);
            return albumNodes.toArray(new TreeNode[albumNodes.size()]);
        }
        for (IAlbum iAlbum : albumList) {
            TreeNode albumNode = new TreeNode((Object)iAlbum);
            List snaps = iAlbum.getSnapshots();
            ArrayList<TreeNode> snapshotNodes = new ArrayList<TreeNode>();
            for (Snapshot s : snaps) {
                snapshotNodes.add(new TreeNode((Object)s));
            }
            for (TreeNode node : snapshotNodes) {
                node.setParent(albumNode);
            }
            albumNode.setChildren(snapshotNodes.toArray(new TreeNode[snapshotNodes.size()]));
            albumNodes.add(albumNode);
        }
        return albumNodes.toArray(new TreeNode[albumNodes.size()]);
    }

    private List<Album> getAlbumsFromSnapshotProject() {
        ArrayList<Album> albumList = new ArrayList<Album>();
        String defaultProjectName = "Snapshots";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject snapshotsProject = workspace.getRoot().getProject(defaultProjectName);
        if (snapshotsProject == null || !snapshotsProject.exists()) {
            return albumList;
        }
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = snapshotsProject.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                try {
                    if (resource.getType() != 2 && resource.getFullPath().getFileExtension().equalsIgnoreCase("dsa") && resource.exists()) {
                        Album album = Album.getAlbumByLocation((IPath)resource.getRawLocation());
                        if (album == null) {
                            album = new Album();
                            album.setLocation(resource.getRawLocation());
                            album.loadAlbumMetada(true);
                        }
                        albumList.add(album);
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return albumList;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = SnapshotView.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public void dispose() {
        IContextService ctxService;
        if (this.contextActivation != null && (ctxService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            ctxService.deactivateContext(this.contextActivation);
        }
    }

    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!SnapshotView.this.viewer.getControl().isDisposed()) {
                    SnapshotView.this.refreshAction.run();
                }
            }
        });
    }

    private void revealSnapshot(final Snapshot snapshot) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!SnapshotView.this.viewer.getControl().isDisposed()) {
                    TreeNode[] nodes = (TreeNode[])SnapshotView.this.viewer.getInput();
                    Album album = snapshot.getAlbum();
                    TreeNode[] treeNodeArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    block0: while (n2 < n) {
                        TreeNode treeNode = treeNodeArray[n2];
                        if (treeNode.getValue().equals(album)) {
                            TreeNode[] children;
                            TreeNode[] treeNodeArray2 = children = treeNode.getChildren();
                            int n3 = children.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                TreeNode snapNode = treeNodeArray2[n4];
                                if (snapNode.getValue().equals(snapshot)) {
                                    SnapshotView.this.viewer.reveal((Object)snapNode);
                                    break block0;
                                }
                                ++n4;
                            }
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public void snapshotCreated(Album album, Snapshot snapshot, DsfSession session, Stack.StackFrameDMC stackFrame) {
        this.refresh();
        this.revealSnapshot(snapshot);
    }

    public void snapshotOpened(Snapshot snapshot) {
        this.refresh();
        this.revealSnapshot(snapshot);
    }

    public void snapshotSessionEnded(Album album, DsfSession session) {
        this.refresh();
    }

    private class DateLabelProvider
    extends ColumnLabelProvider {
        private DateLabelProvider() {
        }

        public String getText(Object obj) {
            TreeNode node = (TreeNode)obj;
            Object value = node.getValue();
            if (value instanceof IAlbum) {
                return new Date(((IAlbum)value).getLocation().toFile().lastModified()).toString();
            }
            if (value instanceof Snapshot && ((Snapshot)value).getCreationDate() != null) {
                return ((Snapshot)value).getCreationDate();
            }
            return "";
        }
    }

    private class LocationEditingSupport
    extends EditingSupport {
        private CellEditor editor;

        public LocationEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)((TreeViewer)viewer).getTree());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Snapshot snap;
            TreeNode node = (TreeNode)element;
            Object nodeValue = node.getValue();
            if (nodeValue instanceof IAlbum) {
                return ((IAlbum)nodeValue).getLocation().toOSString();
            }
            if (nodeValue instanceof Snapshot && (snap = (Snapshot)nodeValue).getReferenceLocationSourceFile().length() > 0 && snap.getReferenceLocationLineNumber() > 0L) {
                return String.valueOf(snap.getReferenceLocationSourceFile()) + ":" + snap.getReferenceLocationLineNumber();
            }
            return "";
        }

        protected void setValue(Object element, Object value) {
        }
    }

    private class LocationLabelProvider
    extends ColumnLabelProvider {
        private LocationLabelProvider() {
        }

        public String getText(Object obj) {
            Snapshot snap;
            TreeNode node = (TreeNode)obj;
            Object value = node.getValue();
            if (value instanceof IAlbum) {
                return ((IAlbum)value).getLocation().toOSString();
            }
            if (value instanceof Snapshot && (snap = (Snapshot)value).getReferenceLocationSourceFile().length() > 0 && snap.getReferenceLocationLineNumber() > 0L) {
                return String.valueOf(snap.getReferenceLocationSourceFile()) + ":" + snap.getReferenceLocationLineNumber();
            }
            return "";
        }
    }

    private class NameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        private NameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl(), 2048);
        }

        protected boolean canEdit(Object element) {
            return ((TreeNode)element).getValue() instanceof IAlbum || ((TreeNode)element).getValue() instanceof Snapshot;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            TreeNode node = (TreeNode)element;
            Object value = node.getValue();
            if (value instanceof IAlbum) {
                return ((IAlbum)value).getDisplayName();
            }
            if (value instanceof Snapshot) {
                return ((Snapshot)value).getSnapshotDisplayName();
            }
            return null;
        }

        protected void setValue(Object element, Object newValue) {
            TreeNode node = (TreeNode)element;
            Object value = node.getValue();
            if (value instanceof IAlbum) {
                ((Album)value).updateSnapshotMetaData(newValue.toString(), null);
            } else if (value instanceof Snapshot && !((Snapshot)value).getSnapshotDisplayName().equals(newValue.toString())) {
                ((Snapshot)value).setSnapshotDisplayName(newValue.toString());
                ((Snapshot)value).getAlbum().updateSnapshotMetaData(null, (Snapshot)value);
            }
            SnapshotView.this.viewer.refresh();
        }
    }

    class ViewLabelProvider
    extends ColumnLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            TreeNode node = (TreeNode)obj;
            Object value = node.getValue();
            if (value instanceof IAlbum) {
                return ((IAlbum)value).getDisplayName();
            }
            if (value instanceof Snapshot) {
                if (((Snapshot)value).getSnapshotDisplayName().length() == 0) {
                    return ((Snapshot)value).getSnapshotFileName();
                }
                return ((Snapshot)value).getSnapshotDisplayName();
            }
            return value.toString();
        }

        public Image getImage(Object obj) {
            TreeNode node = (TreeNode)obj;
            Object value = node.getValue();
            if (value instanceof IAlbum) {
                IAlbum album = (IAlbum)value;
                if (album.getSnapshots().size() == 0) {
                    return ALBUM_NODE_ERROR_IMAGE;
                }
                if (album.isRecording() && Album.isSnapshotSession((String)album.getSessionID())) {
                    return ALBUM_NODE_LIVE_RECORDING_IMAGE;
                }
                if (album.isRecording()) {
                    return ALBUM_NODE_RECORDING_IMAGE;
                }
                if (Album.isSnapshotSession((String)album.getSessionID())) {
                    return ALBUM_NODE_PLAYBACK_IMAGE;
                }
                return ALBUM_NODE_IMAGE;
            }
            if (value instanceof Snapshot) {
                Snapshot snap = (Snapshot)value;
                Album album = snap.getAlbum();
                if (Album.isSnapshotSession((String)album.getSessionID())) {
                    EDCLaunch launch = EDCLaunch.getLaunchForSession((String)album.getSessionID());
                    int currIndex = launch.getAlbum().getCurrentSnapshotIndex();
                    if (snap.equals(album.getSnapshots().get(currIndex))) {
                        return SNAPSHOT_CURRENT_NODE_IMAGE;
                    }
                    return SNAPSHOT_NODE_IMAGE;
                }
                return SNAPSHOT_NODE_IMAGE;
            }
            return null;
        }
    }
}

