/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.edc.internal.ui.DsfTerminateCommand;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugTextHover;
import org.eclipse.cdt.debug.edc.internal.ui.EDCSteppingModeTarget;
import org.eclipse.cdt.debug.edc.internal.ui.EDCViewModelAdapter;
import org.eclipse.cdt.debug.edc.internal.ui.actions.EDCDisconnectCommand;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.ui.DefaultEDCModelSelectionPolicyFactory;
import org.eclipse.cdt.debug.edu.internal.ui.sourcelookup.EDCSourceDisplayAdapter;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.cdt.dsf.debug.ui.contexts.DsfSuspendTrigger;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.DefaultRefreshAllTarget;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.IRefreshAllTarget;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

@ThreadSafe
public abstract class EDCAdapterFactory
implements IAdapterFactory,
ILaunchesListener2 {
    private static Map<EDCLaunch, SessionAdapterSet> fgLaunchAdapterSets = Collections.synchronizedMap(new HashMap());
    private static Map<ILaunch, SessionAdapterSet> fgDisposedLaunchAdapterSets = new WeakHashMap<ILaunch, SessionAdapterSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAdapterSet(ILaunch launch) {
        Map<EDCLaunch, SessionAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            if (fgLaunchAdapterSets.containsKey(launch)) {
                fgLaunchAdapterSets.remove(launch).dispose();
                fgDisposedLaunchAdapterSets.put(launch, null);
            }
        }
    }

    public EDCAdapterFactory() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        SessionAdapterSet adapterSet;
        if (!(adaptableObject instanceof EDCLaunch)) {
            return null;
        }
        EDCLaunch launch = (EDCLaunch)adaptableObject;
        DsfSession session = launch.getSession();
        if (session == null) {
            return null;
        }
        Map<EDCLaunch, SessionAdapterSet> map = fgLaunchAdapterSets;
        synchronized (map) {
            block12: {
                if (!fgDisposedLaunchAdapterSets.containsKey(launch)) break block12;
                return null;
            }
            adapterSet = fgLaunchAdapterSets.get(launch);
            if (adapterSet == null) {
                adapterSet = new SessionAdapterSet(launch);
                fgLaunchAdapterSets.put(launch, adapterSet);
            }
        }
        if (adapterType.equals(IElementLabelProvider.class)) {
            return adapterSet.fLaunchLabelProvider;
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IColumnPresentationFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(ISuspendTrigger.class)) {
            return adapterSet.fSuspendTrigger;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IElementLabelProvider.class, IElementContentProvider.class, IModelProxyFactory.class, ISuspendTrigger.class, IColumnPresentationFactory.class};
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof EDCLaunch) {
                EDCAdapterFactory.disposeAdapterSet(launch);
            }
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    protected abstract Object createLabelProvider();

    @Immutable
    class SessionAdapterSet {
        final EDCLaunch fLaunch;
        final EDCViewModelAdapter fViewModelAdapter;
        final EDCSourceDisplayAdapter fSourceDisplayAdapter;
        final DsfStepIntoCommand fStepIntoCommand;
        final DsfStepOverCommand fStepOverCommand;
        final DsfStepReturnCommand fStepReturnCommand;
        final DsfTerminateCommand fTerminateCommand;
        final DsfSuspendCommand fSuspendCommand;
        final DsfResumeCommand fResumeCommand;
        final EDCDisconnectCommand fDisconnectCommand;
        final IDebugModelProvider fDebugModelProvider;
        final DsfSuspendTrigger fSuspendTrigger;
        final EDCSteppingModeTarget fSteppingModeTarget;
        final IModelSelectionPolicyFactory fModelSelectionPolicyFactory;
        final SteppingController fSteppingController;
        final DefaultRefreshAllTarget fRefreshAllTarget;
        final EDCDebugTextHover fDebugTextHover;
        final IElementLabelProvider fLaunchLabelProvider;

        SessionAdapterSet(final EDCLaunch launch) {
            this.fLaunch = launch;
            DsfSession session = launch.getSession();
            this.fSteppingController = new SteppingController(session);
            session.registerModelAdapter(SteppingController.class, (Object)this.fSteppingController);
            this.fViewModelAdapter = new EDCViewModelAdapter(session, this.fSteppingController);
            this.fSourceDisplayAdapter = launch.getSourceLocator() instanceof ISourceLookupDirector ? new EDCSourceDisplayAdapter(session, this.fSteppingController) : null;
            session.registerModelAdapter(ISourceDisplay.class, (Object)this.fSourceDisplayAdapter);
            this.fDisconnectCommand = new EDCDisconnectCommand(session);
            this.fSteppingModeTarget = new EDCSteppingModeTarget(session);
            this.fStepIntoCommand = new DsfStepIntoCommand(session, (DsfSteppingModeTarget)this.fSteppingModeTarget);
            this.fStepOverCommand = new DsfStepOverCommand(session, (DsfSteppingModeTarget)this.fSteppingModeTarget);
            this.fStepReturnCommand = new DsfStepReturnCommand(session);
            this.fSuspendCommand = new DsfSuspendCommand(session);
            this.fResumeCommand = new DsfResumeCommand(session);
            this.fTerminateCommand = new DsfTerminateCommand(session);
            this.fSuspendTrigger = new DsfSuspendTrigger(session, (ILaunch)this.fLaunch);
            this.fModelSelectionPolicyFactory = new DefaultEDCModelSelectionPolicyFactory();
            this.fRefreshAllTarget = new DefaultRefreshAllTarget();
            session.registerModelAdapter(IDisconnectHandler.class, (Object)this.fDisconnectCommand);
            session.registerModelAdapter(ISteppingModeTarget.class, (Object)this.fSteppingModeTarget);
            session.registerModelAdapter(IStepIntoHandler.class, (Object)this.fStepIntoCommand);
            session.registerModelAdapter(IStepOverHandler.class, (Object)this.fStepOverCommand);
            session.registerModelAdapter(IStepReturnHandler.class, (Object)this.fStepReturnCommand);
            session.registerModelAdapter(ISuspendHandler.class, (Object)this.fSuspendCommand);
            session.registerModelAdapter(IResumeHandler.class, (Object)this.fResumeCommand);
            session.registerModelAdapter(IModelSelectionPolicyFactory.class, (Object)this.fModelSelectionPolicyFactory);
            session.registerModelAdapter(IRefreshAllTarget.class, (Object)this.fRefreshAllTarget);
            session.registerModelAdapter(ITerminateHandler.class, (Object)this.fTerminateCommand);
            this.fDebugModelProvider = new IDebugModelProvider(){

                public String[] getModelIdentifiers() {
                    return new String[]{launch.getDebugModelID(), ICBreakpoint.C_BREAKPOINTS_DEBUG_MODEL_ID};
                }
            };
            session.registerModelAdapter(IDebugModelProvider.class, (Object)this.fDebugModelProvider);
            session.registerModelAdapter(ILaunch.class, (Object)this.fLaunch);
            this.fDebugTextHover = new EDCDebugTextHover();
            session.registerModelAdapter(ICEditorTextHover.class, (Object)this.fDebugTextHover);
            session.registerModelAdapter(IViewerInputProvider.class, (Object)this.fViewModelAdapter);
            this.fLaunchLabelProvider = (IElementLabelProvider)EDCAdapterFactory.this.createLabelProvider();
        }

        void dispose() {
            DsfSession session = this.fLaunch.getSession();
            this.fViewModelAdapter.dispose();
            session.unregisterModelAdapter(ISourceDisplay.class);
            if (this.fSourceDisplayAdapter != null) {
                this.fSourceDisplayAdapter.dispose();
            }
            session.unregisterModelAdapter(SteppingController.class);
            this.fSteppingController.dispose();
            session.unregisterModelAdapter(ISteppingModeTarget.class);
            session.unregisterModelAdapter(IStepIntoHandler.class);
            session.unregisterModelAdapter(IStepOverHandler.class);
            session.unregisterModelAdapter(IStepReturnHandler.class);
            session.unregisterModelAdapter(ISuspendHandler.class);
            session.unregisterModelAdapter(IResumeHandler.class);
            session.unregisterModelAdapter(IRestart.class);
            session.unregisterModelAdapter(ITerminateHandler.class);
            session.unregisterModelAdapter(IDisconnectHandler.class);
            session.unregisterModelAdapter(IModelSelectionPolicyFactory.class);
            session.unregisterModelAdapter(IRefreshAllTarget.class);
            session.unregisterModelAdapter(ITerminateHandler.class);
            session.unregisterModelAdapter(ICEditorTextHover.class);
            this.fDisconnectCommand.dispose();
            this.fStepIntoCommand.dispose();
            this.fStepOverCommand.dispose();
            this.fStepReturnCommand.dispose();
            this.fSuspendCommand.dispose();
            this.fResumeCommand.dispose();
            this.fSuspendTrigger.dispose();
            this.fTerminateCommand.dispose();
        }
    }
}

