/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.disassembler;

import java.nio.ByteBuffer;
import org.eclipse.cdt.core.IAddress;

public class AssemblyFormatter {
    private static final int ADDRESS_COLUMN_SIZE = 12;
    private static final int CODE_BYTE_COLUMN_SIZE = 32;
    protected static final int INST_NAME_COLUMN_SIZE = 10;
    public static final char OPEN = '(';
    public static final char CLOSE = ')';
    public static final char SEPARATOR = ',';
    public static final char SCALE = ',';
    public static final char PREFIX_IMMEDIATE = '$';
    public static final char PREFIX_REGISTER = '%';

    public static String toHexString(IAddress addr, boolean show0x) {
        String ret = Integer.toHexString(addr.getValue().intValue());
        if (show0x) {
            ret = "0x" + ret;
        }
        return ret;
    }

    public static String toHexString(byte b, boolean show0x) {
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() == 1) {
            s = "0" + s;
        }
        if (show0x) {
            s = "0x" + s;
        }
        return s;
    }

    public static String toHexString(long i, boolean show0x) {
        String ret = Long.toHexString(i);
        if (show0x) {
            ret = "0x" + ret;
        }
        return ret;
    }

    public static String toHexString(int i, boolean show0x) {
        String ret = Integer.toHexString(i);
        if (show0x) {
            ret = "0x" + ret;
        }
        return ret;
    }

    public static String toHexString(short i, boolean show0x) {
        String ret = Integer.toHexString(i & 0xFFFF);
        if (show0x) {
            ret = "0x" + ret;
        }
        return ret;
    }

    public static String formatFarPointer(short segment, int offset) {
        return "$" + AssemblyFormatter.toHexString(segment, true) + ",$" + AssemblyFormatter.toHexString(offset, true);
    }

    public static String formatForAddressColumn(IAddress addr) {
        String addrStr = AssemblyFormatter.toHexString(addr, false);
        StringBuffer buf = new StringBuffer(addrStr).append(':');
        int i = 0;
        while (i < 12 - addrStr.length()) {
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    public static String formatForByteColumn(ByteBuffer codeBuffer, int startPosition, int length) {
        StringBuffer tmp = new StringBuffer();
        codeBuffer.position(startPosition);
        int i = 0;
        while (i < length) {
            byte b = codeBuffer.get();
            tmp.append(AssemblyFormatter.toHexString(b, false)).append(' ');
            ++i;
        }
        int cnt = tmp.length();
        int i2 = 0;
        while (i2 < 32 - cnt) {
            tmp.append(' ');
            ++i2;
        }
        return tmp.toString();
    }

    public static String formatForCode(IAddress addr) {
        return AssemblyFormatter.toHexString(addr, true);
    }

    public static String formatImmediate(long imm) {
        return String.valueOf('$') + AssemblyFormatter.toHexString(imm, true);
    }

    public static String formatImmediate(int imm) {
        return String.valueOf('$') + AssemblyFormatter.toHexString(imm, true);
    }

    public static String formatDisplacement(int displacement) {
        if (displacement < 0) {
            return "-" + AssemblyFormatter.toHexString(-displacement, true);
        }
        return AssemblyFormatter.toHexString(displacement, true);
    }

    public static String formatOffset(int offset) {
        return AssemblyFormatter.toHexString(offset, true);
    }

    public static String formatRegister(String regName, boolean fIndirectAddressing) {
        String ret = "";
        if (fIndirectAddressing) {
            ret = String.valueOf(ret) + '(';
        }
        ret = String.valueOf(ret) + '%' + regName;
        if (fIndirectAddressing) {
            ret = String.valueOf(ret) + ')';
        }
        return ret;
    }

    public static String instructionNameSizeSuffix(int size) {
        return size == 8 ? "b" : (size == 16 ? "w" : "l");
    }
}

