/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.formatter;

import java.util.List;
import org.eclipse.cdt.debug.edc.formatter.AbstractVariableConverter;
import org.eclipse.cdt.debug.edc.formatter.DefaultArrayFormatter;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IMemoryVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.CoreException;

public class DefaultCompositeFormatter
implements IVariableFormatProvider {
    public static boolean handlesType(IType type) {
        IType unqualifiedType = FormatUtils.getUnqualifiedTypeRemovePointers(type);
        return unqualifiedType instanceof ICompositeType;
    }

    public ITypeContentProvider getTypeContentProvider(IType type) {
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (DefaultCompositeFormatter.handlesType(type)) {
            return new DefaultCompositeConverter(type, true);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (DefaultCompositeFormatter.handlesType(type)) {
            return new DefaultCompositeConverter(type, false);
        }
        return null;
    }

    public class DefaultCompositeConverter
    extends AbstractVariableConverter {
        private static final int MAX_DEPTH = 1;
        private static final int STOP_LENGTH = 300;

        public DefaultCompositeConverter(IType type, boolean forDetails) {
            super(type, forDetails);
        }

        protected String getSummaryValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            StringBuilder sb = new StringBuilder();
            this.addVariableFields(null, sb, variable, 0);
            if (sb.length() == 0 && variable instanceof IEDCExpression) {
                IEDCExpression variableEDMC = (IEDCExpression)variable;
                return variableEDMC.getEvaluatedValueString();
            }
            return sb.toString();
        }

        private boolean hasNullLocation(IExpressions.IExpressionDMContext variable) throws CoreException {
            if (variable instanceof IEDCExpression) {
                FormatUtils.evaluateExpression((IEDCExpression)variable);
                IVariableLocation loc = ((IEDCExpression)variable).getEvaluatedLocation();
                if (loc instanceof IMemoryVariableLocation && ((IMemoryVariableLocation)loc).getAddress().isZero()) {
                    return true;
                }
            }
            return false;
        }

        private void addVariableFields(String prefix, StringBuilder sb, IExpressions.IExpressionDMContext variable, int curDepth) throws CoreException {
            if (this.hasNullLocation(variable)) {
                return;
            }
            if (prefix == null) {
                prefix = "";
            }
            List<IExpressions.IExpressionDMContext> childContexts = FormatUtils.getAllChildExpressions(variable);
            for (IExpressions.IExpressionDMContext child : childContexts) {
                IEDCExpression childExpression = (IEDCExpression)child;
                if (this.hasNullLocation(childExpression)) continue;
                IVariableValueConverter customConverter = FormatUtils.getCustomValueConverter(child);
                if (customConverter != null && !(customConverter instanceof DefaultCompositeConverter)) {
                    sb.append(prefix);
                    sb.append(childExpression.getName());
                    sb.append("=");
                    boolean isDefaultArrayConverter = customConverter instanceof DefaultArrayFormatter.DefaultArrayConverter;
                    if (!isDefaultArrayConverter) {
                        sb.append("{");
                    }
                    if (customConverter instanceof AbstractVariableConverter) {
                        ((AbstractVariableConverter)customConverter).setCurValueLength(this.getCurValueLength() + sb.length());
                    }
                    sb.append(customConverter.getValue(child));
                    if (!isDefaultArrayConverter) {
                        sb.append("}");
                    }
                    sb.append(" ");
                } else {
                    IType evaluatedType = childExpression.getEvaluatedType();
                    IType unqualifiedType = FormatUtils.getUnqualifiedTypeRemovePointers(evaluatedType);
                    if (unqualifiedType instanceof ICompositeType) {
                        unqualifiedType = TypeUtils.getStrippedType(evaluatedType);
                        StringBuilder childPrefixSB = new StringBuilder(prefix);
                        String name = childExpression.getName();
                        if (name.startsWith("*")) {
                            childPrefixSB.append('(');
                            childPrefixSB.append(name);
                            childPrefixSB.append(')');
                        } else {
                            childPrefixSB.append(name);
                        }
                        childPrefixSB.append(FormatUtils.getFieldAccessor(unqualifiedType));
                        if (curDepth < 1) {
                            this.addVariableFields(childPrefixSB.toString(), sb, child, ++curDepth);
                        } else {
                            this.addSimpleChild(prefix, sb, childExpression);
                        }
                    } else {
                        this.addSimpleChild(prefix, sb, childExpression);
                    }
                }
                if (this.getCurValueLength() + sb.length() <= 300) continue;
                if (childContexts.get(childContexts.size() - 1).equals(child)) break;
                sb.append("... ");
                break;
            }
        }

        private void addSimpleChild(String prefix, StringBuilder sb, IEDCExpression childExpression) {
            IEDCExpressions expressions = childExpression.getExpressionsService();
            if (expressions == null) {
                return;
            }
            sb.append(prefix);
            sb.append(childExpression.getName());
            sb.append("=");
            sb.append(FormatUtils.getVariableValue(childExpression));
            sb.append(" ");
        }

        protected String getDetailsValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            return this.getSummaryValue(variable);
        }
    }
}

