/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.acpm;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.acpm.AvailableFormatsRequestCache;
import org.eclipse.cdt.debug.edc.acpm.FormatedExpressionValueRequestCache;
import org.eclipse.cdt.debug.edc.acpm.ICacheEntry;
import org.eclipse.cdt.debug.edc.acpm.MemoryRangeCache;
import org.eclipse.cdt.debug.edc.acpm.RegistersByNameRequestCache;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.acpm.LongNoopRequestCache;
import org.eclipse.cdt.debug.edc.internal.acpm.LongRangeNoopRequestCache;
import org.eclipse.cdt.debug.edc.internal.services.dsf.INoop;
import org.eclipse.cdt.debug.edc.launch.ICacheManager;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="fDsfSession.getExecutor()")
public class CacheManager
implements ICacheManager,
DsfSession.SessionEndedListener,
RequestMonitor.ICanceledListener {
    private Set<ICacheEntry> fCachesUsedInThisTransaction = new HashSet<ICacheEntry>();
    private LinkedHashSet<ICacheEntry> fAllCaches = new LinkedHashSet();
    private Map<IDMContext, List<ICacheEntry>> fCachesByContext = new HashMap<IDMContext, List<ICacheEntry>>();
    private Map<RequestMonitor, ICacheEntry> fMonitorToCache = new HashMap<RequestMonitor, ICacheEntry>();
    private final DsfSession fDsfSession;
    private final int fMaxCaches;
    private final int fAllowedOverage;
    private DsfServicesTracker fTracker;
    private boolean fInTransaction;

    @ThreadSafe
    public CacheManager(DsfSession session) {
        this(session, 1000);
    }

    @ThreadSafe
    public CacheManager(DsfSession session, int maxCaches) {
        this.fDsfSession = session;
        this.fTracker = new DsfServicesTracker(EDCDebugger.getBundleContext(), this.fDsfSession.getId());
        this.fMaxCaches = maxCaches;
        this.fAllowedOverage = (int)((float)this.fMaxCaches * 0.2f);
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    public void sessionEnded(DsfSession session) {
        if (this.fDsfSession.equals((Object)session)) {
            this.purgeAll();
            this.fTracker.dispose();
            this.fTracker = null;
            DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
        }
    }

    private List<ICacheEntry> getCacheListForContext(IDMContext dmc) {
        List<ICacheEntry> cacheList = this.fCachesByContext.get(dmc);
        if (cacheList == null) {
            cacheList = new ArrayList<ICacheEntry>();
            this.fCachesByContext.put(dmc, cacheList);
        }
        return cacheList;
    }

    private <T extends ICacheEntry> T reuseCache(ICacheEntry cache) {
        if (EDCTrace.ACPM_TRACE_ON) {
            EDCTrace.getTrace().trace(null, "Reusing cache: " + cache);
        }
        this.fAllCaches.remove(cache);
        this.fAllCaches.add(cache);
        this.fCachesUsedInThisTransaction.add(cache);
        return (T)cache;
    }

    private <T extends ICacheEntry> T newCache(T cache, List<ICacheEntry> cacheList) {
        if (EDCTrace.ACPM_TRACE_ON) {
            EDCTrace.getTrace().trace(null, "New cache: " + cache);
        }
        cache.setMetaData(new MetaData());
        cacheList.add(cache);
        this.fAllCaches.add(cache);
        this.fCachesUsedInThisTransaction.add(cache);
        return cache;
    }

    @Override
    public FormatedExpressionValueRequestCache getFormattedExpressionValue(IFormattedValues service, IFormattedValues.FormattedValueDMContext dmc) {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        assert (this.fInTransaction);
        List<ICacheEntry> cacheList = this.getCacheListForContext((IDMContext)dmc);
        for (ICacheEntry cache : cacheList) {
            if (!(cache instanceof FormatedExpressionValueRequestCache) || !((FormatedExpressionValueRequestCache)cache).getContext().equals(dmc)) continue;
            return (FormatedExpressionValueRequestCache)this.reuseCache(cache);
        }
        return this.newCache(new FormatedExpressionValueRequestCache(service, dmc), cacheList);
    }

    @Override
    public AvailableFormatsRequestCache getAvailableFormats(IFormattedValues service, IFormattedValues.IFormattedDataDMContext dmc) {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        List<ICacheEntry> cacheList = this.getCacheListForContext((IDMContext)dmc);
        for (ICacheEntry cache : cacheList) {
            if (!(cache instanceof FormatedExpressionValueRequestCache) || !((FormatedExpressionValueRequestCache)cache).getContext().equals(dmc)) continue;
            return (AvailableFormatsRequestCache)this.reuseCache(cache);
        }
        for (ICacheEntry cache : cacheList) {
            if (!(cache instanceof AvailableFormatsRequestCache) || !((AvailableFormatsRequestCache)cache).getContext().equals(dmc)) continue;
            return (AvailableFormatsRequestCache)this.reuseCache(cache);
        }
        return this.newCache(new AvailableFormatsRequestCache(service, (IDMContext)dmc), cacheList);
    }

    @Override
    public RegistersByNameRequestCache getRegistersByName(IDMContext dmc) {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        assert (this.fInTransaction);
        List<ICacheEntry> cacheList = this.getCacheListForContext(dmc);
        for (ICacheEntry cache : cacheList) {
            if (!(cache instanceof RegistersByNameRequestCache) || !((RegistersByNameRequestCache)cache).getContext().equals(dmc)) continue;
            return (RegistersByNameRequestCache)this.reuseCache(cache);
        }
        IRegisters service = (IRegisters)this.fTracker.getService(IRegisters.class);
        if (service != null) {
            return this.newCache(new RegistersByNameRequestCache(service, dmc), cacheList);
        }
        return null;
    }

    @Override
    public MemoryRangeCache getMemory(IMemory.IMemoryDMContext dmc, IAddress address, int wordSize) {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        assert (this.fInTransaction);
        List<ICacheEntry> cacheList = this.getCacheListForContext((IDMContext)dmc);
        for (ICacheEntry cache : cacheList) {
            if (!(cache instanceof MemoryRangeCache) || !((MemoryRangeCache)cache).getContext().equals(dmc)) continue;
            return (MemoryRangeCache)this.reuseCache(cache);
        }
        IMemory service = (IMemory)this.fTracker.getService(IMemory.class);
        if (service != null) {
            return this.newCache(new MemoryRangeCache(service, (IDMContext)dmc, address, wordSize), cacheList);
        }
        return null;
    }

    @Override
    public void beginTransaction() {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        assert (this.fCachesUsedInThisTransaction.size() == 0);
        this.fCachesUsedInThisTransaction.clear();
        this.fInTransaction = true;
    }

    @Override
    public void endTransaction(boolean failedInvalidCache) {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        this.fInTransaction = false;
        if (EDCTrace.ACPM_TRACE_ON) {
            if (failedInvalidCache) {
                EDCTrace.getTrace().trace(null, "The transaction attempt encountered one or more invalid cache objects.");
            } else {
                EDCTrace.getTrace().trace(null, "The completed transaction took " + this.fCachesUsedInThisTransaction.size() + " caches.");
            }
        }
        for (ICacheEntry used : this.fCachesUsedInThisTransaction) {
            ((MetaData)used.getMetaData()).inUse = failedInvalidCache;
            RequestMonitor rm = used.getRequestMonitor();
            if (rm == null) continue;
            if (failedInvalidCache) {
                rm.addCancelListener((RequestMonitor.ICanceledListener)this);
                this.fMonitorToCache.put(rm, used);
                continue;
            }
            rm.removeCancelListener((RequestMonitor.ICanceledListener)this);
            this.fMonitorToCache.remove(rm);
        }
        assert (this.totalCacheCount() == this.fAllCaches.size());
        int overage = this.fAllCaches.size() - this.fMaxCaches;
        if (overage > this.fAllowedOverage) {
            HashSet<ICacheEntry> removeThese = new HashSet<ICacheEntry>(overage);
            int discardCount = 0;
            Iterator iter = this.fAllCaches.iterator();
            while (iter.hasNext() && discardCount < overage) {
                ICacheEntry cache = (ICacheEntry)iter.next();
                MetaData mdata = (MetaData)cache.getMetaData();
                if (mdata.inUse) continue;
                removeThese.add(cache);
                iter.remove();
                ++discardCount;
            }
            if (discardCount > 0) {
                if (EDCTrace.ACPM_TRACE_ON) {
                    EDCTrace.getTrace().trace(null, "Going to discard " + discardCount + " caches");
                }
                ArrayList<ICacheEntry> removeForThisContext = new ArrayList<ICacheEntry>(this.fAllCaches.size() - this.fMaxCaches);
                Iterator<Map.Entry<IDMContext, List<ICacheEntry>>> citer = this.fCachesByContext.entrySet().iterator();
                while (citer.hasNext()) {
                    Map.Entry<IDMContext, List<ICacheEntry>> entry = citer.next();
                    removeForThisContext.clear();
                    List<ICacheEntry> cachesForThisContext = entry.getValue();
                    for (ICacheEntry cache : cachesForThisContext) {
                        if (!removeThese.contains(cache)) continue;
                        if (EDCTrace.ACPM_TRACE_ON) {
                            EDCTrace.getTrace().trace(null, "Removing cache: " + cache);
                        }
                        removeForThisContext.add(cache);
                        cache.dispose();
                    }
                    if (removeForThisContext.size() <= 0) continue;
                    cachesForThisContext.removeAll(removeForThisContext);
                    if (cachesForThisContext.size() != 0) continue;
                    citer.remove();
                }
            }
        }
        assert (this.totalCacheCount() == this.fAllCaches.size());
        this.fCachesUsedInThisTransaction.clear();
    }

    private int totalCacheCount() {
        int count = 0;
        for (Map.Entry<IDMContext, List<ICacheEntry>> entry : this.fCachesByContext.entrySet()) {
            count += entry.getValue().size();
        }
        return count;
    }

    @Override
    public void purgeAll() {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        if (EDCTrace.ACPM_TRACE_ON) {
            EDCTrace.getTrace().trace(null, "Purging all cache objects.");
        }
        for (Map.Entry<IDMContext, List<ICacheEntry>> entry : this.fCachesByContext.entrySet()) {
            List<ICacheEntry> caches = entry.getValue();
            for (ICacheEntry cache : caches) {
                cache.dispose();
            }
            caches.clear();
        }
        this.fCachesByContext.clear();
        this.fAllCaches.clear();
    }

    public void dumpStats() {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        System.out.println("There are " + this.fAllCaches.size() + " total caches.");
        for (Map.Entry<IDMContext, List<ICacheEntry>> entry : this.fCachesByContext.entrySet()) {
            IDMContext dmc = entry.getKey();
            System.out.println("Context: " + dmc.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(dmc)));
            List<ICacheEntry> caches = entry.getValue();
            for (ICacheEntry cache : caches) {
                MetaData md = (MetaData)cache.getMetaData();
                Formatter formatter = new Formatter();
                formatter.format("%s [inUse=%b, usedInCurrentTransaction=%b]", cache.toString(), md.inUse, md.usedInCurrentTransaction);
                System.out.println(formatter.toString());
            }
        }
    }

    public LongNoopRequestCache getLongNoop(IDMContext dmc) {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        assert (this.fInTransaction);
        List<ICacheEntry> cacheList = this.getCacheListForContext(dmc);
        for (ICacheEntry cache : cacheList) {
            if (!(cache instanceof LongNoopRequestCache) || !((LongNoopRequestCache)cache).getContext().equals(dmc)) continue;
            return (LongNoopRequestCache)this.reuseCache(cache);
        }
        INoop service = (INoop)this.fTracker.getService(INoop.class);
        if (service != null) {
            return this.newCache(new LongNoopRequestCache(service, dmc), cacheList);
        }
        return null;
    }

    public LongRangeNoopRequestCache getLongRangeNoop(IDMContext dmc) {
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        assert (this.fInTransaction);
        List<ICacheEntry> cacheList = this.getCacheListForContext(dmc);
        for (ICacheEntry cache : cacheList) {
            if (!(cache instanceof LongRangeNoopRequestCache) || !((LongRangeNoopRequestCache)cache).getContext().equals(dmc)) continue;
            return (LongRangeNoopRequestCache)this.reuseCache(cache);
        }
        INoop service = (INoop)this.fTracker.getService(INoop.class);
        if (service != null) {
            return this.newCache(new LongRangeNoopRequestCache(service, dmc), cacheList);
        }
        return null;
    }

    public void requestCanceled(RequestMonitor rm) {
        ICacheEntry cache;
        assert (this.fDsfSession.getExecutor().isInExecutorThread());
        if (EDCTrace.ACPM_TRACE_ON) {
            EDCTrace.getTrace().trace(null, "RM " + rm.toString() + " was canceled");
        }
        if ((cache = this.fMonitorToCache.get(rm)) != null) {
            if (EDCTrace.ACPM_TRACE_ON) {
                EDCTrace.getTrace().trace(null, "Canceled RM is associated with cache: " + cache);
            }
            rm.removeCancelListener((RequestMonitor.ICanceledListener)this);
            ((MetaData)cache.getMetaData()).inUse = false;
        }
    }

    class MetaData {
        boolean usedInCurrentTransaction;
        boolean inUse;

        MetaData() {
        }
    }
}

