/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.PointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.RegisterVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.core.runtime.CoreException;

public class OperatorAddrOf
extends CompoundInstruction {
    public OperatorAddrOf(int start) {
        super(start);
    }

    public void execute() throws CoreException {
        OperandValue operand = this.popValue();
        if (operand.getValueLocation() == null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorAddrOf_RequiresVariable);
        }
        IType subType = operand.getValueType();
        if (operand.getValueLocation() instanceof RegisterVariableLocation) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorAddrOf_NoRegister);
        }
        if (operand.isBitField()) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorAddrOf_NoBitField);
        }
        PointerType pointer = new PointerType();
        pointer.setType(subType);
        OperandValue addr = new OperandValue(pointer);
        addr.setValueLocation(operand.getValueLocation());
        addr.setValue(operand.getValueLocationAddress());
        this.push(addr);
    }
}

