/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.SimpleInstruction;

public class PushChar
extends SimpleInstruction {
    private static final char BELL = '\u0007';
    private static final char VERTICAL_TAB = '\u000b';
    private long fValue;
    private boolean isWide;
    private boolean multiChar;

    public PushChar(char value) {
        this.fValue = (short)value;
    }

    public PushChar(String value) throws NumberFormatException {
        this.parseCharValue(value);
    }

    public void execute() {
        if (this.multiChar) {
            this.pushNewValue(this.fInterpreter.getTypeEngine().getIntegerTypeOfSize(4, false), this.fValue);
            return;
        }
        if (!this.isWide) {
            this.pushNewValue(this.fInterpreter.getTypeEngine().getCharacterType(this.fInterpreter.getTypeEngine().getTypeSize(1)), this.fValue);
        } else {
            this.pushNewValue(this.fInterpreter.getTypeEngine().getCharacterType(this.fInterpreter.getTypeEngine().getTypeSize(20)), this.fValue);
        }
    }

    public String toString() {
        if (this.fValue < 65536L) {
            return "" + (char)this.fValue;
        }
        char[] surrogate = new char[]{(char)(this.fValue >> 16), (char)(this.fValue & 0xFFFFL)};
        return new String(surrogate);
    }

    private void parseCharValue(String value) throws NumberFormatException {
        if (value.startsWith("L")) {
            this.isWide = true;
            value = value.substring(1);
        }
        if (value.length() < 3 || value.charAt(0) != '\'' || !value.endsWith("'")) {
            throw new NumberFormatException();
        }
        if ((value = value.substring(1, value.length() - 1)).startsWith("\\u")) {
            if (value.length() < 3) {
                throw new NumberFormatException();
            }
            this.fValue = Long.parseLong(value.substring(2), 16);
            return;
        }
        if (value.startsWith("\\")) {
            if (value.length() < 2) {
                throw new NumberFormatException();
            }
            if (value.charAt(1) >= '0' && value.charAt(1) <= '7') {
                if (value.length() > 4) {
                    throw new NumberFormatException();
                }
                this.fValue = Long.parseLong(value.substring(1), 8);
                return;
            }
            if (value.length() > 2) {
                throw new NumberFormatException();
            }
            switch (value.charAt(1)) {
                case 'n': {
                    this.fValue = 10L;
                    break;
                }
                case 't': {
                    this.fValue = 9L;
                    break;
                }
                case 'v': {
                    this.fValue = 11L;
                    break;
                }
                case 'b': {
                    this.fValue = 8L;
                    break;
                }
                case 'r': {
                    this.fValue = 13L;
                    break;
                }
                case 'f': {
                    this.fValue = 12L;
                    break;
                }
                case 'a': {
                    this.fValue = 7L;
                    break;
                }
                case '\\': {
                    this.fValue = 92L;
                    break;
                }
                case '?': {
                    this.fValue = 63L;
                    break;
                }
                case '\'': {
                    this.fValue = 39L;
                    break;
                }
                case '\"': {
                    this.fValue = 34L;
                    break;
                }
                default: {
                    this.fValue = value.charAt(1);
                }
            }
            return;
        }
        this.multiChar = value.length() > 1;
        this.fValue = 0L;
        int i = 0;
        while (i < value.length()) {
            this.fValue = (this.fValue << 8) + (long)value.charAt(i);
            ++i;
        }
    }
}

