/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.formatter.AbstractCompositeFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.core.runtime.CoreException;

public class QListFormatter
implements IVariableFormatProvider {
    private static final String TYPE_NAME = "QList";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, true);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatProvider
    extends AbstractCompositeFormatProvider {
        private static final String BEGIN_NAME = "begin";
        private static final String BEGIN_PATH = "$unnamed$1.d->begin";
        private static final String END_NAME = "end";
        private static final String END_PATH = "$unnamed$1.d->end";
        private static final String ARRAY_NAME = "array";
        private static final String ARRAY_PATH = "$unnamed$1.d->array";
        private static final int BEGIN_CHILD_INDEX = 0;
        private static final int END_CHILD_INDEX = 1;
        private static final int ARRAY_CHILD_INDEX = 2;
        private static final String DETAIL_SIZE_FMT = "size={0}";
        private static final String DETAIL_FMT = "size={0} {1}";
        private static Map<String, String> nameToFieldPathMap = new LinkedHashMap<String, String>();

        static {
            nameToFieldPathMap.put(BEGIN_NAME, BEGIN_PATH);
            nameToFieldPathMap.put(END_NAME, END_PATH);
            nameToFieldPathMap.put(ARRAY_NAME, ARRAY_PATH);
        }

        public FormatProvider(IType type, boolean forDetails) {
            super(type, forDetails, FormatProvider.getNameToFieldPaths());
        }

        private static List<AbstractCompositeFormatProvider.NameToFieldPath> getNameToFieldPaths() {
            ArrayList<AbstractCompositeFormatProvider.NameToFieldPath> nameToFieldPaths = new ArrayList<AbstractCompositeFormatProvider.NameToFieldPath>();
            nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(BEGIN_NAME, BEGIN_PATH));
            nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(END_NAME, END_PATH));
            nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(ARRAY_NAME, ARRAY_PATH));
            return nameToFieldPaths;
        }

        @Override
        public int getChildCount(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            for (IExpressions.IExpressionDMContext child : super.getChildren(variable)) {
                String name = ((IEDCExpression)child).getName();
                if (!nameToFieldPathMap.containsKey(name)) continue;
                children.add(child);
            }
            IEDCExpression beginChild = (IEDCExpression)children.get(0);
            FormatUtils.evaluateExpression(beginChild);
            int begin = beginChild.getEvaluatedValue().intValue();
            IEDCExpression endChild = (IEDCExpression)children.get(1);
            FormatUtils.evaluateExpression(endChild);
            int end = endChild.getEvaluatedValue().intValue();
            int size = end - begin;
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            return size;
        }

        @Override
        protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            for (IExpressions.IExpressionDMContext child : super.getChildren(variable)) {
                String name = ((IEDCExpression)child).getName();
                if (!nameToFieldPathMap.containsKey(name)) continue;
                children.add(child);
            }
            IEDCExpression beginChild = (IEDCExpression)children.get(0);
            FormatUtils.evaluateExpression(beginChild);
            int begin = beginChild.getEvaluatedValue().intValue();
            IEDCExpression endChild = (IEDCExpression)children.get(1);
            FormatUtils.evaluateExpression(endChild);
            int end = endChild.getEvaluatedValue().intValue();
            int size = end - begin;
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            IEDCExpression arrayChild = (IEDCExpression)children.get(2);
            IEDCExpressions expressions2 = arrayChild.getExpressionsService();
            int numItems = Math.min(size, FormatUtils.getMaxNumberOfChildren());
            if (numItems == 0) {
                children.remove(2);
            } else {
                IExpressions2.CastInfo castInfo = new IExpressions2.CastInfo(FormatUtils.getTemplateTypeName(QListFormatter.TYPE_NAME, this.type), begin, numItems);
                IExpressions2.ICastedExpressionDMContext castedArrayChild = expressions2.createCastedExpression(arrayChild, castInfo);
                children.set(2, (IExpressions.IExpressionDMContext)castedArrayChild);
            }
            return children;
        }

        @Override
        public String getValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            int count = this.getChildCount(variable);
            return MessageFormat.format(DETAIL_SIZE_FMT, count);
        }

        protected String getFullStringValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
            IExpressions.IExpressionDMContext arrayChild = children.get(2);
            IVariableValueConverter valueConverter = FormatUtils.getCustomValueConverter(arrayChild);
            if (valueConverter != null) {
                IEDCExpression beginChild = (IEDCExpression)children.get(0);
                int begin = beginChild.getEvaluatedValue().intValue();
                IEDCExpression endChild = (IEDCExpression)children.get(1);
                int end = endChild.getEvaluatedValue().intValue();
                return MessageFormat.format(DETAIL_FMT, end - begin, valueConverter.getValue(arrayChild));
            }
            return "";
        }
    }
}

