/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.formatter.AbstractCompositeFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.core.runtime.CoreException;

public class QSetQHashFormatter
implements IVariableFormatProvider {
    private static final String QSET_NAME = "QSet";
    private static final String QHASH_NAME = "QHash";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        boolean isQSet = FormatUtils.checkClassOrInheritanceByName(type, QSET_NAME);
        if (isQSet || FormatUtils.checkClassOrInheritanceByName(type, QHASH_NAME)) {
            return new FormatProvider(type, false, isQSet);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        boolean isQSet = FormatUtils.checkClassOrInheritanceByName(type, QSET_NAME);
        if (isQSet || FormatUtils.checkClassOrInheritanceByName(type, QHASH_NAME)) {
            return new FormatProvider(type, false, isQSet);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        boolean isQSet = FormatUtils.checkClassOrInheritanceByName(type, QSET_NAME);
        if (isQSet || FormatUtils.checkClassOrInheritanceByName(type, QHASH_NAME)) {
            return new FormatProvider(type, true, isQSet);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatProvider
    extends AbstractCompositeFormatProvider {
        private static final String SIZE_NAME = "size";
        private static final String SIZE_PATH = "$unnamed$1.d->size";
        private static final String NUM_BUCKETS_NAME = "numBuckets";
        private static final String NUM_BUCKETS_PATH = "$unnamed$1.d->numBuckets";
        private static final String SANITY_TEST_NAME = "fakeNext";
        private static final String SANITY_TEST_PATH = "$unnamed$1.d->fakeNext";
        private static final String BUCKETS_NAME = "buckets";
        private static final String BUCKETS_PATH = "$unnamed$1.d->buckets";
        private static final String QSET_PATH_PREFIX = "q_hash.";
        private static final int SIZE_CHILD_INDEX = 0;
        private static final int NUM_BUCKETS_CHILD_INDEX = 1;
        private static final int BUCKETS_CHILD_INDEX = 2;
        private static final int SANITY_TEST_CHILD_INDEX = 3;
        private static final int NODE_NEXT_CHILD_INDEX = 0;
        private static final String HASH_NODE_CAST_FMT = "reinterpret_cast<QHashNode<{0}>*>({1})";
        private static final String DUMMY_VALUE_TYPE_ADD = ", QHashDummyValue";
        private static final String DETAIL_SIZE_FMT = "size={0}";
        private static final String DETAIL_FMT = "size={0} {1}";
        private static final int STOP_LENGTH = 300;
        private static Map<String, String> nameToFieldPathMap = new LinkedHashMap<String, String>();
        private final boolean isQSet;

        static {
            nameToFieldPathMap.put(SIZE_NAME, SIZE_PATH);
            nameToFieldPathMap.put(NUM_BUCKETS_NAME, NUM_BUCKETS_PATH);
            nameToFieldPathMap.put(BUCKETS_NAME, BUCKETS_PATH);
            nameToFieldPathMap.put(SANITY_TEST_NAME, SANITY_TEST_PATH);
        }

        public FormatProvider(IType type, boolean forDetails, boolean isQSet) {
            super(type, forDetails, FormatProvider.getNameToFieldPaths(isQSet));
            this.isQSet = isQSet;
        }

        private static List<AbstractCompositeFormatProvider.NameToFieldPath> getNameToFieldPaths(boolean isQSet) {
            ArrayList<AbstractCompositeFormatProvider.NameToFieldPath> nameToFieldPaths = new ArrayList<AbstractCompositeFormatProvider.NameToFieldPath>();
            for (Map.Entry<String, String> entry : nameToFieldPathMap.entrySet()) {
                String value = entry.getValue();
                nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(entry.getKey(), isQSet ? QSET_PATH_PREFIX + value : value));
            }
            return nameToFieldPaths;
        }

        @Override
        public int getChildCount(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            for (IExpressions.IExpressionDMContext child : super.getChildren(variable)) {
                String name = ((IEDCExpression)child).getName();
                if (!nameToFieldPathMap.containsKey(name)) continue;
                children.add(child);
            }
            IEDCExpression sanityTestChild = (IEDCExpression)children.remove(3);
            FormatUtils.evaluateExpression(sanityTestChild);
            int shouldBeZero = sanityTestChild.getEvaluatedValue().intValue();
            if (shouldBeZero != 0) {
                throw EDCDebugger.newCoreException("uninitialized");
            }
            IEDCExpression sizeExp = (IEDCExpression)children.get(0);
            FormatUtils.evaluateExpression(sizeExp);
            int size = sizeExp.getEvaluatedValue().intValue();
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            return size;
        }

        @Override
        protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            for (IExpressions.IExpressionDMContext child : super.getChildren(variable)) {
                String name = ((IEDCExpression)child).getName();
                if (!nameToFieldPathMap.containsKey(name)) continue;
                children.add(child);
            }
            IEDCExpression sanityTestChild = (IEDCExpression)children.remove(3);
            IEDCExpression bucketsChild = (IEDCExpression)children.remove(2);
            IEDCExpression numBucketsChild = (IEDCExpression)children.remove(1);
            FormatUtils.evaluateExpression(sanityTestChild);
            int shouldBeZero = sanityTestChild.getEvaluatedValue().intValue();
            if (shouldBeZero != 0) {
                throw EDCDebugger.newCoreException("uninitialized");
            }
            FormatUtils.evaluateExpression(numBucketsChild);
            int numBuckets = numBucketsChild.getEvaluatedValue().intValue();
            if (numBuckets > 0) {
                IEDCExpressions expressions2 = bucketsChild.getExpressionsService();
                IExpressions2.ICastedExpressionDMContext castedBucketsChild = expressions2.createCastedExpression(bucketsChild, new IExpressions2.CastInfo(0, numBuckets));
                IEDCExpressions expressions = bucketsChild.getExpressionsService();
                List<IExpressions.IExpressionDMContext> bucketsChildExpressions = FormatUtils.getAllChildExpressions((IExpressions.IExpressionDMContext)castedBucketsChild);
                int nameIndex = 0;
                for (IExpressions.IExpressionDMContext bucketChild : bucketsChildExpressions) {
                    List<IEDCExpression> hashNodes = this.getHashNodesFromBucket((IExpressions)expressions, bucketChild);
                    for (IEDCExpression hashNode : hashNodes) {
                        IEDCExpression subExpression = (IEDCExpression)expressions.createExpression((IDMContext)variable, hashNode.getExpression());
                        subExpression.setName("" + nameIndex++);
                        children.add(subExpression);
                    }
                    if (nameIndex <= FormatUtils.getMaxNumberOfChildren()) continue;
                    IEDCExpression moreExpression = (IEDCExpression)expressions.createExpression((IDMContext)variable, "0");
                    moreExpression.setName("more...");
                    children.add(moreExpression);
                    break;
                }
            }
            return children;
        }

        private List<IEDCExpression> getHashNodesFromBucket(IExpressions expressions, IExpressions.IExpressionDMContext nodeChild) throws CoreException {
            ArrayList<IEDCExpression> hashNodes = new ArrayList<IEDCExpression>();
            IEDCExpression nextExp = this.getNextExpression(nodeChild);
            while (nextExp != null) {
                String templateTypeName = FormatUtils.getTemplateTypeName(this.isQSet ? QSetQHashFormatter.QSET_NAME : QSetQHashFormatter.QHASH_NAME, this.type);
                if (this.isQSet) {
                    templateTypeName = String.valueOf(templateTypeName) + DUMMY_VALUE_TYPE_ADD;
                }
                String expression = MessageFormat.format(HASH_NODE_CAST_FMT, templateTypeName, nextExp.getEvaluatedLocation().toString());
                IEDCExpression hashNodeChild = (IEDCExpression)expressions.createExpression((IDMContext)((IEDCExpression)nodeChild).getFrame(), expression);
                FormatUtils.evaluateExpression(hashNodeChild);
                hashNodes.add(hashNodeChild);
                nextExp = this.getNextExpression(nextExp);
            }
            return hashNodes;
        }

        private IEDCExpression getNextExpression(IExpressions.IExpressionDMContext nodeChild) throws CoreException {
            FormatUtils.evaluateExpression((IEDCExpression)nodeChild);
            List<IExpressions.IExpressionDMContext> nodeFields = FormatUtils.getAllChildExpressions(nodeChild);
            IEDCExpression nextExp = (IEDCExpression)nodeFields.get(0);
            FormatUtils.evaluateExpression(nextExp);
            Number nextValue = nextExp.getEvaluatedValue();
            if (nextValue.intValue() != 0) {
                return nextExp;
            }
            return null;
        }

        @Override
        public String getValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            int count = this.getChildCount(variable);
            return MessageFormat.format(DETAIL_SIZE_FMT, count);
        }

        protected String getFullStringValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
            IEDCExpression sizeExp = (IEDCExpression)children.get(0);
            StringBuilder sb = new StringBuilder("[");
            int i = 1;
            while (i < children.size()) {
                String elementString;
                IEDCExpression elementChild = (IEDCExpression)children.get(i);
                if (i > 1) {
                    sb.append(", ");
                }
                if ((elementString = FormatUtils.getFormattedValue(elementChild)) != null) {
                    sb.append('{');
                    sb.append(elementString);
                    sb.append('}');
                }
                if (sb.length() > 300) {
                    if (children.get(children.size() - 1).equals(elementChild)) break;
                    sb.append(", ...");
                    break;
                }
                ++i;
            }
            return MessageFormat.format(DETAIL_FMT, FormatUtils.getVariableValue(sizeExp), sb.append(']').toString());
        }
    }
}

