/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.formatter.AbstractCompositeFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.core.runtime.CoreException;

public class QVectorFormatter
implements IVariableFormatProvider {
    private static final String TYPE_NAME = "QVector";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, true);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatProvider
    extends AbstractCompositeFormatProvider {
        private static final String SIZE_NAME = "size";
        private static final String SIZE_PATH = "$unnamed$1.d->size";
        private static final String ARRAY_NAME = "array";
        private static final String ARRAY_PATH = "$unnamed$1.p->array";
        private static final int SIZE_CHILD_INDEX = 0;
        private static final int ARRAY_CHILD_INDEX = 1;
        private static final String DETAIL_SIZE_FMT = "size={0}";
        private static final String DETAIL_FMT = "size={0} {1}";
        private static Map<String, String> nameToFieldPathMap = new LinkedHashMap<String, String>();

        static {
            nameToFieldPathMap.put(SIZE_NAME, SIZE_PATH);
            nameToFieldPathMap.put(ARRAY_NAME, ARRAY_PATH);
        }

        public FormatProvider(IType type, boolean forDetails) {
            super(type, forDetails, FormatProvider.getNameToFieldPaths());
        }

        private static List<AbstractCompositeFormatProvider.NameToFieldPath> getNameToFieldPaths() {
            ArrayList<AbstractCompositeFormatProvider.NameToFieldPath> nameToFieldPaths = new ArrayList<AbstractCompositeFormatProvider.NameToFieldPath>();
            for (Map.Entry<String, String> entry : nameToFieldPathMap.entrySet()) {
                nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(entry.getKey(), entry.getValue()));
            }
            return nameToFieldPaths;
        }

        @Override
        public int getChildCount(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            for (IExpressions.IExpressionDMContext child : super.getChildren(variable)) {
                String name = ((IEDCExpression)child).getName();
                if (!nameToFieldPathMap.containsKey(name)) continue;
                children.add(child);
            }
            IEDCExpression sizeChild = (IEDCExpression)children.get(0);
            FormatUtils.evaluateExpression(sizeChild);
            int size = sizeChild.getEvaluatedValue().intValue();
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            return size;
        }

        @Override
        protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            for (IExpressions.IExpressionDMContext child : super.getChildren(variable)) {
                String name = ((IEDCExpression)child).getName();
                if (!nameToFieldPathMap.containsKey(name)) continue;
                children.add(child);
            }
            IEDCExpression sizeChild = (IEDCExpression)children.get(0);
            FormatUtils.evaluateExpression(sizeChild);
            int size = sizeChild.getEvaluatedValue().intValue();
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            if (size == 0) {
                children.remove(1);
            } else if (size > 1) {
                IEDCExpression arrayChild = (IEDCExpression)children.get(1);
                IEDCExpressions expressions2 = arrayChild.getExpressionsService();
                IExpressions2.CastInfo castInfo = new IExpressions2.CastInfo(0, Math.min(size, FormatUtils.getMaxNumberOfChildren()));
                IExpressions2.ICastedExpressionDMContext castedArrayChild = expressions2.createCastedExpression(arrayChild, castInfo);
                children.set(1, (IExpressions.IExpressionDMContext)castedArrayChild);
            }
            return children;
        }

        @Override
        public String getValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            int count = this.getChildCount(variable);
            return MessageFormat.format(DETAIL_SIZE_FMT, count);
        }

        protected String getFullStringValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
            IExpressions.IExpressionDMContext arrayChild = children.get(1);
            IVariableValueConverter valueConverter = FormatUtils.getCustomValueConverter(arrayChild);
            if (valueConverter != null) {
                IEDCExpression sizeExp = (IEDCExpression)children.get(0);
                return MessageFormat.format(DETAIL_FMT, sizeExp.getEvaluatedValueString(), valueConverter.getValue(arrayChild));
            }
            return "";
        }
    }
}

