/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.IMemoryAccess;
import org.eclipse.cdt.debug.edc.internal.scripting.DOMUtils;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.MemoryByte;

public class MemoryAccess
implements IMemoryAccess {
    public MemoryByte[] getMemoryValues(final DsfSession session, final IEDCExecutionDMC exe_dmc, final String memoryAddress, final int length) throws Exception {
        Query<MemoryByte[]> query = new Query<MemoryByte[]>(){

            protected void execute(DataRequestMonitor<MemoryByte[]> drm) {
                DsfServicesTracker servicesTracker = DOMUtils.getDsfServicesTracker(session);
                Memory memoryService = (Memory)servicesTracker.getService(Memory.class);
                if (memoryService != null) {
                    IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)exe_dmc, IMemory.IMemoryDMContext.class);
                    Addr64 start = new Addr64(memoryAddress);
                    memoryService.getMemory(mem_dmc, (IAddress)start, 0L, 1, length, drm);
                }
            }
        };
        session.getExecutor().execute((Runnable)query);
        return (MemoryByte[])query.get();
    }

    public boolean changeMemoryValue(final DsfSession session, final IEDCExecutionDMC exe_dmc, final String memoryAddress, final byte[] newMemoryValue) throws Exception {
        Query<IStatus> query = new Query<IStatus>(){

            protected void execute(DataRequestMonitor<IStatus> drm) {
                DsfServicesTracker servicesTracker = DOMUtils.getDsfServicesTracker(session);
                Memory memoryService = (Memory)servicesTracker.getService(Memory.class);
                if (memoryService != null) {
                    IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)exe_dmc, IMemory.IMemoryDMContext.class);
                    Addr64 start = new Addr64(memoryAddress);
                    memoryService.setMemory(mem_dmc, (IAddress)start, 0L, 1, newMemoryValue.length, newMemoryValue, (RequestMonitor)drm);
                }
            }
        };
        session.getExecutor().execute((Runnable)query);
        return ((IStatus)query.get()).getSeverity() == 0;
    }
}

