/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.services.dsf.LineEntryMapper;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.internal.symbols.IRuntimeSection;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;
import org.eclipse.cdt.debug.edc.internal.symbols.RuntimeSection;
import org.eclipse.cdt.debug.edc.internal.symbols.Section;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ExecutableSymbolicsReaderFactory;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.ILineEntryProvider;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modules
extends AbstractEDCService
implements IModules,
IEDCModules {
    public static final String MODULE = "module";
    public static final String SECTION = "section";
    private static final String ADDRESS_RANGE_CACHE = "_address_range";
    private static final String LINE_ADDRESSES_CACHE = "_line_addresses";
    private static final String NO_FILE_CACHE = "_no_file";
    private final Map<String, List<ModuleDMC>> modules = Collections.synchronizedMap(new HashMap());
    private ISourceLocator sourceLocator;
    private static int nextModuleID = 100;

    public Modules(DsfSession session) {
        super(session, new String[]{IModules.class.getName(), IEDCModules.class.getName(), Modules.class.getName()});
    }

    public void setSourceLocator(ISourceLocator sourceLocator) {
        this.sourceLocator = sourceLocator;
    }

    public ISourceLocator getSourceLocator() {
        return this.sourceLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModule(ModuleDMC module) {
        IModules.ISymbolDMContext symContext = module.getSymbolContext();
        if (symContext instanceof IEDCDMContext) {
            String symContextID = ((IEDCDMContext)symContext).getID();
            Map<String, List<ModuleDMC>> map = this.modules;
            synchronized (map) {
                List<ModuleDMC> moduleList = this.modules.get(symContextID);
                if (moduleList == null) {
                    moduleList = Collections.synchronizedList(new ArrayList());
                    this.modules.put(symContextID, moduleList);
                }
                moduleList.add(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(ModuleDMC module) {
        IModules.ISymbolDMContext symContext = module.getSymbolContext();
        if (symContext instanceof IEDCDMContext) {
            String symContextID = ((IEDCDMContext)symContext).getID();
            Map<String, List<ModuleDMC>> map = this.modules;
            synchronized (map) {
                List<ModuleDMC> moduleList = this.modules.get(symContextID);
                if (moduleList != null) {
                    for (ModuleDMC next : moduleList) {
                        if (!next.getFile().equals(module.getFile())) continue;
                        moduleList.remove(next);
                        break;
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void calcAddressInfo(IModules.ISymbolDMContext symCtx, String file, int line, int col, DataRequestMonitor<IModules.AddressRange[]> rm) {
        moduleList = null;
        if (symCtx instanceof IEDCExecutionDMC) {
            symContextID = ((IEDCDMContext)symCtx).getID();
            moduleList = this.getModulesForContext(symContextID);
        } else if (symCtx instanceof IModules.IModuleDMContext) {
            moduleList = new IModules.IModuleDMContext[]{(IModules.IModuleDMContext)symCtx};
        } else {
            if (!Modules.$assertionsDisabled) {
                throw new AssertionError((Object)"Unknown ISymbolDMContext class.");
            }
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, MessageFormat.format("Unknown class implementing ISymbolDMContext : {0}", new Object[]{symCtx.getClass().getName()}), null));
            rm.done();
            return;
        }
        addrRanges = new ArrayList<EDCAddressRange>(1);
        var11_8 = moduleList;
        var10_9 = moduleList.length;
        var9_10 = 0;
        while (var9_10 < var10_9) {
            block13: {
                module = var11_8[var9_10];
                mdmc = (ModuleDMC)module;
                reader = mdmc.getSymbolReader();
                if (reader == null) break block13;
                linkAddressRanges = null;
                cachedRanges = new HashMap<K, V>();
                cacheKey = String.valueOf(reader.getSymbolFile().toOSString()) + "_address_range";
                noFileCacheKey = String.valueOf(reader.getSymbolFile().toOSString()) + "_no_file";
                noFileCachedData = EDCDebugger.getDefault().getCache().getCachedData(noFileCacheKey, Set.class, reader.getModificationDate());
                if (noFileCachedData != null && noFileCachedData.contains(file)) break block13;
                cachedData = EDCDebugger.getDefault().getCache().getCachedData(cacheKey, Map.class, reader.getModificationDate());
                if (cachedData != null) {
                    cachedRanges = cachedData;
                    linkAddressRanges = (Collection)cachedRanges.get(String.valueOf(file) + line);
                }
                if (linkAddressRanges != null) ** GOTO lbl45
                linkAddressRanges = LineEntryMapper.getAddressRangesAtSource(reader.getModuleScope().getModuleLineEntryProvider(), PathUtils.createPath(file), line);
                if (linkAddressRanges == null) {
                    if (noFileCachedData == null) {
                        noFileCachedData = new HashSet<String>();
                    }
                    noFileCachedData.add(file);
                    EDCDebugger.getDefault().getCache().putCachedData(noFileCacheKey, noFileCachedData, reader.getModificationDate());
                } else {
                    cachedRanges.put(String.valueOf(file) + line, linkAddressRanges);
                    EDCDebugger.getDefault().getCache().putCachedData(cacheKey, (Serializable)cachedRanges, reader.getModificationDate());
lbl45:
                    // 3 sources

                    for (IModules.AddressRange linkAddressRange : linkAddressRanges) {
                        addrRange = new EDCAddressRange(mdmc.toRuntimeAddress(linkAddressRange.getStartAddress()), mdmc.toRuntimeAddress(linkAddressRange.getEndAddress()));
                        addrRanges.add(addrRange);
                    }
                }
            }
            ++var9_10;
        }
        if (addrRanges.size() > 0) {
            ar = addrRanges.toArray(new IModules.AddressRange[addrRanges.size()]);
            rm.setData((Object)ar);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, MessageFormat.format("Fail to find address for source line {0}: line# {1}", new Object[]{file, line}), null));
        }
        rm.done();
    }

    public void calcLineInfo(IModules.ISymbolDMContext symCtx, IAddress address, DataRequestMonitor<IModules.LineInfo[]> rm) {
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void findClosestLineWithCode(IModules.ISymbolDMContext symCtx, String file, int anchor, int neighbor_limit, DataRequestMonitor<ILineEntryProvider.ILineAddresses> rm) {
        moduleList = null;
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("Find closest line with code. context: " + EDCTrace.fixArg(symCtx) + " file: " + file + " anchor: " + anchor + " limit: " + neighbor_limit));
        }
        if (symCtx instanceof IEDCExecutionDMC) {
            symContextID = ((IEDCDMContext)symCtx).getID();
            moduleList = this.getModulesForContext(symContextID);
        } else if (symCtx instanceof IModules.IModuleDMContext) {
            moduleList = new IModules.IModuleDMContext[]{(IModules.IModuleDMContext)symCtx};
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, MessageFormat.format("Unknown class implementing ISymbolDMContext : {0}", new Object[]{symCtx.getClass().getName()}), null));
            rm.done();
            if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)rm.getStatus());
            }
            return;
        }
        result = null;
        var11_8 = moduleList;
        var10_9 = moduleList.length;
        var9_10 = 0;
        while (var9_10 < var10_9) {
            block23: {
                block24: {
                    module = var11_8[var9_10];
                    mdmc = (ModuleDMC)module;
                    reader = mdmc.getSymbolReader();
                    if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                        EDCTrace.getTrace().trace(null, "module: " + mdmc + " reader: " + reader);
                    }
                    if (reader == null) break block23;
                    codeLines = null;
                    cache = new HashMap<K, V>();
                    cacheKey = String.valueOf(reader.getSymbolFile().toOSString()) + "_line_addresses";
                    noFileCacheKey = String.valueOf(reader.getSymbolFile().toOSString()) + "_no_file";
                    noFileCachedData = EDCDebugger.getDefault().getCache().getCachedData(noFileCacheKey, Set.class, reader.getModificationDate());
                    if (noFileCachedData == null || !noFileCachedData.contains(file)) break block24;
                    if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                        EDCTrace.getTrace().trace(null, "Persistent cache says file not used by module");
                    }
                    break block23;
                }
                cachedData = EDCDebugger.getDefault().getCache().getCachedData(cacheKey, Map.class, reader.getModificationDate());
                if (cachedData != null) {
                    cache = cachedData;
                    codeLines = (List)cachedData.get(String.valueOf(file) + anchor);
                }
                if (codeLines != null) ** GOTO lbl61
                if (!reader.getModuleScope().getModuleLineEntryProvider().hasSourceFile(PathUtils.createPath(file))) {
                    if (noFileCachedData == null) {
                        noFileCachedData = new HashSet<String>();
                    }
                    noFileCachedData.add(file);
                    EDCDebugger.getDefault().getCache().putCachedData(noFileCacheKey, noFileCachedData, reader.getModificationDate());
                    if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                        EDCTrace.getTrace().trace(null, "File not used by module");
                    }
                } else {
                    codeLines = reader.getModuleScope().getModuleLineEntryProvider().findClosestLineWithCode(PathUtils.createPath(file), anchor, neighbor_limit);
                    if (codeLines == null) {
                        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                            EDCTrace.getTrace().trace(null, "codeLines == null");
                        }
                    } else {
                        cache.put(String.valueOf(file) + anchor, codeLines);
                        EDCDebugger.getDefault().getCache().putCachedData(cacheKey, (Serializable)cache, reader.getModificationDate());
                        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                            EDCTrace.getTrace().trace(null, "codeLines: " + codeLines);
                        }
lbl61:
                        // 4 sources

                        runtimeCLs = new ArrayList<EDCLineAddresses>(codeLines.size());
                        for (ILineEntryProvider.ILineAddresses cl : codeLines) {
                            rt_addrs = new ArrayList<IAddress>(1);
                            var27_27 = cl.getAddress();
                            var26_26 = var27_27.length;
                            var25_25 = 0;
                            while (var25_25 < var26_26) {
                                a = var27_27[var25_25];
                                rt_addrs.add(mdmc.toRuntimeAddress(a));
                                ++var25_25;
                            }
                            runtimeCLs.add(new EDCLineAddresses(cl.getLineNumber(), rt_addrs));
                        }
                        for (ILineEntryProvider.ILineAddresses l : runtimeCLs) {
                            result = this.selectCodeLine(result, l, anchor);
                        }
                    }
                }
            }
            ++var9_10;
        }
        if (result != null) {
            rm.setData(result);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, MessageFormat.format("Fail to find address sround source line {0}: line# {1}", new Object[]{file, anchor}), null));
        }
        rm.done();
    }

    private EDCLineAddresses selectCodeLine(EDCLineAddresses prevChoice, ILineEntryProvider.ILineAddresses newLine, int anchor) {
        if (prevChoice == null) {
            prevChoice = (EDCLineAddresses)newLine;
        } else if (newLine.getLineNumber() == prevChoice.getLineNumber()) {
            prevChoice.addAddress(newLine.getAddress());
        } else if (newLine.getLineNumber() == anchor) {
            prevChoice = (EDCLineAddresses)newLine;
        } else if (prevChoice.getLineNumber() != anchor) {
            int prev_distance;
            int new_distance = Math.abs(newLine.getLineNumber() - anchor);
            if (new_distance < (prev_distance = Math.abs(prevChoice.getLineNumber() - anchor))) {
                prevChoice = (EDCLineAddresses)newLine;
            } else if (new_distance == prev_distance && newLine.getLineNumber() > prevChoice.getLineNumber()) {
                prevChoice = (EDCLineAddresses)newLine;
            }
        }
        return prevChoice;
    }

    public void getLineAddress(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, final DataRequestMonitor<List<IAddress>> drm) {
        final ArrayList addrs = new ArrayList(1);
        RunControl.ExecutionDMC dmc = (RunControl.ExecutionDMC)context;
        if (dmc == null) {
            drm.setData(addrs);
            drm.done();
            return;
        }
        IModules.ISymbolDMContext symCtx = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class);
        sourceFile = EDCLaunch.getLaunchForSession(this.getSession().getId()).getCompilationPath(sourceFile);
        this.calcAddressInfo(symCtx, sourceFile, lineNumber, 0, new DataRequestMonitor<IModules.AddressRange[]>((Executor)this.getExecutor(), drm){

            protected void handleCompleted() {
                IModules.AddressRange[] addr_ranges;
                if (!this.isSuccess()) {
                    drm.setStatus(this.getStatus());
                    drm.done();
                    return;
                }
                IModules.AddressRange[] addressRangeArray = addr_ranges = (IModules.AddressRange[])this.getData();
                int n = addr_ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    IModules.AddressRange range = addressRangeArray[n2];
                    IAddress a = range.getStartAddress();
                    addrs.add(a);
                    ++n2;
                }
                drm.setData((Object)addrs);
                drm.done();
            }
        });
    }

    public void getModuleData(IModules.IModuleDMContext dmc, DataRequestMonitor<IModules.IModuleDMData> rm) {
        rm.setData((Object)new ModuleDMData((ModuleDMC)dmc));
        rm.done();
    }

    public void getModules(IModules.ISymbolDMContext symCtx, DataRequestMonitor<IModules.IModuleDMContext[]> rm) {
        String symContextID = ((IEDCDMContext)symCtx).getID();
        IModules.IModuleDMContext[] moduleList = this.getModulesForContext(symContextID);
        rm.setData((Object)moduleList);
        rm.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModules.IModuleDMContext[] getModulesForContext(String symContextID) {
        Map<String, List<ModuleDMC>> map = this.modules;
        synchronized (map) {
            List<ModuleDMC> moduleList = this.modules.get(symContextID);
            if (moduleList == null) {
                return new IModules.IModuleDMContext[0];
            }
            return moduleList.toArray(new IModules.IModuleDMContext[moduleList.size()]);
        }
    }

    private int getNextModuleID() {
        return nextModuleID++;
    }

    public void moduleLoaded(IModules.ISymbolDMContext symbolContext, IRunControl.IExecutionDMContext executionDMC, Map<String, Object> moduleProps) {
        ModuleDMC module = new ModuleDMC(symbolContext, moduleProps);
        module.relocateSections(moduleProps);
        this.addModule(module);
        this.getSession().dispatchEvent((Object)new ModuleLoadedEvent(symbolContext, executionDMC, module), this.getProperties());
    }

    public void moduleUnloaded(IModules.ISymbolDMContext symbolContext, IRunControl.IExecutionDMContext executionDMC, Map<String, Object> moduleProps) {
        Object fileName = moduleProps.get("Name");
        ModuleDMC module = this.getModuleByName(symbolContext, fileName);
        if (module == null) {
            EDCDebugger.getMessageLogger().logError("Unexpected unload of module: " + fileName, null);
            return;
        }
        Object requireResumeValue = moduleProps.get("RequireResume");
        if (requireResumeValue != null && requireResumeValue instanceof Boolean) {
            module.setProperty("RequireResume", requireResumeValue);
        }
        this.removeModule(module);
        this.getSession().dispatchEvent((Object)new ModuleUnloadedEvent(symbolContext, executionDMC, module), this.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleDMC getModuleByAddress(IModules.ISymbolDMContext symCtx, IAddress instructionAddress) {
        ModuleDMC bestMatch = null;
        if (symCtx instanceof ModuleDMC) {
            if (((ModuleDMC)symCtx).containsAddress(instructionAddress)) {
                bestMatch = (ModuleDMC)symCtx;
            }
        } else {
            Map<String, List<ModuleDMC>> map = this.modules;
            synchronized (map) {
                List<ModuleDMC> moduleList = this.modules.get(((IEDCDMContext)symCtx).getID());
                if (moduleList != null) {
                    for (ModuleDMC moduleDMC : moduleList) {
                        if (!moduleDMC.containsAddress(instructionAddress)) continue;
                        bestMatch = moduleDMC;
                        break;
                    }
                }
            }
        }
        return bestMatch;
    }

    public IPath locateModuleFileOnHost(String originalPath) {
        if (originalPath == null || originalPath.length() == 0) {
            return Path.EMPTY;
        }
        IPath path = PathUtils.findExistingPathIfCaseSensitive(PathUtils.createPath(originalPath));
        Object sourceElement = null;
        ISourceLocator locator = this.getSourceLocator();
        if (locator != null) {
            if (locator instanceof ICSourceLocator || locator instanceof CSourceLookupDirector) {
                sourceElement = locator instanceof ICSourceLocator ? ((ICSourceLocator)locator).findSourceElement(path.toOSString()) : ((CSourceLookupDirector)locator).getSourceElement((Object)path.toOSString());
            }
            if (sourceElement != null && sourceElement instanceof LocalFileStorage) {
                return new Path(((LocalFileStorage)sourceElement).getFile().getAbsolutePath());
            }
        }
        return path;
    }

    public void loadModulesForContext(IModules.ISymbolDMContext context, Element element) throws Exception {
        List<ModuleDMC> contextModules = Collections.synchronizedList(new ArrayList());
        NodeList moduleElements = element.getElementsByTagName(MODULE);
        int numModules = moduleElements.getLength();
        int i = 0;
        while (i < numModules) {
            Element moduleElement = (Element)moduleElements.item(i);
            Element propElement = (Element)moduleElement.getElementsByTagName("properties").item(0);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            SnapshotUtils.initializeFromXML(propElement, properties);
            ModuleDMC module = new ModuleDMC(context, properties);
            module.loadSnapshot(moduleElement);
            contextModules.add(module);
            ++i;
        }
        this.modules.put(((IEDCDMContext)context).getID(), contextModules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDMC getModuleByName(IModules.ISymbolDMContext symCtx, Object fileName) {
        ModuleDMC module = null;
        Map<String, List<ModuleDMC>> map = this.modules;
        synchronized (map) {
            List<ModuleDMC> moduleList = this.modules.get(((IEDCDMContext)symCtx).getID());
            if (moduleList != null) {
                for (ModuleDMC moduleDMC : moduleList) {
                    if (moduleDMC.getName().compareToIgnoreCase((String)fileName) != 0) continue;
                    module = moduleDMC;
                    break;
                }
            }
        }
        return module;
    }

    public static class EDCAddressRange
    implements IModules.AddressRange,
    Serializable {
        private static final long serialVersionUID = -6475152211053407789L;
        private IAddress startAddr;
        private IAddress endAddr;

        public EDCAddressRange(IAddress start, IAddress end) {
            this.startAddr = start;
            this.endAddr = end;
        }

        public IAddress getEndAddress() {
            return this.endAddr;
        }

        public void setEndAddress(IAddress address) {
            this.endAddr = address;
        }

        public IAddress getStartAddress() {
            return this.startAddr;
        }

        public void setStartAddress(IAddress address) {
            this.startAddr = address;
        }

        public String toString() {
            return MessageFormat.format("[{0},{1})", this.startAddr.toHexAddressString(), this.endAddr.toHexAddressString());
        }

        public boolean contains(IAddress address) {
            return this.getStartAddress().compareTo((Object)address) <= 0 && this.getEndAddress().compareTo((Object)address) > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EDCLineAddresses
    implements ILineEntryProvider.ILineAddresses,
    Serializable {
        private static final long serialVersionUID = 3263812332106024057L;
        private int lineNumber;
        private List<IAddress> addresses;

        public EDCLineAddresses(int lineNumber, IAddress addr) {
            this.lineNumber = lineNumber;
            this.addresses = new ArrayList<IAddress>();
            this.addresses.add(addr);
        }

        public EDCLineAddresses(int lineNumber, List<IAddress> addrs) {
            this.lineNumber = lineNumber;
            this.addresses = new ArrayList<IAddress>(addrs);
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public IAddress[] getAddress() {
            return this.addresses.toArray(new IAddress[this.addresses.size()]);
        }

        public void addAddress(List<IAddress> addrs) {
            this.addresses.addAll(addrs);
        }

        public void addAddress(IAddress[] addrs) {
            IAddress[] iAddressArray = addrs;
            int n = addrs.length;
            int n2 = 0;
            while (n2 < n) {
                IAddress a = iAddressArray[n2];
                this.addresses.add(a);
                ++n2;
            }
        }

        public String toString() {
            String addrs = "";
            for (IAddress a : this.addresses) {
                addrs = String.valueOf(addrs) + a.toHexAddressString() + " ";
            }
            return "EDCLineAddresses [lineNumber=" + this.lineNumber + ", addresses=(" + addrs + ")]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ModuleDMC
    extends DMContext
    implements IEDCModuleDMContext,
    ISnapshotContributor,
    IBreakpoints.IBreakpointsTargetDMContext,
    IModules.ISymbolDMContext {
        private final IModules.ISymbolDMContext symbolContext;
        private final IPath hostFilePath;
        private IEDCSymbolReader symReader;
        private final List<IRuntimeSection> runtimeSections;

        public ModuleDMC(IModules.ISymbolDMContext symbolContext, Map<String, Object> props) {
            IDMContext[] iDMContextArray;
            if (symbolContext == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = symbolContext;
            }
            super((IDsfService)Modules.this, iDMContextArray, Integer.toString(Modules.this.getNextModuleID()), props);
            this.runtimeSections = new ArrayList<IRuntimeSection>();
            this.symbolContext = symbolContext;
            String filename = "";
            if (props.containsKey("File")) {
                filename = (String)props.get("File");
            }
            this.hostFilePath = Modules.this.locateModuleFileOnHost(filename);
        }

        public IModules.ISymbolDMContext getSymbolContext() {
            return this.symbolContext;
        }

        @Override
        public IEDCSymbolReader getSymbolReader() {
            return this.symReader;
        }

        @Override
        public void loadSnapshot(Element element) throws Exception {
            NodeList sectionElements = element.getElementsByTagName(Modules.SECTION);
            int numSections = sectionElements.getLength();
            int i = 0;
            while (i < numSections) {
                Element sectionElement = (Element)sectionElements.item(i);
                Element propElement = (Element)sectionElement.getElementsByTagName("properties").item(0);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                SnapshotUtils.initializeFromXML(propElement, properties);
                Addr64 linkAddress = new Addr64(sectionElement.getAttribute("link_address"));
                int sectionID = Integer.parseInt(sectionElement.getAttribute("id"));
                long size = Long.parseLong(sectionElement.getAttribute("size"));
                RuntimeSection section = new RuntimeSection(new Section(sectionID, size, (IAddress)linkAddress, properties));
                section.relocate((IAddress)new Addr64(sectionElement.getAttribute("runtime_address")));
                this.runtimeSections.add(section);
                ++i;
            }
            this.initializeSymbolReader();
        }

        @Override
        public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.runtimeSections.size() + 1));
            progress.subTask("Modules");
            Element contextElement = document.createElement(Modules.MODULE);
            contextElement.setAttribute("ID", this.getID());
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            contextElement.appendChild(propsElement);
            for (IRuntimeSection s : this.runtimeSections) {
                Element sectionElement = document.createElement(Modules.SECTION);
                sectionElement.setAttribute("id", Integer.toString(s.getId()));
                sectionElement.setAttribute("size", Long.toString(s.getSize()));
                sectionElement.setAttribute("link_address", s.getLinkAddress().toHexAddressString());
                sectionElement.setAttribute("runtime_address", s.getRuntimeAddress().toHexAddressString());
                propsElement = SnapshotUtils.makeXMLFromProperties(document, s.getProperties());
                sectionElement.appendChild(propsElement);
                contextElement.appendChild(sectionElement);
                progress.worked(1);
            }
            if (!this.hostFilePath.isEmpty()) {
                album.addFile(this.hostFilePath);
                IPath possibleSymFile = ExecutableSymbolicsReaderFactory.findSymbolicsFile(this.hostFilePath);
                if (possibleSymFile != null) {
                    album.addFile(possibleSymFile);
                }
            }
            progress.worked(1);
            return contextElement;
        }

        public void relocateSections(Map<String, Object> props) {
            this.initializeSymbolReader();
            if (this.symReader != null) {
                for (ISection section : this.symReader.getSections()) {
                    this.runtimeSections.add(new RuntimeSection(section));
                }
            }
            if (props.containsKey("ImageBaseAddress")) {
                Object base = props.get("ImageBaseAddress");
                Addr64 imageBaseAddr = null;
                if (base != null) {
                    if (base instanceof Integer) {
                        imageBaseAddr = new Addr64(base.toString());
                    } else if (base instanceof Long) {
                        imageBaseAddr = new Addr64(base.toString());
                    } else if (base instanceof String) {
                        imageBaseAddr = new Addr64((String)base, 16);
                    } else {
                        EDCDebugger.getMessageLogger().logError(MessageFormat.format("Module property PROP_ADDRESS has invalid format {0}.", base.getClass()), null);
                    }
                }
                Number size = 0;
                if (props.containsKey("CodeSize")) {
                    size = (Number)props.get("CodeSize");
                }
                if (this.symReader != null) {
                    IAddress linkBase = this.symReader.getBaseLinkAddress();
                    if (linkBase != null && !linkBase.equals((Object)imageBaseAddr)) {
                        BigInteger offset = linkBase.distanceTo((IAddress)imageBaseAddr);
                        for (IRuntimeSection s : this.runtimeSections) {
                            IAddress runtimeB = s.getLinkAddress().add(offset);
                            s.relocate(runtimeB);
                        }
                    }
                } else {
                    HashMap<String, Object> pp = new HashMap<String, Object>();
                    pp.put("name", ".text");
                    this.runtimeSections.add(new RuntimeSection(new Section(0, size.longValue(), (IAddress)imageBaseAddr, pp)));
                }
            } else if (props.containsKey("CodeAddress")) {
                Number codeAddr = null;
                Number dataAddr = null;
                Number bssAddr = null;
                Number codeSize = null;
                Number dataSize = null;
                Number bssSize = null;
                try {
                    codeAddr = (Number)props.get("CodeAddress");
                    dataAddr = (Number)props.get("DataAddress");
                    bssAddr = (Number)props.get("BssAddress");
                    codeSize = (Number)props.get("CodeSize");
                    dataSize = (Number)props.get("DataSize");
                    bssSize = (Number)props.get("BssSize");
                }
                catch (ClassCastException classCastException) {
                    EDCDebugger.getMessageLogger().logError("Module property value has invalid format.", null);
                }
                if (this.symReader != null) {
                    for (IRuntimeSection s : this.runtimeSections) {
                        if (s.getProperties().get("name").equals(".text") && codeAddr != null) {
                            s.relocate((IAddress)new Addr64(codeAddr.toString()));
                            continue;
                        }
                        if (s.getProperties().get("name").equals(".data") && dataAddr != null) {
                            s.relocate((IAddress)new Addr64(dataAddr.toString()));
                            continue;
                        }
                        if (!s.getProperties().get("name").equals(".bss") || bssAddr == null) continue;
                        s.relocate((IAddress)new Addr64(bssAddr.toString()));
                    }
                } else {
                    HashMap<String, Object> pp = new HashMap<String, Object>();
                    if (codeAddr != null && codeSize != null) {
                        pp.put("name", ".text");
                        this.runtimeSections.add(new RuntimeSection(new Section(0, codeSize.intValue(), (IAddress)new Addr64(codeAddr.toString()), pp)));
                    }
                    if (dataAddr != null && dataSize != null) {
                        pp.clear();
                        pp.put("name", ".data");
                        this.runtimeSections.add(new RuntimeSection(new Section(0, dataSize.intValue(), (IAddress)new Addr64(dataAddr.toString()), pp)));
                    }
                    if (bssAddr != null && bssSize != null) {
                        pp.clear();
                        pp.put("name", ".bss");
                        this.runtimeSections.add(new RuntimeSection(new Section(0, bssSize.intValue(), (IAddress)new Addr64(bssAddr.toString()), pp)));
                    }
                }
            }
        }

        private void initializeSymbolReader() {
            if (this.hostFilePath.toFile().exists()) {
                this.symReader = Symbols.getSymbolReader(this.hostFilePath);
                if (this.symReader == null) {
                    EDCDebugger.getMessageLogger().log(2, MessageFormat.format("''{0}'' has no recognized file format.", this.hostFilePath), null);
                } else if (!this.symReader.hasRecognizedDebugInformation()) {
                    EDCDebugger.getMessageLogger().log(1, MessageFormat.format("''{0}'' has no recognized symbolics.", this.hostFilePath), null);
                }
            } else {
                EDCDebugger.getMessageLogger().log(2, MessageFormat.format("Cannot debug ''{0}''; no match found on disk, through source lookup, or in Executables view", this.hostFilePath), null);
            }
        }

        public boolean containsAddress(IAddress runtimeAddress) {
            for (IRuntimeSection s : this.runtimeSections) {
                long offset = s.getRuntimeAddress().distanceTo(runtimeAddress).longValue();
                if (offset < 0L || offset >= s.getSize()) continue;
                return true;
            }
            return false;
        }

        @Override
        public IAddress toLinkAddress(IAddress runtimeAddress) {
            IAddress ret = null;
            for (IRuntimeSection s : this.runtimeSections) {
                long offset = s.getRuntimeAddress().distanceTo(runtimeAddress).longValue();
                if (offset < 0L || offset >= s.getSize()) continue;
                return s.getLinkAddress().add(offset);
            }
            return ret;
        }

        @Override
        public IAddress toRuntimeAddress(IAddress linkAddress) {
            IAddress ret = null;
            for (IRuntimeSection s : this.runtimeSections) {
                long offset = s.getLinkAddress().distanceTo(linkAddress).longValue();
                if (offset < 0L || offset >= s.getSize()) continue;
                return s.getRuntimeAddress().add(offset);
            }
            return ret;
        }

        public String getFile() {
            return this.hostFilePath.lastSegment();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\nModuleDMC [");
            if (this.hostFilePath != null) {
                builder.append("file=");
                builder.append(this.hostFilePath.lastSegment());
                builder.append(", ");
            }
            if (this.symbolContext != null) {
                builder.append("owner=");
                builder.append(this.symbolContext.toString());
            }
            for (IRuntimeSection s : this.runtimeSections) {
                builder.append("\n");
                builder.append(s);
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.hostFilePath == null ? 0 : this.hostFilePath.hashCode());
            result = 31 * result + (this.symbolContext == null ? 0 : this.symbolContext.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleDMC other = (ModuleDMC)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.hostFilePath == null ? other.hostFilePath != null : !this.hostFilePath.equals((Object)other.hostFilePath)) {
                return false;
            }
            return !(this.symbolContext == null ? other.symbolContext != null : !this.symbolContext.equals(other.symbolContext));
        }

        private IEDCModules getOuterType() {
            return Modules.this;
        }
    }

    static class ModuleDMData
    implements IModules.IModuleDMData {
        private final Map<String, Object> properties;

        public ModuleDMData(ModuleDMC dmc) {
            this.properties = dmc.getProperties();
        }

        public String getFile() {
            return (String)this.properties.get("File");
        }

        public String getName() {
            return (String)this.properties.get("Name");
        }

        public long getTimeStamp() {
            return 0L;
        }

        public String getBaseAddress() {
            Object baseAddress = this.properties.get("ImageBaseAddress");
            if (baseAddress == null) {
                baseAddress = this.properties.get("CodeAddress");
            }
            if (baseAddress != null) {
                return baseAddress.toString();
            }
            return "";
        }

        public String getToAddress() {
            return this.getBaseAddress();
        }

        public boolean isSymbolsLoaded() {
            return false;
        }

        public long getSize() {
            Number moduleSize = (Number)this.properties.get("CodeSize");
            if (moduleSize != null) {
                return moduleSize.longValue();
            }
            return 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleLoadedEvent
    extends AbstractDMEvent<IModules.ISymbolDMContext>
    implements IModules.ModuleLoadedDMEvent {
        private final ModuleDMC module;
        private final IRunControl.IExecutionDMContext executionDMC;

        public ModuleLoadedEvent(IModules.ISymbolDMContext symbolContext, IRunControl.IExecutionDMContext executionDMC, ModuleDMC module) {
            super((IDMContext)symbolContext);
            this.module = module;
            this.executionDMC = executionDMC;
        }

        public IRunControl.IExecutionDMContext getExecutionDMC() {
            return this.executionDMC;
        }

        public IModules.IModuleDMContext getLoadedModuleContext() {
            return this.module;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleUnloadedEvent
    extends AbstractDMEvent<IModules.ISymbolDMContext>
    implements IModules.ModuleUnloadedDMEvent {
        private final ModuleDMC module;
        private final IRunControl.IExecutionDMContext executionDMC;

        public ModuleUnloadedEvent(IModules.ISymbolDMContext symbolContext, IRunControl.IExecutionDMContext executionDMC, ModuleDMC module) {
            super((IDMContext)symbolContext);
            this.module = module;
            this.executionDMC = executionDMC;
        }

        public IRunControl.IExecutionDMContext getExecutionDMC() {
            return this.executionDMC;
        }

        public IModules.IModuleDMContext getUnloadedModuleContext() {
            return this.module;
        }
    }
}

