/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.EDCSymbolReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.DebugInfoProviderFactory;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ExecutableSymbolicsReaderFactory;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.services.IFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.ISymbol;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.ISymbols;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.ISourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symbols
extends AbstractEDCService
implements ISymbols,
IEDCSymbols {
    private static Map<IPath, WeakReference<IEDCSymbolReader>> readerCache = new HashMap<IPath, WeakReference<IEDCSymbolReader>>();
    private ISourceLocator sourceLocator;

    public ISourceLocator getSourceLocator() {
        return this.sourceLocator;
    }

    public void setSourceLocator(ISourceLocator sourceLocator) {
        this.sourceLocator = sourceLocator;
    }

    public Symbols(DsfSession session) {
        super(session, new String[]{IEDCSymbols.class.getName(), ISymbols.class.getName(), Symbols.class.getName()});
    }

    public void getSymbols(IModules.ISymbolDMContext symCtx, DataRequestMonitor<Iterable<ISymbols.ISymbolObjectDMContext>> rm) {
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
    }

    @Override
    public IFunctionScope getFunctionAtAddress(IModules.ISymbolDMContext context, IAddress runtimeAddress) {
        IEDCSymbolReader reader;
        IEDCModules modulesService = this.getService(Modules.class);
        IEDCModuleDMContext module = modulesService.getModuleByAddress(context, runtimeAddress);
        if (module != null && (reader = module.getSymbolReader()) != null) {
            IScope scope = reader.getModuleScope().getScopeAtAddress(module.toLinkAddress(runtimeAddress));
            while (scope != null && !(scope instanceof IFunctionScope)) {
                scope = scope.getParent();
            }
            return (IFunctionScope)scope;
        }
        return null;
    }

    @Override
    public String getSymbolNameAtAddress(IModules.ISymbolDMContext context, IAddress runtimeAddress) {
        ISymbol symbol;
        IEDCSymbolReader reader;
        IEDCModules modulesService = this.getService(Modules.class);
        IEDCModuleDMContext module = modulesService.getModuleByAddress(context, runtimeAddress);
        if (module != null && (reader = module.getSymbolReader()) != null && (symbol = reader.getSymbolAtAddress(module.toLinkAddress(runtimeAddress))) != null) {
            return symbol.getName();
        }
        return null;
    }

    @Override
    public ILineEntry getLineEntryForAddress(IModules.ISymbolDMContext context, IAddress runtimeAddress) {
        IEDCSymbolReader reader;
        IEDCModules modulesService = this.getService(Modules.class);
        IEDCModuleDMContext module = modulesService.getModuleByAddress(context, runtimeAddress);
        if (module != null && (reader = module.getSymbolReader()) != null) {
            IAddress linkAddress = module.toLinkAddress(runtimeAddress);
            IModuleLineEntryProvider lineEntryProvider = reader.getModuleScope().getModuleLineEntryProvider();
            return lineEntryProvider.getLineEntryAtAddress(linkAddress);
        }
        return null;
    }

    @Override
    public List<ILineEntry> getLineEntriesForAddressRange(IModules.ISymbolDMContext context, IAddress start, IAddress end) {
        ArrayList<ILineEntry> lineEntries = new ArrayList<ILineEntry>();
        IEDCModules modulesService = this.getService(Modules.class);
        IEDCModuleDMContext module = modulesService.getModuleByAddress(context, start);
        if (module == null) {
            return lineEntries;
        }
        IAddress linkStartAddress = module.toLinkAddress(start);
        IAddress linkEndAddress = module.toLinkAddress(end);
        IEDCSymbolReader reader = module.getSymbolReader();
        if (reader != null) {
            IModuleScope moduleScope;
            if (linkStartAddress == null) {
                linkStartAddress = module.getSymbolReader().getModuleScope().getLowAddress();
            }
            if (linkEndAddress == null) {
                linkEndAddress = module.getSymbolReader().getModuleScope().getHighAddress();
            }
            if (linkEndAddress.compareTo((Object)(moduleScope = reader.getModuleScope()).getHighAddress()) > 0) {
                linkEndAddress = moduleScope.getHighAddress();
            }
            IModuleLineEntryProvider lineEntryProvider = moduleScope.getModuleLineEntryProvider();
            ILineEntry entry = lineEntryProvider.getLineEntryAtAddress(linkStartAddress);
            while (entry != null && entry.getLowAddress().compareTo((Object)linkEndAddress) < 0) {
                lineEntries.add(entry);
                entry = entry.getLowAddress().compareTo((Object)entry.getHighAddress()) >= 0 ? lineEntryProvider.getLineEntryAtAddress(entry.getHighAddress().add(1L)) : lineEntryProvider.getLineEntryAtAddress(entry.getHighAddress());
            }
        }
        return lineEntries;
    }

    public IFrameRegisterProvider getFrameRegisterProvider(IModules.ISymbolDMContext context, IAddress runtimeAddress) {
        IEDCSymbolReader reader;
        Modules modulesService = this.getService(Modules.class);
        Modules.ModuleDMC module = modulesService.getModuleByAddress(context, runtimeAddress);
        if (module != null && (reader = module.getSymbolReader()) != null) {
            IFrameRegisterProvider frameRegisterProvider = reader.getModuleScope().getFrameRegisterProvider();
            return frameRegisterProvider;
        }
        return null;
    }

    public static IEDCSymbolReader getSymbolReader(IPath modulePath) {
        IExecutableSymbolicsReader exeReader;
        IEDCSymbolReader reader = null;
        WeakReference<IEDCSymbolReader> cacheEntry = readerCache.get(modulePath);
        if (cacheEntry != null) {
            reader = (IEDCSymbolReader)cacheEntry.get();
        }
        if (reader != null) {
            if (reader.getSymbolFile() != null && reader.getSymbolFile().toFile().exists() && reader.getSymbolFile().toFile().lastModified() == reader.getModificationDate()) {
                return reader;
            }
            readerCache.remove(modulePath);
        }
        if ((exeReader = ExecutableSymbolicsReaderFactory.createFor(modulePath)) != null) {
            IDebugInfoProvider debugProvider = DebugInfoProviderFactory.createFor(modulePath, exeReader);
            if (debugProvider != null && !exeReader.getSymbolFile().equals((Object)debugProvider.getExecutableSymbolicsReader().getSymbolFile())) {
                exeReader.dispose();
                exeReader = debugProvider.getExecutableSymbolicsReader();
            }
            reader = new EDCSymbolReader(exeReader, debugProvider);
        }
        if (reader != null) {
            readerCache.put(modulePath, new WeakReference<IEDCSymbolReader>(reader));
        }
        return reader;
    }

    @Override
    public void shutdown(RequestMonitor rm) {
        super.shutdown(rm);
    }

    public static void releaseReaderCache() {
        Collection<WeakReference<IEDCSymbolReader>> readers = readerCache.values();
        for (WeakReference<IEDCSymbolReader> readerRef : readers) {
            IEDCSymbolReader reader = (IEDCSymbolReader)readerRef.get();
            if (reader == null) continue;
            reader.shutDown();
        }
        readerCache.clear();
    }

    public List<IAddress> getFunctionAddress(IEDCModuleDMContext module, String functionName) {
        Collection<ISymbol> symbols;
        ArrayList<IAddress> ret = new ArrayList<IAddress>(2);
        IEDCSymbolReader symReader = module.getSymbolReader();
        if (symReader == null) {
            return ret;
        }
        int parenIndex = functionName.indexOf(40);
        if (parenIndex >= 0) {
            functionName = functionName.substring(0, parenIndex);
        }
        if ((symbols = symReader.findUnmangledSymbols(functionName)).isEmpty()) {
            symbols = symReader.findSymbols(functionName);
        }
        for (ISymbol symbol : symbols) {
            if (symbol.getSize() == 0L) continue;
            IAddress addr = symbol.getAddress();
            addr = module.toRuntimeAddress(addr);
            ret.add(addr);
        }
        return ret;
    }
}

