/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import org.eclipse.cdt.debug.edc.internal.symbols.IArrayBoundType;
import org.eclipse.cdt.debug.edc.internal.symbols.Type;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;

public class ArrayBoundType
extends Type
implements IArrayBoundType {
    private final long bound;
    private long elements;
    private long dimensionIndex = 0L;

    public ArrayBoundType(IScope scope, long arrayBound) {
        super("", scope, 0, null);
        if (arrayBound < 1L) {
            this.bound = 0L;
            this.elements = 0L;
        } else {
            this.bound = arrayBound;
            this.elements = 1L;
        }
    }

    public long getBoundCount() {
        return this.bound;
    }

    public long getElementCount() {
        return this.elements;
    }

    public long getDimensionIndex() {
        return this.dimensionIndex;
    }

    public void multiplyElementCount(long multiply) {
        this.elements *= multiply;
    }

    public void incDimensionIndex() {
        ++this.dimensionIndex;
    }

    public IType getType() {
        return null;
    }
}

