/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.edc.internal.symbols.FieldType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IField;
import org.eclipse.cdt.debug.edc.internal.symbols.IInheritance;
import org.eclipse.cdt.debug.edc.internal.symbols.ITemplateParam;
import org.eclipse.cdt.debug.edc.internal.symbols.MayBeQualifiedType;
import org.eclipse.cdt.debug.edc.symbols.IScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeType
extends MayBeQualifiedType
implements ICompositeType {
    private final int key;
    private String baseName;
    protected ArrayList<IField> fields = new ArrayList();
    protected ArrayList<IInheritance> inheritances = null;
    protected ArrayList<ITemplateParam> templateParams = null;
    boolean nameIncludesTemplateParams;
    protected ArrayList<IField> unknownOffsetFields = null;

    public CompositeType(String name, IScope scope, int key, int byteSize, Map<Object, Object> properties, String prefix) {
        super(name, scope, byteSize, properties);
        this.baseName = name;
        this.name = String.valueOf(prefix) + " " + name;
        this.key = key;
        this.nameIncludesTemplateParams = name.contains("<");
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public int fieldCount() {
        if (this.unknownOffsetFields != null) {
            this.setAnonymousUnionOffsets();
        }
        return this.fields.size();
    }

    @Override
    public void addField(IField field) {
        if (field.getFieldOffset() < 0L) {
            if (this.unknownOffsetFields == null) {
                this.unknownOffsetFields = new ArrayList();
            }
            this.unknownOffsetFields.add(field);
        } else {
            this.fields.add(field);
        }
    }

    @Override
    public IField[] getFields() {
        if (this.unknownOffsetFields != null) {
            this.setAnonymousUnionOffsets();
        }
        ArrayList<IField> fieldList = new ArrayList<IField>(this.fields);
        return fieldList.toArray(new IField[this.fields.size()]);
    }

    @Override
    public void addTemplateParam(ITemplateParam templateParam) {
        if (this.templateParams == null) {
            this.templateParams = new ArrayList(2);
        }
        this.templateParams.add(templateParam);
    }

    @Override
    public ITemplateParam[] getTemplateParams() {
        if (this.templateParams == null) {
            return new ITemplateParam[0];
        }
        ArrayList<ITemplateParam> templateParamList = new ArrayList<ITemplateParam>(this.templateParams);
        return templateParamList.toArray(new ITemplateParam[this.templateParams.size()]);
    }

    @Override
    public String getName() {
        if (this.templateParams != null && !this.nameIncludesTemplateParams) {
            this.addTemplateStringToNames();
        }
        return this.name;
    }

    @Override
    public String getBaseName() {
        if (this.templateParams != null && !this.nameIncludesTemplateParams) {
            this.addTemplateStringToNames();
        }
        return this.baseName;
    }

    private void addTemplateStringToNames() {
        this.nameIncludesTemplateParams = true;
        String templateName = "<";
        int i = 0;
        while (i < this.templateParams.size()) {
            templateName = String.valueOf(templateName) + this.templateParams.get(i).getName();
            if (i + 1 < this.templateParams.size()) {
                templateName = String.valueOf(templateName) + ",";
            }
            ++i;
        }
        templateName = String.valueOf(templateName) + ">";
        templateName = templateName.replaceAll("class ", "");
        templateName = templateName.replaceAll("struct ", "");
        templateName = templateName.replaceAll("union ", "");
        this.name = String.valueOf(this.name) + templateName;
        this.baseName = String.valueOf(this.baseName) + templateName;
    }

    @Override
    public int inheritanceCount() {
        return this.inheritances == null ? 0 : this.inheritances.size();
    }

    @Override
    public void addInheritance(IInheritance inheritance) {
        if (this.inheritances == null) {
            this.inheritances = new ArrayList();
        }
        this.inheritances.add(inheritance);
    }

    @Override
    public IInheritance[] getInheritances() {
        if (this.inheritances == null) {
            return new IInheritance[0];
        }
        return this.inheritances.toArray(new IInheritance[this.inheritances.size()]);
    }

    @Override
    public IField[] findFields(String name) {
        String baseFieldName = name;
        ArrayList<String> nameQualifiers = new ArrayList<String>();
        if (name.contains("::")) {
            StringTokenizer st = new StringTokenizer(name, "::", false);
            while (st.hasMoreTokens()) {
                baseFieldName = st.nextToken();
                nameQualifiers.add(baseFieldName);
            }
            nameQualifiers.remove(nameQualifiers.size() - 1);
            if (nameQualifiers.size() >= 0 && nameQualifiers.get(0).equals(this.baseName)) {
                nameQualifiers.remove(0);
            }
        }
        if (nameQualifiers.size() == 0) {
            if (this.unknownOffsetFields != null) {
                this.setAnonymousUnionOffsets();
            }
            int i = 0;
            while (i < this.fields.size()) {
                if (((FieldType)this.fields.get(i)).getName().equals(baseFieldName)) {
                    IField[] foundFields = new IField[]{this.fields.get(i)};
                    return foundFields;
                }
                ++i;
            }
            if (this.inheritances != null) {
                for (IInheritance inheritance : this.inheritances) {
                    Object inheritanceName = inheritance.getName();
                    if (((String)inheritanceName).indexOf(60) != -1) {
                        inheritanceName = ((String)inheritanceName).replaceAll("class ", "");
                        inheritanceName = ((String)inheritanceName).replaceAll("struct ", "");
                        inheritanceName = ((String)inheritanceName).replaceAll("union ", "");
                    }
                    if (!((String)inheritanceName).equals(baseFieldName)) continue;
                    IField[] foundFields = new IField[1];
                    FieldType newField = new FieldType((String)inheritanceName, this.scope, this, inheritance.getFieldsOffset(), 0, 0, inheritance.getType().getByteSize(), inheritance.getAccessibility(), inheritance.getProperties());
                    newField.setType(inheritance.getType());
                    foundFields[0] = newField;
                    return foundFields;
                }
            }
        }
        if (this.inheritances == null) {
            return null;
        }
        ArrayList<IField> matches = new ArrayList<IField>();
        for (IInheritance inheritance : this.inheritances) {
            if (!(inheritance.getType() instanceof ICompositeType)) continue;
            ICompositeType inheritComposite = (ICompositeType)inheritance.getType();
            matches = this.findInheritedByName(baseFieldName, inheritComposite, inheritComposite.getBaseName(), inheritance.getFieldsOffset(), matches);
        }
        matches = this.pruneMatches(nameQualifiers, matches);
        IField[] foundFields = null;
        if (matches.size() > 0) {
            foundFields = new IField[matches.size()];
            int i = 0;
            while (i < matches.size()) {
                foundFields[i] = matches.get(i);
                ++i;
            }
        }
        return foundFields;
    }

    private ArrayList<IField> pruneMatches(ArrayList<String> nameQualifiers, ArrayList<IField> matches) {
        if (nameQualifiers.size() == 0) {
            return matches;
        }
        int i = 0;
        while (i < matches.size()) {
            ArrayList<String> matchQualifiers = new ArrayList<String>();
            String matchName = matches.get(i).getName();
            if (matchName.contains("::")) {
                StringTokenizer st = new StringTokenizer(matchName, "::", false);
                while (st.hasMoreTokens()) {
                    matchQualifiers.add(st.nextToken());
                }
                matchQualifiers.remove(matchQualifiers.size() - 1);
                int nameIndex = 0;
                int matchIndex = 0;
                while (nameIndex < nameQualifiers.size() && matchIndex < matchQualifiers.size()) {
                    boolean found = false;
                    while (!found && matchIndex < matchQualifiers.size()) {
                        found = nameQualifiers.get(nameIndex).equals(matchQualifiers.get(matchIndex));
                        ++matchIndex;
                    }
                    if (!found) {
                        matches.remove(i);
                        break;
                    }
                    ++nameIndex;
                }
            }
            ++i;
        }
        return matches;
    }

    private ArrayList<IField> findInheritedByName(String name, ICompositeType composite, String prefix, long offset, ArrayList<IField> matches) {
        IInheritance[] compositeInheritances;
        FieldType newField;
        int n;
        IField[] fields = composite.getFields();
        if (fields != null) {
            IField[] iFieldArray = fields;
            n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                String fieldName = field.getName();
                if (fieldName.equals(name)) {
                    newField = new FieldType(String.valueOf(prefix) + "::" + field.getName(), this.scope, composite, offset + field.getFieldOffset(), 0, 0, field.getType().getByteSize(), field.getAccessibility(), field.getProperties());
                    newField.setType(field.getType());
                    matches.add(newField);
                    break;
                }
                ++n2;
            }
        }
        if ((compositeInheritances = composite.getInheritances()).length == 0) {
            return matches;
        }
        IInheritance[] iInheritanceArray = compositeInheritances;
        int n3 = compositeInheritances.length;
        n = 0;
        while (n < n3) {
            IInheritance inheritance = iInheritanceArray[n];
            if (inheritance.getName().equals(name)) {
                newField = new FieldType(inheritance.getName(), this.scope, this, offset + inheritance.getFieldsOffset(), 0, 0, inheritance.getType().getByteSize(), inheritance.getAccessibility(), inheritance.getProperties());
                newField.setType(inheritance.getType());
            }
            if (inheritance.getType() instanceof ICompositeType) {
                ICompositeType inheritComposite = (ICompositeType)inheritance.getType();
                matches = this.findInheritedByName(name, inheritComposite, String.valueOf(prefix) + "::" + inheritComposite.getBaseName(), offset + inheritance.getFieldsOffset(), matches);
            }
            ++n;
        }
        return matches;
    }

    private void setAnonymousUnionOffsets() {
        OffsetAndLength[] offsetSizes = new OffsetAndLength[this.fields.size() + this.inheritanceCount()];
        int count = 0;
        if (this.fields.size() > 0) {
            while (count < this.fields.size()) {
                offsetSizes[count] = new OffsetAndLength();
                offsetSizes[count].offset = this.fields.get(count).getFieldOffset();
                offsetSizes[count].length = this.fields.get(count).getByteSize();
                ++count;
            }
        }
        if (this.inheritances != null) {
            for (IInheritance inheritance : this.inheritances) {
                offsetSizes[count] = new OffsetAndLength();
                offsetSizes[count].offset = inheritance.getFieldsOffset();
                offsetSizes[count].length = inheritance.getType().getByteSize();
                ++count;
            }
        }
        if (offsetSizes.length > 1) {
            boolean sorted;
            int passCnt = 1;
            do {
                sorted = true;
                int i = 0;
                while (i < offsetSizes.length - passCnt) {
                    if (offsetSizes[i].offset > offsetSizes[i + 1].offset) {
                        OffsetAndLength temp = offsetSizes[i];
                        offsetSizes[i] = offsetSizes[i + 1];
                        offsetSizes[i + 1] = temp;
                        sorted = false;
                    }
                    ++i;
                }
            } while (!sorted && ++passCnt < offsetSizes.length);
        }
        int i = 0;
        long fieldOffset = 0L;
        for (IField unknownOffsetField : this.unknownOffsetFields) {
            while (i < offsetSizes.length) {
                if (fieldOffset < offsetSizes[i].offset) break;
                fieldOffset = offsetSizes[i].offset + offsetSizes[i].length;
                ++i;
            }
            unknownOffsetField.setFieldOffset(fieldOffset);
            if (i >= offsetSizes.length) {
                fieldOffset += (long)unknownOffsetField.getByteSize();
            }
            this.fields.add(unknownOffsetField);
        }
        this.unknownOffsetFields = null;
    }

    protected static class OffsetAndLength {
        public long offset;
        public long length;

        protected OffsetAndLength() {
        }
    }
}

