/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.core.runtime.IPath;

public class LineEntry
implements ILineEntry {
    protected IPath filePath;
    protected int lineNumber;
    protected int columnNumber;
    protected IAddress lowAddress;
    protected IAddress highAddress;

    public LineEntry(IPath filePath, int lineNumber, int columnNumber, IAddress lowAddress, IAddress highAddress) {
        this.filePath = filePath;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.lowAddress = lowAddress;
        this.highAddress = highAddress;
    }

    public IPath getFilePath() {
        return this.filePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public IAddress getLowAddress() {
        return this.lowAddress;
    }

    public IAddress getHighAddress() {
        return this.highAddress;
    }

    public void setHighAddress(IAddress highAddress) {
        this.highAddress = highAddress;
    }

    public int compareTo(Object o) {
        if (o instanceof ILineEntry) {
            int diff = this.lowAddress.compareTo((Object)((ILineEntry)o).getLowAddress());
            if (diff != 0) {
                return diff;
            }
            if (this.highAddress != null && ((ILineEntry)o).getHighAddress() != null) {
                return this.highAddress.compareTo((Object)((ILineEntry)o).getHighAddress());
            }
            return 0;
        }
        if (o instanceof IAddress) {
            return this.lowAddress.compareTo(o);
        }
        return 0;
    }

    public String toString() {
        return "LineEntry [lowAddress=" + (this.lowAddress != null ? this.lowAddress.toHexAddressString() : "null") + ", highAddress=" + (this.highAddress != null ? this.highAddress.toHexAddressString() : "null") + (this.filePath != null ? ", path=" + this.filePath.toOSString() + ", " : ", ") + "line=" + this.lineNumber + ", column=" + this.columnNumber + "]";
    }
}

