/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.IRuntimeSection;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeSection
implements IRuntimeSection {
    private ISection section;
    private IAddress runtimeAddress;

    public RuntimeSection(ISection section) {
        this.section = section;
        this.runtimeAddress = section.getLinkAddress();
    }

    @Override
    public int getId() {
        return this.section.getId();
    }

    @Override
    public long getSize() {
        return this.section.getSize();
    }

    @Override
    public IAddress getLinkAddress() {
        return this.section.getLinkAddress();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.section.getProperties();
    }

    @Override
    public IAddress getRuntimeAddress() {
        return this.runtimeAddress;
    }

    @Override
    public void relocate(IAddress runtimeAddress) {
        this.runtimeAddress = runtimeAddress;
    }

    public String toString() {
        return MessageFormat.format("[sectionID={0}, link address={1}, runtime address={2}]", this.getId(), this.getLinkAddress().toHexAddressString(), this.runtimeAddress.toHexAddressString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeSection other = (RuntimeSection)obj;
        if (!this.getLinkAddress().equals((Object)other.getLinkAddress())) {
            return false;
        }
        if (!this.getRuntimeAddress().equals((Object)other.getRuntimeAddress())) {
            return false;
        }
        return this.getId() == other.getId();
    }
}

