/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.MemoryStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.symbols.ArrayBoundType;
import org.eclipse.cdt.debug.edc.internal.symbols.ArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.CPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ClassType;
import org.eclipse.cdt.debug.edc.internal.symbols.ConstType;
import org.eclipse.cdt.debug.edc.internal.symbols.Enumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.Enumerator;
import org.eclipse.cdt.debug.edc.internal.symbols.FieldType;
import org.eclipse.cdt.debug.edc.internal.symbols.FunctionScope;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;
import org.eclipse.cdt.debug.edc.internal.symbols.InheritanceType;
import org.eclipse.cdt.debug.edc.internal.symbols.LexicalBlockScope;
import org.eclipse.cdt.debug.edc.internal.symbols.LineEntry;
import org.eclipse.cdt.debug.edc.internal.symbols.PointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.ReferenceType;
import org.eclipse.cdt.debug.edc.internal.symbols.Scope;
import org.eclipse.cdt.debug.edc.internal.symbols.StructType;
import org.eclipse.cdt.debug.edc.internal.symbols.SubroutineType;
import org.eclipse.cdt.debug.edc.internal.symbols.TemplateParamType;
import org.eclipse.cdt.debug.edc.internal.symbols.TypedefType;
import org.eclipse.cdt.debug.edc.internal.symbols.UnionType;
import org.eclipse.cdt.debug.edc.internal.symbols.VolatileType;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfCompileUnit;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFileHelper;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFunctionScope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfMessages;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfModuleScope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfVariable;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationEntry;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationExpression;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationList;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.RangeList;
import org.eclipse.cdt.debug.edc.internal.symbols.files.BaseExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerEABI;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglingException;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSection;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IRangeList;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IUnmangler;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfInfoReader {
    private BaseAndScopedNames baseAndScopedNames = new BaseAndScopedNames();
    private static boolean DEBUG = false;
    private static String dumpFileName = "C:\\temp\\_EDC_DwarfReaderDump.txt";
    public static final String DWARF_DEBUG_INFO = ".debug_info";
    public static final String DWARF_DEBUG_RANGES = ".debug_ranges";
    public static final String DWARF_DEBUG_ABBREV = ".debug_abbrev";
    public static final String DWARF_DEBUG_ARANGES = ".debug_aranges";
    public static final String DWARF_DEBUG_LINE = ".debug_line";
    public static final String DWARF_DEBUG_FRAME = ".debug_frame";
    public static final String DWARF_EH_FRAME = ".eh_frame";
    public static final String DWARF_DEBUG_LOC = ".debug_loc";
    public static final String DWARF_DEBUG_PUBNAMES = ".debug_pubnames";
    public static final String DWARF_DEBUG_STR = ".debug_str";
    public static final String DWARF_DEBUG_FUNCNAMES = ".debug_funcnames";
    public static final String DWARF_DEBUG_TYPENAMES = ".debug_typenames";
    public static final String DWARF_DEBUG_VARNAMES = ".debug_varnames";
    public static final String DWARF_DEBUG_WEAKNAMES = ".debug_weaknames";
    public static final String DWARF_DEBUG_MACINFO = ".debug_macinfo";
    private Map<Long, Collection<LocationEntry>> locationEntriesByOffset = Collections.synchronizedMap(new HashMap());
    private DwarfDebugInfoProvider provider;
    private IExecutableSymbolicsReader exeReader;
    private DwarfModuleScope moduleScope;
    private IPath symbolFilePath;
    private IExecutableSection debugInfoSection;
    private IExecutableSection publicNamesSection;
    private DwarfDebugInfoProvider.CompilationUnitHeader currentCUHeader;
    private Map<IType, IType> typeToParentMap = Collections.synchronizedMap(new HashMap());
    private IType currentParentType;
    private Scope currentParentScope;
    private DwarfCompileUnit currentCompileUnitScope;
    private DwarfFileHelper fileHelper;
    private RangeList codeRanges;
    private ICPPBasicType voidType = null;
    private IUnmangler unmangler;
    private static Comparator<DwarfCompileUnit> sComparatorByLowAddress = new Comparator<DwarfCompileUnit>(){

        @Override
        public int compare(DwarfCompileUnit o1, DwarfCompileUnit o2) {
            return o1.getLowAddress().compareTo((Object)o2.getLowAddress());
        }
    };

    public DwarfInfoReader(DwarfDebugInfoProvider provider) {
        this.provider = provider;
        this.exeReader = provider.getExecutableSymbolicsReader();
        if (this.exeReader instanceof BaseExecutableSymbolicsReader) {
            this.unmangler = ((BaseExecutableSymbolicsReader)this.exeReader).getUnmangler();
        }
        if (this.unmangler == null) {
            this.unmangler = new UnmanglerEABI();
        }
        this.symbolFilePath = provider.getSymbolFile();
        this.fileHelper = provider.fileHelper;
        this.moduleScope = (DwarfModuleScope)provider.getModuleScope();
        this.debugInfoSection = this.exeReader.findExecutableSection(DWARF_DEBUG_INFO);
        this.publicNamesSection = this.exeReader.findExecutableSection(DWARF_DEBUG_PUBNAMES);
        this.codeRanges = this.getCodeRanges();
    }

    private String unmangle(String name) {
        if (!this.unmangler.isMangled(name)) {
            return name;
        }
        try {
            name = this.unmangler.unmangle(name);
        }
        catch (UnmanglingException unmanglingException) {}
        return name;
    }

    private String unmangleType(String name) {
        if (!this.unmangler.isMangled(name)) {
            return name;
        }
        try {
            name = this.unmangler.unmangleType(name);
        }
        catch (UnmanglingException unmanglingException) {}
        return name;
    }

    private RangeList getCodeRanges() {
        RangeList codeRanges = new RangeList();
        for (ISection section : this.exeReader.getSections()) {
            if (!section.getProperties().get("name").equals(".text")) continue;
            long start = section.getLinkAddress().getValue().longValue();
            long size = section.getSize();
            codeRanges.addRange(start, start + size);
        }
        return codeRanges;
    }

    protected IStreamBuffer getDwarfSection(String sectionName) {
        IStreamBuffer buffer = null;
        IExecutableSection section = this.exeReader.findExecutableSection(sectionName);
        if (section != null) {
            buffer = section.getBuffer();
        }
        return buffer;
    }

    public void parseInitial() {
        Job parseInitialJob = new Job(String.valueOf(DwarfMessages.DwarfInfoReader_ReadingSymbolInfo) + this.symbolFilePath){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (EDCTrace.SYMBOL_READER_TRACE_ON) {
                    EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceInitialParseFor) + DwarfInfoReader.this.symbolFilePath));
                }
                DwarfDebugInfoProvider dwarfDebugInfoProvider = DwarfInfoReader.this.provider;
                synchronized (dwarfDebugInfoProvider) {
                    DwarfInfoReader.this.parseCUDebugInfo(monitor);
                    DwarfInfoReader.this.parsePublicNames();
                }
                if (EDCTrace.SYMBOL_READER_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(DwarfMessages.DwarfInfoReader_TraceFinishedInitialParse));
                }
                return Status.OK_STATUS;
            }
        };
        try {
            parseInitialJob.schedule();
            parseInitialJob.join();
        }
        catch (InterruptedException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseForAddresses(boolean includeCUWithoutCode) {
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceAddressesParseFor) + this.symbolFilePath));
        }
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            for (DwarfCompileUnit compileUnit : this.provider.compileUnits) {
                if (DEBUG && (compileUnit.getHighAddress().isZero() ? !$assertionsDisabled && compileUnit.getChildren().size() != 0 : !$assertionsDisabled && compileUnit.getChildren().size() < 0)) {
                    throw new AssertionError();
                }
                if (!includeCUWithoutCode && compileUnit.getHighAddress().isZero()) continue;
                this.parseCompilationUnitForAddresses(compileUnit);
            }
        }
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(DwarfMessages.DwarfInfoReader_TraceFinishedAddressesParse));
        }
        this.moduleScope.fixupRanges((IAddress)Addr32.ZERO);
        if (DEBUG) {
            this.dumpSymbols();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseForAddress(IAddress linkAddress) {
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceAddressParseFor) + this.symbolFilePath));
        }
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            DwarfCompileUnit cu = new DwarfCompileUnit(this.provider, null, null, linkAddress, linkAddress, null, false, null);
            int index = Collections.binarySearch(this.provider.sortedCompileUnitsWithCode, cu, sComparatorByLowAddress);
            if (index >= 0) {
                cu = this.provider.sortedCompileUnitsWithCode.get(index);
                this.parseCompilationUnitForAddresses(cu);
            } else if (index < -1 && -index - 2 < this.provider.sortedCompileUnitsWithCode.size()) {
                cu = this.provider.sortedCompileUnitsWithCode.get(-index - 2);
                if (cu.getLowAddress().compareTo((Object)linkAddress) <= 0 && cu.getHighAddress().compareTo((Object)linkAddress) >= 0) {
                    this.parseCompilationUnitForAddresses(cu);
                }
            } else {
                return;
            }
            if (this.moduleScope.getLowAddress().compareTo((Object)cu.getLowAddress()) > 0) {
                this.moduleScope.setLowAddress(cu.getLowAddress());
            }
            if (this.moduleScope.getHighAddress().compareTo((Object)cu.getHighAddress()) < 0) {
                this.moduleScope.setHighAddress(cu.getHighAddress());
            }
        }
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(DwarfMessages.DwarfInfoReader_TraceFinishedAddressParse));
        }
    }

    private void parsePublicNames() {
        if (this.publicNamesSection == null || this.debugInfoSection == null) {
            return;
        }
        IStreamBuffer bufferPublicNames = this.publicNamesSection.getBuffer();
        if (bufferPublicNames == null) {
            return;
        }
        IStreamBuffer bufferDebuginfo = this.debugInfoSection.getBuffer();
        if (bufferDebuginfo == null) {
            return;
        }
        long fileIndex = 0L;
        long fileEndIndex = bufferPublicNames.capacity();
        while (fileIndex < fileEndIndex) {
            fileIndex = this.parsePublicNamesSet(bufferPublicNames, fileIndex, bufferDebuginfo);
        }
    }

    private long parsePublicNamesSet(IStreamBuffer bufferPublicNames, long fileIndex, IStreamBuffer bufferDebugInfo) {
        bufferPublicNames.position(fileIndex);
        int setLength = bufferPublicNames.getInt();
        IStreamBuffer dataPublicNames = bufferPublicNames.wrapSubsection(setLength);
        dataPublicNames.position(2L);
        int debugInfoOffset = dataPublicNames.getInt();
        int debugInfoLength = dataPublicNames.getInt();
        try {
            bufferDebugInfo.position(debugInfoOffset);
            IStreamBuffer dataInfoBytes = bufferDebugInfo.wrapSubsection(debugInfoLength);
            DwarfDebugInfoProvider.CompilationUnitHeader header = this.provider.debugOffsetsToCompileUnits.get(debugInfoOffset);
            Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(header.abbreviationOffset);
            while (dataPublicNames.remaining() > 4L) {
                int objectOffset = dataPublicNames.getInt();
                String name = DwarfInfoReader.readString(dataPublicNames);
                dataInfoBytes.position(objectOffset);
                long code = DwarfInfoReader.read_unsigned_leb128(dataInfoBytes);
                DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(new Long(code));
                if (entry == null || name.length() <= 0 || name.startsWith("<")) continue;
                String baseName = name = this.unmangle(name);
                int baseStart = name.lastIndexOf("::");
                if (baseStart != -1) {
                    baseName = name.substring(baseStart + 2);
                }
                if (entry.tag == 52) {
                    List<DwarfDebugInfoProvider.PublicNameInfo> variables = this.provider.publicVariables.get(baseName);
                    if (variables == null) {
                        variables = new ArrayList<DwarfDebugInfoProvider.PublicNameInfo>();
                    }
                    variables.add(new DwarfDebugInfoProvider.PublicNameInfo(name, header, entry.tag));
                    this.provider.publicVariables.put(baseName, variables);
                    continue;
                }
                if (entry.tag != 46) continue;
                List<DwarfDebugInfoProvider.PublicNameInfo> functions = this.provider.publicFunctions.get(baseName);
                if (functions == null) {
                    functions = new ArrayList<DwarfDebugInfoProvider.PublicNameInfo>();
                    functions.add(new DwarfDebugInfoProvider.PublicNameInfo(name, header, entry.tag));
                } else {
                    ArrayList arrayList = (ArrayList)functions;
                    boolean found = false;
                    int i = arrayList.size() - 1;
                    while (!found && i >= 0 && ((DwarfDebugInfoProvider.PublicNameInfo)arrayList.get((int)i)).cuHeader == header) {
                        found = ((DwarfDebugInfoProvider.PublicNameInfo)arrayList.get((int)i)).nameWithNameSpace.equals(name);
                        --i;
                    }
                    if (!found) {
                        functions.add(new DwarfDebugInfoProvider.PublicNameInfo(name, header, entry.tag));
                    }
                }
                this.provider.publicFunctions.put(baseName, functions);
            }
        }
        catch (Throwable t) {
            EDCDebugger.getMessageLogger().logError(null, t);
        }
        return fileIndex + (long)setLength + 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseForTypes() {
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            for (DwarfCompileUnit compileUnit : this.provider.compileUnits) {
                this.parseCompilationUnitForTypes(compileUnit);
            }
        }
    }

    private void parseCUDebugInfo(IProgressMonitor monitor) {
        if (this.debugInfoSection == null) {
            return;
        }
        if (this.provider.referencedFiles.isEmpty()) {
            this.provider.buildReferencedFilesList = true;
        }
        IStreamBuffer buffer = this.debugInfoSection.getBuffer();
        IStreamBuffer debugStrings = this.getDebugStrings();
        boolean havePubNames = this.publicNamesSection != null && this.publicNamesSection.getBuffer() != null;
        int totalWork = (int)(buffer.capacity() / 1024L);
        monitor.beginTask(DwarfMessages.DwarfInfoReader_ReadDebugInfo, totalWork);
        try {
            if (buffer != null) {
                long fileIndex = 0L;
                long fileEndIndex = buffer.capacity();
                while (fileIndex < fileEndIndex) {
                    long oldIndex = fileIndex;
                    fileIndex = this.parseCompilationUnitForNames(buffer, fileIndex, debugStrings, fileEndIndex, havePubNames);
                    monitor.worked((int)((fileIndex - oldIndex) / 1024L));
                }
            }
        }
        finally {
            monitor.done();
        }
        this.provider.compileUnits.trimToSize();
        this.provider.sortedCompileUnitsWithCode.trimToSize();
        Collections.sort(this.provider.sortedCompileUnitsWithCode, sComparatorByLowAddress);
        this.provider.buildReferencedFilesList = false;
    }

    private long parseCompilationUnitForNames(IStreamBuffer buffer, long fileIndex, IStreamBuffer debugStrings, long fileEndIndex, boolean havePubNames) {
        buffer.position(fileIndex);
        this.currentCUHeader = new DwarfDebugInfoProvider.CompilationUnitHeader();
        this.currentCUHeader.length = buffer.getInt();
        this.currentCUHeader.version = buffer.getShort();
        this.currentCUHeader.abbreviationOffset = buffer.getInt();
        this.currentCUHeader.addressSize = buffer.get();
        this.currentCUHeader.debugInfoOffset = (int)fileIndex;
        if (fileIndex + (long)this.currentCUHeader.length + 8L < fileEndIndex) {
            buffer.position(fileIndex + (long)this.currentCUHeader.length + 8L);
            short nextVersion = buffer.getShort();
            buffer.position(fileIndex + (long)this.currentCUHeader.length + 14L);
            byte nextAddrSize = buffer.get();
            if (this.currentCUHeader.version != nextVersion || this.currentCUHeader.addressSize != nextAddrSize) {
                buffer.position(fileIndex + (long)this.currentCUHeader.length + 4L);
                nextVersion = buffer.getShort();
                buffer.position(fileIndex + (long)this.currentCUHeader.length + 10L);
                nextAddrSize = buffer.get();
                if (this.currentCUHeader.version == nextVersion && this.currentCUHeader.addressSize == nextAddrSize) {
                    this.currentCUHeader.length -= 4;
                }
            }
        }
        buffer.position(fileIndex);
        IStreamBuffer in = buffer.wrapSubsection(this.currentCUHeader.length + 4);
        in.position(11L);
        try {
            Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(this.currentCUHeader.abbreviationOffset);
            long code = DwarfInfoReader.read_unsigned_leb128(in);
            DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(code);
            DwarfDebugInfoProvider.AttributeList attributeList = new DwarfDebugInfoProvider.AttributeList(entry, in, this.currentCUHeader.addressSize, debugStrings);
            this.processCompileUnit(this.currentCUHeader, entry.hasChildren, attributeList);
            if (!havePubNames) {
                byte addressSize = this.currentCUHeader.addressSize;
                block6: while (in.remaining() > 0L) {
                    code = DwarfInfoReader.read_unsigned_leb128(in);
                    if (code == 0L) continue;
                    entry = abbrevs.get(code);
                    switch (entry.tag) {
                        case 52: {
                            this.parseAttributesForNames(true, this.baseAndScopedNames, entry, in, addressSize, debugStrings);
                            if (this.baseAndScopedNames.baseName == null) continue block6;
                            this.storePublicNames(this.provider.publicVariables, this.baseAndScopedNames, this.currentCUHeader, (short)52);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 63: 
                        case 64: {
                            DwarfDebugInfoProvider.AttributeValue.skipAttributesToSibling(entry, in, addressSize);
                            break;
                        }
                        default: {
                            DwarfDebugInfoProvider.AttributeList.skipAttributes(entry, in, addressSize);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfInfoReader_ParseDebugInfoSectionFailed1) + this.debugInfoSection.getName() + DwarfMessages.DwarfInfoReader_ParseDebugInfoSectionFailed2 + this.symbolFilePath, t);
        }
        return fileIndex += (long)(this.currentCUHeader.length + 4);
    }

    private void parseAttributesForNames(boolean onlyExternal, BaseAndScopedNames baseAndScopedNames, DwarfDebugInfoProvider.AbbreviationEntry entry, IStreamBuffer in, byte addressSize, IStreamBuffer debugStrings) {
        String name = null;
        baseAndScopedNames.baseName = null;
        baseAndScopedNames.nameWithScope = null;
        boolean isExternal = false;
        int len = entry.attributes.size();
        int i = 0;
        while (i < len) {
            block21: {
                DwarfDebugInfoProvider.Attribute attr = entry.attributes.get(i);
                try {
                    if (attr.tag == 3 || attr.tag == 8199) {
                        if (attr.form == 8) {
                            int c;
                            StringBuffer sb = new StringBuffer();
                            while ((c = in.get() & 0xFF) != -1) {
                                if (c == 0) break;
                                sb.append((char)c);
                            }
                            name = sb.toString();
                        } else if (attr.form == 14) {
                            int debugStringOffset = in.getInt();
                            if (debugStrings != null && debugStringOffset >= 0 && (long)debugStringOffset < debugStrings.capacity()) {
                                debugStrings.position(debugStringOffset);
                                name = DwarfInfoReader.readString(debugStrings);
                            }
                        }
                        if (name == null) break block21;
                        if (attr.tag == 3) {
                            baseAndScopedNames.baseName = name;
                            baseAndScopedNames.nameWithScope = name;
                        } else if (this.exeReader instanceof BaseExecutableSymbolicsReader) {
                            try {
                                baseAndScopedNames.nameWithScope = this.unmangler.unmangle(this.unmangler.undecorate(name));
                            }
                            catch (UnmanglingException unmanglingException) {}
                        }
                        name = null;
                        break block21;
                    }
                    if (attr.tag == 63) {
                        if (attr.form == 12) {
                            isExternal = in.get() != 0;
                        } else {
                            DwarfDebugInfoProvider.AttributeValue.skipAttributeValue(attr.form, in, addressSize);
                        }
                    } else {
                        DwarfDebugInfoProvider.AttributeValue.skipAttributeValue(attr.form, in, addressSize);
                    }
                }
                catch (Throwable t) {
                    EDCDebugger.getMessageLogger().logError(null, t);
                    break;
                }
            }
            ++i;
        }
        if (onlyExternal && !isExternal) {
            baseAndScopedNames.baseName = null;
            baseAndScopedNames.nameWithScope = null;
        } else if (baseAndScopedNames.nameWithScope != null && baseAndScopedNames.baseName == null) {
            int baseStart = baseAndScopedNames.nameWithScope.lastIndexOf("::");
            baseAndScopedNames.baseName = baseStart != -1 ? baseAndScopedNames.nameWithScope.substring(baseStart + 2) : baseAndScopedNames.nameWithScope;
        }
    }

    private void storePublicNames(Map<String, List<DwarfDebugInfoProvider.PublicNameInfo>> namesStore, BaseAndScopedNames baseAndScopedNames, DwarfDebugInfoProvider.CompilationUnitHeader cuHeader, short tag) {
        List<DwarfDebugInfoProvider.PublicNameInfo> currentNames = namesStore.get(baseAndScopedNames.baseName);
        if (currentNames == null) {
            currentNames = new ArrayList<DwarfDebugInfoProvider.PublicNameInfo>();
            namesStore.put(baseAndScopedNames.baseName, currentNames);
        }
        currentNames.add(new DwarfDebugInfoProvider.PublicNameInfo(baseAndScopedNames.nameWithScope, cuHeader, tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void parseCompilationUnitForAddressesPrivate(DwarfCompileUnit compileUnit, IProgressMonitor monitor) {
        DwarfCompileUnit dwarfCompileUnit = compileUnit;
        synchronized (dwarfCompileUnit) {
            IStreamBuffer buffer;
            if (compileUnit.isParsedForAddresses()) {
                return;
            }
            compileUnit.setParsedForAddresses(true);
            DwarfDebugInfoProvider.CompilationUnitHeader header = compileUnit.header;
            if (header == null) {
                return;
            }
            if (EDCTrace.SYMBOL_READER_TRACE_ON) {
                EDCTrace.getTrace().trace(null, EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceAddressParse1) + Integer.toHexString(header.debugInfoOffset) + DwarfMessages.DwarfInfoReader_TraceAddressParse2 + header.scope.getFilePath()));
            }
            if ((buffer = this.debugInfoSection.getBuffer()) == null) {
                return;
            }
            int fileIndex = header.debugInfoOffset;
            buffer.position(fileIndex);
            IStreamBuffer data = buffer.wrapSubsection(header.length + 4);
            data.position(11L);
            this.currentCompileUnitScope = compileUnit;
            this.currentParentScope = compileUnit;
            this.registerScope(header.debugInfoOffset, compileUnit);
            this.currentCUHeader = header;
            try {
                Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(header.abbreviationOffset);
                this.parseForAddresses(data, abbrevs, header, new Stack<Scope>(), monitor);
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfInfoReader_ParseDebugInfoSectionFailed1) + this.debugInfoSection.getName() + DwarfMessages.DwarfInfoReader_ParseDebugInfoSectionFailed2 + this.symbolFilePath, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseCompilationUnitForAddresses(DwarfCompileUnit compileUnit) {
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            DwarfCompileUnit dwarfCompileUnit = compileUnit;
            synchronized (dwarfCompileUnit) {
                if (compileUnit.isParsedForAddresses()) {
                    return;
                }
            }
            this.parseCompilationUnitForAddressesPrivate(compileUnit, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseCompilationUnitForTypes(DwarfCompileUnit compileUnit) {
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            DwarfCompileUnit dwarfCompileUnit = compileUnit;
            synchronized (dwarfCompileUnit) {
                IStreamBuffer buffer;
                if (compileUnit.isParsedForTypes()) {
                    return;
                }
                compileUnit.setParsedForTypes(true);
                DwarfDebugInfoProvider.CompilationUnitHeader header = compileUnit.header;
                if (header == null) {
                    return;
                }
                if (EDCTrace.SYMBOL_READER_TRACE_ON) {
                    EDCTrace.getTrace().trace(null, EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceTypeParse1) + Integer.toHexString(header.debugInfoOffset) + DwarfMessages.DwarfInfoReader_TraceTypeParse2 + header.scope.getFilePath()));
                }
                if ((buffer = this.debugInfoSection.getBuffer()) == null) {
                    return;
                }
                int fileIndex = header.debugInfoOffset;
                buffer.position(fileIndex);
                IStreamBuffer data = buffer.wrapSubsection(header.length + 4);
                data.position(11L);
                this.currentCompileUnitScope = compileUnit;
                this.currentParentScope = compileUnit;
                this.registerScope(header.debugInfoOffset, compileUnit);
                this.currentCUHeader = header;
                try {
                    Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(header.abbreviationOffset);
                    this.parseForTypes(data, abbrevs, header, new Stack<Scope>());
                }
                catch (Throwable t) {
                    EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfInfoReader_ParseTraceInfoSectionFailed1) + this.debugInfoSection.getName() + DwarfMessages.DwarfInfoReader_ParseTraceInfoSectionFailed2 + this.symbolFilePath, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quickParseDebugInfo(IProgressMonitor monitor) {
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceQuickParse) + this.symbolFilePath));
        }
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            this.doQuickParseDebugInfo(monitor);
        }
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(DwarfMessages.DwarfInfoReader_TraceFinishedQuickParse));
        }
    }

    private void doQuickParseDebugInfo(IProgressMonitor monitor) {
        if (this.debugInfoSection == null) {
            return;
        }
        IStreamBuffer buffer = this.debugInfoSection.getBuffer();
        if (buffer == null) {
            return;
        }
        try {
            try {
                long fileIndex = 0L;
                long fileEndIndex = buffer.capacity();
                monitor.beginTask(DwarfMessages.DwarfInfoReader_ReadDebugInfo, (int)(fileEndIndex / 1024L));
                buffer.position(0L);
                while (fileIndex < fileEndIndex) {
                    buffer.position(fileIndex);
                    int unit_length = buffer.getInt();
                    short version = buffer.getShort();
                    int debug_abbrev_offset = buffer.getInt();
                    byte address_size = buffer.get();
                    if (fileIndex + (long)unit_length + 8L < fileEndIndex) {
                        buffer.position(fileIndex + (long)unit_length + 8L);
                        short nextVersion = buffer.getShort();
                        buffer.position(fileIndex + (long)unit_length + 14L);
                        byte nextAddrSize = buffer.get();
                        if (version != nextVersion || address_size != nextAddrSize) {
                            buffer.position(fileIndex + (long)unit_length + 4L);
                            nextVersion = buffer.getShort();
                            buffer.position(fileIndex + (long)unit_length + 10L);
                            nextAddrSize = buffer.get();
                            if (version == nextVersion && address_size == nextAddrSize) {
                                unit_length -= 4;
                            }
                        }
                    }
                    buffer.position(fileIndex + 4L);
                    IStreamBuffer data = buffer.wrapSubsection(unit_length);
                    data.position(7L);
                    Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(debug_abbrev_offset);
                    long code = DwarfInfoReader.read_unsigned_leb128(data);
                    DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(code);
                    DwarfDebugInfoProvider.AttributeList attributeList = new DwarfDebugInfoProvider.AttributeList(entry, data, address_size, this.getDebugStrings());
                    String name = attributeList.getAttributeValueAsString((short)3);
                    String compDir = attributeList.getAttributeValueAsString((short)27);
                    IPath filePath = this.fileHelper.normalizeFilePath(compDir, name);
                    this.provider.referencedFiles.add(filePath.toOSString());
                    DwarfDebugInfoProvider.AttributeValue a = attributeList.getAttribute((short)16);
                    if (a != null) {
                        int stmtList = a.getValueAsInt();
                        this.quickParseLineInfo(stmtList, compDir);
                    }
                    long oldIndex = fileIndex;
                    monitor.worked((int)(((fileIndex += (long)(unit_length + 4)) - oldIndex) / 1024L));
                }
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfInfoReader_ParseSectionSourceFilesFailed1) + this.debugInfoSection.getName() + DwarfMessages.DwarfInfoReader_ParseSectionSourceFilesFailed2 + this.symbolFilePath, t);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private IStreamBuffer getDebugStrings() {
        return this.getDwarfSection(DWARF_DEBUG_STR);
    }

    private void quickParseLineInfo(int lineTableOffset, String compileUnitDirectory) {
        IPath compileUnitDirectoryPath = PathUtils.createPath(compileUnitDirectory);
        try {
            IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_LINE);
            if (data != null) {
                String fileName;
                String str;
                data.position(lineTableOffset);
                data.position(data.position() + 14L);
                int opcode_base = data.get() & 0xFF;
                data.position(data.position() + (long)opcode_base - 1L);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add(compileUnitDirectory);
                while ((str = DwarfInfoReader.readString(data)).length() != 0) {
                    IPath dir = PathUtils.createPath(str);
                    if (!dir.isAbsolute() && dir.getDevice() == null) {
                        dir = compileUnitDirectoryPath.append(str);
                    }
                    dirList.add(dir.toString());
                }
                while ((fileName = DwarfInfoReader.readString(data)).length() != 0) {
                    long leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                    IPath fullPath = this.fileHelper.normalizeFilePath((String)dirList.get((int)leb128), fileName);
                    if (fullPath != null) {
                        this.provider.referencedFiles.add(fullPath.toOSString());
                    }
                    leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                    leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                }
            }
        }
        catch (Throwable t) {
            EDCDebugger.getMessageLogger().logError(null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ILineEntry> parseLineTable(IScope scope, DwarfDebugInfoProvider.AttributeList attributes, List<IPath> fileList) {
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            IAddress prevHigh;
            ArrayList<ILineEntry> lineEntries = new ArrayList<ILineEntry>();
            try {
                IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_LINE);
                DwarfDebugInfoProvider.AttributeValue a = attributes.getAttribute((short)16);
                if (data != null && a != null) {
                    String fileName;
                    String str;
                    int stmtList = a.getValueAsInt();
                    data.position(stmtList);
                    int length = data.getInt() + 4;
                    data.getShort();
                    data.getInt();
                    int minimum_instruction_length = data.get() & 0xFF;
                    boolean default_is_stmt = data.get() > 0;
                    byte line_base = data.get();
                    int line_range = data.get() & 0xFF;
                    int opcode_base = data.get() & 0xFF;
                    byte[] opcodes = new byte[opcode_base - 1];
                    data.get(opcodes);
                    ArrayList<String> dirList = new ArrayList<String>();
                    String compDir = attributes.getAttributeValueAsString((short)27);
                    dirList.add(compDir);
                    IPath compDirPath = PathUtils.createPath(compDir);
                    while ((str = DwarfInfoReader.readString(data)).length() != 0) {
                        IPath dir = PathUtils.createPath(str);
                        if (!dir.isAbsolute() && dir.getDevice() == null) {
                            dir = compDirPath.append(str);
                        }
                        dirList.add(dir.toString());
                    }
                    while ((fileName = DwarfInfoReader.readString(data)).length() != 0) {
                        long leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                        IPath fullPath = this.fileHelper.normalizeFilePath((String)dirList.get((int)leb128), fileName);
                        fileList.add(fullPath);
                        leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                        leb128 = DwarfInfoReader.read_unsigned_leb128(data);
                    }
                    long info_address = 0L;
                    long info_file = 1L;
                    int info_line = 1;
                    int info_column = 0;
                    boolean is_stmt = default_is_stmt;
                    long lineInfoEnd = stmtList + length;
                    block26: while (data.position() < lineInfoEnd) {
                        byte opcodeB = data.get();
                        int opcode = 0xFF & opcodeB;
                        if (opcode >= opcode_base) {
                            IPath path;
                            info_line += (opcode - opcode_base) % line_range + line_base;
                            info_address += (long)((opcode - opcode_base) / line_range * minimum_instruction_length);
                            if (!is_stmt || fileList.size() <= 0 || (path = fileList.get((int)info_file - 1)) == null) continue;
                            lineEntries.add(new LineEntry(path, info_line, info_column, (IAddress)new Addr32(info_address), null));
                            continue;
                        }
                        if (opcode == 0) {
                            long op_size = DwarfInfoReader.read_unsigned_leb128(data);
                            long op_pos = data.position();
                            int code = data.get() & 0xFF;
                            switch (code) {
                                case 3: {
                                    fileName = DwarfInfoReader.readString(data);
                                    long dir = DwarfInfoReader.read_unsigned_leb128(data);
                                    DwarfInfoReader.read_unsigned_leb128(data);
                                    DwarfInfoReader.read_unsigned_leb128(data);
                                    IPath fullPath = this.fileHelper.normalizeFilePath((String)dirList.get((int)dir), fileName);
                                    if (fullPath == null) break;
                                    fileList.add(fullPath);
                                    break;
                                }
                                case 1: {
                                    if (lineEntries.size() > 0) {
                                        ((ILineEntry)lineEntries.get(lineEntries.size() - 1)).setHighAddress((IAddress)new Addr32(info_address));
                                    }
                                    info_address = 0L;
                                    info_file = 1L;
                                    info_line = 1;
                                    info_column = 0;
                                    is_stmt = default_is_stmt;
                                    break;
                                }
                                case 2: {
                                    info_address = data.getInt();
                                    break;
                                }
                                default: {
                                    data.position((int)(data.position() + op_size - 1L));
                                }
                            }
                            assert (data.position() == op_pos + op_size);
                            continue;
                        }
                        switch (opcode) {
                            case 1: {
                                if (!is_stmt || fileList.size() <= 0) continue block26;
                                lineEntries.add(new LineEntry(fileList.get((int)info_file - 1), info_line, info_column, (IAddress)new Addr32(info_address), null));
                                break;
                            }
                            case 2: {
                                info_address += DwarfInfoReader.read_unsigned_leb128(data) * (long)minimum_instruction_length;
                                break;
                            }
                            case 3: {
                                info_line = (int)((long)info_line + DwarfInfoReader.read_signed_leb128(data));
                                break;
                            }
                            case 4: {
                                info_file = DwarfInfoReader.read_unsigned_leb128(data);
                                break;
                            }
                            case 5: {
                                info_column = (int)DwarfInfoReader.read_unsigned_leb128(data);
                                break;
                            }
                            case 6: {
                                is_stmt = !is_stmt;
                                break;
                            }
                            case 7: {
                                break;
                            }
                            case 8: {
                                info_address += (long)((255 - opcode_base) / line_range * minimum_instruction_length);
                                break;
                            }
                            case 9: {
                                info_address += (long)data.getShort();
                                break;
                            }
                            case 10: {
                                break;
                            }
                            case 11: {
                                break;
                            }
                            case 12: {
                                DwarfInfoReader.read_unsigned_leb128(data);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError(null, t);
            }
            Collections.sort(lineEntries);
            ILineEntry previousEntry = null;
            for (ILineEntry line : lineEntries) {
                if (previousEntry != null && previousEntry.getHighAddress() == null) {
                    previousEntry.setHighAddress(line.getLowAddress());
                }
                previousEntry = line;
            }
            if (previousEntry != null && (prevHigh = previousEntry.getHighAddress()) == null) {
                previousEntry.setHighAddress(scope.getHighAddress());
            }
            return lineEntries;
        }
    }

    private void parseForAddresses(IStreamBuffer in, Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs, DwarfDebugInfoProvider.CompilationUnitHeader header, Stack<Scope> nestingStack, IProgressMonitor monitor) throws IOException {
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().trace(null, EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceScopeAddressParse1) + header.scope.getName() + DwarfMessages.DwarfInfoReader_TraceScopeAddressParse2 + Long.toHexString(header.debugInfoOffset)));
        }
        try {
            long startWork;
            long lastWork = startWork = in.remaining();
            int workChunk = (int)(startWork / Integer.MAX_VALUE) + 1;
            int work = (int)(startWork / (long)workChunk);
            monitor.beginTask(String.valueOf(DwarfMessages.DwarfInfoReader_TraceScopeAddressParse1) + header.scope.getName() + DwarfMessages.DwarfInfoReader_TraceScopeAddressParse2 + Long.toHexString(header.debugInfoOffset), work);
            block8: while (in.remaining() > 0L) {
                work = (int)((lastWork - in.remaining()) / (long)workChunk);
                monitor.worked(work);
                lastWork = in.remaining();
                long offset = in.position() + (long)this.currentCUHeader.debugInfoOffset;
                long code = DwarfInfoReader.read_unsigned_leb128(in);
                if (code != 0L) {
                    DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(new Long(code));
                    if (entry == null) {
                        assert (false);
                        continue;
                    }
                    if (entry.hasChildren) {
                        nestingStack.push(this.currentParentScope);
                    }
                    if (this.isDebugInfoEntryWithAddressRange(entry.tag)) {
                        DwarfDebugInfoProvider.AttributeList attributeList = new DwarfDebugInfoProvider.AttributeList(entry, in, header.addressSize, this.getDebugStrings());
                        this.processDebugInfoEntry(offset, entry, attributeList, header);
                        switch (entry.tag) {
                            case 11: 
                            case 29: 
                            case 46: {
                                if (!entry.hasChildren || this.provider.scopesByOffset.get(offset) != null) continue block8;
                                int nesting = 1;
                                while (nesting > 0 && in.remaining() > 0L) {
                                    offset = in.position() + (long)this.currentCUHeader.debugInfoOffset;
                                    code = DwarfInfoReader.read_unsigned_leb128(in);
                                    if (code != 0L) {
                                        entry = abbrevs.get(new Long(code));
                                        if (entry == null) {
                                            assert (false);
                                            continue;
                                        }
                                        if (entry.hasChildren) {
                                            ++nesting;
                                        }
                                        DwarfDebugInfoProvider.AttributeList.skipAttributes(entry, in, header.addressSize);
                                        continue;
                                    }
                                    --nesting;
                                }
                                if (nestingStack.isEmpty()) {
                                    this.currentParentScope = null;
                                    break;
                                }
                                this.currentParentScope = nestingStack.pop();
                            }
                        }
                        continue;
                    }
                    DwarfDebugInfoProvider.AttributeList.skipAttributes(entry, in, header.addressSize);
                    continue;
                }
                if (code != 0L) continue;
                this.currentParentScope = nestingStack.isEmpty() ? null : nestingStack.pop();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void parseForTypes(IStreamBuffer in, Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs, DwarfDebugInfoProvider.CompilationUnitHeader header, Stack<Scope> nestingStack) throws IOException {
        if (EDCTrace.SYMBOL_READER_TRACE_ON) {
            EDCTrace.getTrace().trace(null, EDCTrace.fixArg(String.valueOf(DwarfMessages.DwarfInfoReader_TraceParseTypes1) + header.scope.getName() + DwarfMessages.DwarfInfoReader_TraceParseTypes2 + Long.toHexString(header.debugInfoOffset)));
        }
        Stack<IType> typeStack = new Stack<IType>();
        this.typeToParentMap.clear();
        this.currentParentScope = this.currentCompileUnitScope;
        while (in.remaining() > 0L) {
            long offset = in.position() + (long)this.currentCUHeader.debugInfoOffset;
            long code = DwarfInfoReader.read_unsigned_leb128(in);
            if (code != 0L) {
                DwarfDebugInfoProvider.AbbreviationEntry entry = abbrevs.get(new Long(code));
                if (entry == null) {
                    assert (false);
                    continue;
                }
                if (entry.hasChildren) {
                    nestingStack.push(this.currentParentScope);
                    typeStack.push(this.currentParentType);
                }
                if (this.isForwardTypeTag(entry.tag) || this.isForwardTypeChildTag(entry.tag)) {
                    this.processDebugInfoEntry(offset, entry, new DwarfDebugInfoProvider.AttributeList(entry, in, header.addressSize, this.getDebugStrings()), header);
                    continue;
                }
                switch (entry.tag) {
                    case 11: 
                    case 29: 
                    case 46: {
                        Scope scope = this.provider.scopesByOffset.get(offset);
                        if (scope == null) break;
                        this.currentParentScope = scope;
                    }
                }
                DwarfDebugInfoProvider.AttributeList.skipAttributes(entry, in, header.addressSize);
                continue;
            }
            if (nestingStack.isEmpty()) {
                this.currentParentType = null;
                this.currentParentScope = null;
                continue;
            }
            this.currentParentScope = nestingStack.pop();
            this.currentParentType = (IType)typeStack.pop();
        }
    }

    private boolean isForwardTypeTag(short tag) {
        switch (tag) {
            case 1: 
            case 2: 
            case 4: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 47: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private boolean isForwardTypeChildTag(short tag) {
        switch (tag) {
            case 13: 
            case 28: 
            case 33: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private void processDebugInfoEntry(long offset, DwarfDebugInfoProvider.AbbreviationEntry entry, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        short tag = entry.tag;
        switch (tag) {
            case 1: {
                this.processArrayType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 2: {
                this.processClassType(offset, attributeList, header, entry.hasChildren);
                break;
            }
            case 4: {
                this.processEnumType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 5: {
                this.processVariable(offset, attributeList, true);
                break;
            }
            case 11: {
                this.processLexicalBlock(offset, attributeList, entry.hasChildren);
                break;
            }
            case 13: {
                this.processField(offset, attributeList, header, entry.hasChildren);
                break;
            }
            case 15: {
                this.processPointerType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 16: {
                this.processReferenceType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 19: {
                this.processStructType(offset, attributeList, header, entry.hasChildren);
                break;
            }
            case 21: {
                this.processSubroutineType(offset, attributeList, header, entry.hasChildren);
                break;
            }
            case 22: {
                this.processTypeDef(offset, attributeList, entry.hasChildren);
                break;
            }
            case 23: {
                this.processUnionType(offset, attributeList, header, entry.hasChildren);
                break;
            }
            case 24: {
                break;
            }
            case 28: {
                this.processInheritance(offset, attributeList, header, entry.hasChildren);
                break;
            }
            case 31: {
                this.processPtrToMemberType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 34: {
                break;
            }
            case 36: {
                this.processBasicType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                this.processConstType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 40: {
                this.processEnumerator(offset, attributeList);
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 46: {
                this.processSubprogram(offset, attributeList, entry.hasChildren);
                break;
            }
            case 29: {
                this.processInlinedSubroutine(offset, attributeList, entry.hasChildren);
                break;
            }
            case 47: {
                this.processTemplateTypeParam(offset, attributeList, header, entry.hasChildren);
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                break;
            }
            case 52: {
                this.processVariable(offset, attributeList, false);
                break;
            }
            case 53: {
                this.processVolatileType(offset, attributeList, entry.hasChildren);
                break;
            }
            case 33: {
                this.processArrayBoundType(offset, attributeList, entry.hasChildren);
            }
        }
    }

    private boolean isDebugInfoEntryWithAddressRange(short tag) {
        switch (tag) {
            case 11: 
            case 29: 
            case 30: 
            case 34: 
            case 37: 
            case 46: 
            case 50: 
            case 60: {
                return true;
            }
            case 5: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    static long readAddress(IStreamBuffer in, int addressSize) throws IOException {
        long value = 0L;
        switch (addressSize) {
            case 2: {
                value = in.getShort();
                break;
            }
            case 4: {
                value = in.getInt();
                break;
            }
            case 8: {
                value = in.getLong();
            }
        }
        return value;
    }

    static long read_unsigned_leb128(IStreamBuffer in) throws IOException {
        long result = 0L;
        int shift = 0;
        while (in.hasRemaining()) {
            byte b = in.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    public static long read_signed_leb128(IStreamBuffer in) throws IOException {
        byte b;
        long result = 0L;
        int shift = 0;
        int size = 32;
        do {
            if (!in.hasRemaining()) {
                throw new IOException(CCorePlugin.getResourceString((String)"Util.exception.noData"));
            }
            b = in.get();
            result |= (long)(b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        if (shift < size && (b & 0x40) != 0) {
            result |= (long)(-(1 << shift));
        }
        return result;
    }

    public static String readString(IStreamBuffer data) {
        StringBuilder sb = new StringBuilder();
        while (data.hasRemaining()) {
            byte c = data.get();
            if (c == 0) break;
            sb.append((char)c);
        }
        String str = sb.toString();
        return str;
    }

    private Collection<LocationEntry> getLocationRecord(long offset) {
        Collection<LocationEntry> entries = this.locationEntriesByOffset.get(offset);
        if (entries == null) {
            TreeMap<IRangeList.Entry, LocationEntry> entryMap = new TreeMap<IRangeList.Entry, LocationEntry>();
            try {
                IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_LOC);
                if (data != null) {
                    data.position(offset);
                    boolean first = true;
                    long base = 0L;
                    while (data.hasRemaining()) {
                        long lowPC = DwarfInfoReader.readAddress(data, this.currentCUHeader.addressSize);
                        long highPC = DwarfInfoReader.readAddress(data, this.currentCUHeader.addressSize);
                        if (lowPC == 0L && highPC == 0L) break;
                        if (first) {
                            long maxaddress;
                            first = false;
                            long l = maxaddress = this.currentCUHeader.addressSize == 4 ? Integer.MAX_VALUE : Long.MAX_VALUE;
                            if (lowPC == maxaddress) {
                                base = highPC;
                                continue;
                            }
                            if (this.currentCompileUnitScope.getRangeList() == null) {
                                base = this.currentCompileUnitScope.getLowAddress().getValue().longValue();
                            }
                        }
                        short numOpCodes = data.getShort();
                        byte[] bytes = new byte[numOpCodes];
                        data.get(bytes);
                        LocationEntry entry = new LocationEntry(lowPC + base, highPC + base, bytes);
                        entryMap.put(new IRangeList.Entry(lowPC + base, highPC + base), entry);
                    }
                    entries = entryMap.values();
                    this.locationEntriesByOffset.put(offset, entries);
                }
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError(null, t);
            }
        }
        return entries;
    }

    private Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> parseDebugAbbreviation(int abbreviationOffset) throws IOException {
        Integer key = abbreviationOffset;
        Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.provider.abbreviationMaps.get(key);
        if (abbrevs == null) {
            abbrevs = new HashMap<Long, DwarfDebugInfoProvider.AbbreviationEntry>();
            this.provider.abbreviationMaps.put(key, abbrevs);
            IStreamBuffer data = this.getDwarfSection(DWARF_DEBUG_ABBREV);
            if (data != null) {
                data.position(abbreviationOffset);
                while (data.remaining() > 0L) {
                    long code = DwarfInfoReader.read_unsigned_leb128(data);
                    if (code == 0L) break;
                    short tag = (short)DwarfInfoReader.read_unsigned_leb128(data);
                    boolean hasChildren = data.get() == 1;
                    DwarfDebugInfoProvider.AbbreviationEntry entry = new DwarfDebugInfoProvider.AbbreviationEntry(code, tag, hasChildren);
                    short name = 0;
                    byte form = 0;
                    do {
                        name = (short)DwarfInfoReader.read_unsigned_leb128(data);
                        form = (byte)DwarfInfoReader.read_unsigned_leb128(data);
                        if (name == 0) continue;
                        entry.attributes.add(new DwarfDebugInfoProvider.Attribute(name, form));
                    } while (name != 0 && form != 0);
                    entry.attributes.trimToSize();
                    abbrevs.put(code, entry);
                }
            }
        }
        return abbrevs;
    }

    private void registerType(long offset, IType type, boolean hasChildren) {
        this.provider.typesByOffset.put(offset, type);
        this.typeToParentMap.put(type, this.currentParentType);
        if (hasChildren) {
            this.currentParentType = type;
        }
        if (DEBUG && type != null) {
            System.out.print(String.valueOf(DwarfMessages.DwarfInfoReader_ReadType) + type.getName());
            while (type.getType() != null) {
                type = type.getType();
                System.out.print(" " + type.getName());
            }
            System.out.println();
        }
    }

    private void registerScope(long offset, Scope scope) {
        this.provider.scopesByOffset.put(offset, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeList readRangeList(int offset, DwarfDebugInfoProvider.AttributeValue baseValue) {
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            IStreamBuffer data;
            block13: {
                data = this.getDwarfSection(DWARF_DEBUG_RANGES);
                if (data != null) break block13;
                return null;
            }
            try {
                data.position(offset);
                RangeList list = new RangeList();
                long base = 0L;
                long start = data.getInt();
                long end = data.getInt();
                if (start == -1L) {
                    base = end;
                    start = data.getInt();
                    end = data.getInt();
                } else if (baseValue != null) {
                    base = baseValue.getValueAsLong();
                } else if (this.currentCompileUnitScope != null && this.currentCompileUnitScope.getRangeList() == null) {
                    base = this.currentCompileUnitScope.getLowAddress().getValue().longValue();
                }
                while (start != 0L || end != 0L) {
                    if (start != end && base + start >= this.codeRanges.getLowAddress()) {
                        list.addRange(base + start, base + end);
                    }
                    start = data.getInt();
                    end = data.getInt();
                }
                return list;
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError(DwarfMessages.DwarfInfoReader_RangeReadFailed, t);
                return null;
            }
        }
    }

    private void setupAddresses(DwarfDebugInfoProvider.AttributeList attributeList, Scope scope) {
        DwarfDebugInfoProvider.AttributeValue value = attributeList.getAttribute((short)18);
        if (value != null) {
            Addr32 low = new Addr32(attributeList.getAttributeValueAsLong((short)17));
            scope.setLowAddress((IAddress)low);
            Addr32 high = new Addr32(attributeList.getAttributeValueAsLong((short)18));
            IScope parent = scope.getParent();
            if (low.compareTo((Object)high) <= 0) {
                IAddress parentHigh;
                if (parent instanceof DwarfFunctionScope && (parentHigh = parent.getHighAddress()) != null && high.compareTo((Object)parentHigh) > 0) {
                    ((Scope)parent).setHighAddress((IAddress)high);
                }
            } else {
                if (scope instanceof DwarfFunctionScope && parent instanceof DwarfFunctionScope) {
                    high = this.fix_Dwarf_InlineHighAddress_Problem(scope);
                    if (high == null) {
                        high = parent.getHighAddress();
                    }
                } else if (parent != null && parent.getHighAddress() != null) {
                    high = parent.getHighAddress();
                }
                if (low.compareTo((Object)high) > 0) {
                    scope.setLowAddress((IAddress)high);
                    high = low;
                }
            }
            scope.setHighAddress((IAddress)high);
            return;
        }
        value = attributeList.getAttribute((short)85);
        if (value != null) {
            DwarfDebugInfoProvider.AttributeValue baseValue = attributeList.getAttribute((short)17);
            RangeList ranges = this.readRangeList(value.getValueAsInt(), baseValue);
            if (ranges != null) {
                scope.setRangeList(ranges);
                if (ranges.getLowAddress() < scope.getParent().getLowAddress().getValue().longValue() && scope.getParent() instanceof Scope) {
                    ((Scope)scope.getParent()).setLowAddress((IAddress)new Addr32(ranges.getLowAddress()));
                }
                if (ranges.getHighAddress() > scope.getParent().getHighAddress().getValue().longValue() && scope.getParent() instanceof Scope) {
                    ((Scope)scope.getParent()).setHighAddress((IAddress)new Addr32(ranges.getHighAddress()));
                }
                return;
            }
        }
        if (scope instanceof ICompileUnitScope && (value = attributeList.getAttribute((short)16)) != null) {
            RangeList ranges = new RangeList();
            for (ILineEntry entry : ((ICompileUnitScope)((Object)scope)).getLineEntries()) {
                if (entry.getLowAddress().getValue().longValue() < this.codeRanges.getLowAddress()) continue;
                ranges.addRange(entry.getLowAddress().getValue().longValue(), entry.getHighAddress().getValue().longValue());
            }
            scope.setRangeList(ranges);
            return;
        }
        scope.setLowAddress((IAddress)new Addr32(0L));
        scope.setHighAddress((IAddress)new Addr32(0L));
    }

    private IAddress fix_Dwarf_InlineHighAddress_Problem(Scope scope) {
        int actualLine;
        ILineEntry entry;
        IAddress low = scope.getLowAddress();
        IAddress highest = scope.getParent().getHighAddress();
        Iterator<ILineEntry> lineEntries = this.currentCompileUnitScope.getLineEntries().iterator();
        do {
            if ((entry = lineEntries.next()) != null) continue;
            return null;
        } while (low.compareTo((Object)entry.getHighAddress()) > 0);
        IAddress high = null;
        IPath actualPath = entry.getFilePath();
        IPath otherPath = null;
        int thisLine = actualLine = entry.getLineNumber();
        int lastLine = 0;
        boolean jumpedBack = false;
        boolean jumpedAway = false;
        block1: while (true) {
            IAddress nextHigh = entry.getHighAddress();
            if (highest != null && nextHigh != null && highest.compareTo((Object)nextHigh) < 0) {
                nextHigh = entry.getLowAddress();
                if (high != null && nextHigh.compareTo((Object)high) >= 0) break;
                high = nextHigh;
                break;
            }
            high = nextHigh;
            if (!jumpedAway && otherPath == null) {
                lastLine = thisLine;
            }
            if (high == null) break;
            while ((entry = lineEntries.next()) != null) {
                if (high.equals((Object)entry.getHighAddress())) continue;
                if (otherPath != null) {
                    if (!entry.getFilePath().equals((Object)actualPath)) continue block1;
                    break block1;
                }
                if (!entry.getFilePath().equals((Object)actualPath)) {
                    otherPath = entry.getFilePath();
                    continue block1;
                }
                thisLine = entry.getLineNumber();
                if (!jumpedBack && !jumpedAway) {
                    if (thisLine < actualLine) {
                        jumpedBack = true;
                        continue block1;
                    }
                    if (thisLine <= lastLine + 24) continue block1;
                    jumpedAway = true;
                    continue block1;
                }
                if (!jumpedBack ? jumpedAway && (thisLine < actualLine || thisLine < lastLine || thisLine > lastLine + 24) : thisLine > actualLine) break block1;
                if (entry != null) continue block1;
            }
            break;
        }
        return high;
    }

    private void processCompileUnit(DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren, DwarfDebugInfoProvider.AttributeList attributeList) {
        String name = attributeList.getAttributeValueAsString((short)3);
        String compDir = attributeList.getAttributeValueAsString((short)27);
        IPath filePath = this.fileHelper.normalizeFilePath(compDir, name);
        header.scope = this.currentCompileUnitScope = new DwarfCompileUnit(this.provider, this.moduleScope, filePath, null, null, header, hasChildren, attributeList);
        this.currentParentScope = this.currentCompileUnitScope;
        this.setupAddresses(attributeList, this.currentCompileUnitScope);
        List<ICompileUnitScope> matchingCompileUnits = this.provider.compileUnitsPerFile.get(filePath);
        if (matchingCompileUnits == null) {
            matchingCompileUnits = new ArrayList<ICompileUnitScope>();
        }
        matchingCompileUnits.add(this.currentCompileUnitScope);
        this.provider.compileUnitsPerFile.put(filePath, matchingCompileUnits);
        this.provider.compileUnits.add(this.currentCompileUnitScope);
        if (!this.currentCompileUnitScope.getHighAddress().isZero()) {
            this.provider.sortedCompileUnitsWithCode.add(this.currentCompileUnitScope);
        }
        this.moduleScope.addChild(this.currentCompileUnitScope);
        this.provider.registerCompileUnitHeader(this.currentCUHeader.debugInfoOffset, this.currentCUHeader);
        if (this.provider.buildReferencedFilesList) {
            this.provider.referencedFiles.add(filePath.toOSString());
            DwarfDebugInfoProvider.AttributeValue a = attributeList.getAttribute((short)16);
            if (a != null) {
                int stmtList = a.getValueAsInt();
                this.quickParseLineInfo(stmtList, compDir);
            }
        }
        attributeList.attributeMap.remove((short)3);
        attributeList.attributeMap.remove((short)17);
        attributeList.attributeMap.remove((short)18);
        attributeList.attributeMap.remove((short)85);
    }

    private void processLexicalBlock(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        String name = attributeList.getAttributeValueAsString((short)3);
        if (!attributeList.hasCodeRangeAttributes()) {
            return;
        }
        LexicalBlockScope lb = new LexicalBlockScope(name, this.currentParentScope, null, null);
        this.setupAddresses(attributeList, lb);
        this.currentParentScope.addChild(lb);
        this.registerScope(offset, lb);
        if (hasChildren) {
            this.currentParentScope = lb;
        }
    }

    private DereferencedAttributes getDereferencedAttributes(DwarfDebugInfoProvider.AttributeList attributeList, short tag) {
        DwarfDebugInfoProvider.AttributeList attributes;
        DwarfDebugInfoProvider.CompilationUnitHeader providingCU = this.currentCUHeader;
        DwarfDebugInfoProvider.AttributeValue derefLocation = attributeList.getAttribute(tag);
        if (derefLocation == null) {
            return null;
        }
        long debugInfoOffset = derefLocation.getValueAsLong();
        if (derefLocation.getActualForm() != 16) {
            debugInfoOffset += (long)providingCU.debugInfoOffset;
        }
        if ((attributes = this.provider.functionsByOffset.get(debugInfoOffset)) == null) {
            IStreamBuffer buffer;
            providingCU = this.provider.fetchCompileUnitHeader(debugInfoOffset);
            attributes = this.provider.functionsByOffset.get(debugInfoOffset);
            if (attributes == null && (buffer = this.getDwarfSection(DWARF_DEBUG_INFO)) != null) {
                buffer.position(debugInfoOffset);
                try {
                    DwarfDebugInfoProvider.AbbreviationEntry entry;
                    Map<Long, DwarfDebugInfoProvider.AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(providingCU.abbreviationOffset);
                    long code = DwarfInfoReader.read_unsigned_leb128(buffer);
                    if (code != 0L && (entry = abbrevs.get(new Long(code))) != null) {
                        attributes = new DwarfDebugInfoProvider.AttributeList(entry, buffer, providingCU.addressSize, this.getDebugStrings());
                    }
                }
                catch (Throwable t) {
                    EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfInfoReader_ParseDebugInfoSectionFailed1) + this.debugInfoSection.getName() + DwarfMessages.DwarfInfoReader_ParseDebugInfoSectionFailed2 + this.symbolFilePath, t);
                }
            }
        } else {
            providingCU = this.provider.fetchCompileUnitHeader(debugInfoOffset);
            if (providingCU == null) {
                assert (false);
                return null;
            }
        }
        if (attributes == null) {
            return null;
        }
        return new DereferencedAttributes(providingCU, attributes);
    }

    private void processSubprogram(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        DwarfDebugInfoProvider.AttributeList attributes;
        DereferencedAttributes deref;
        if (attributeList.getAttributeValueAsInt((short)60) > 0) {
            this.provider.functionsByOffset.put(offset, attributeList);
            return;
        }
        if (!attributeList.hasCodeRangeAttributes()) {
            this.provider.functionsByOffset.put(offset, attributeList);
            return;
        }
        DwarfDebugInfoProvider.CompilationUnitHeader otherCU = null;
        boolean isArtificial = attributeList.getAttributeValueAsInt((short)52) > 0;
        String name = attributeList.getAttributeValueAsString((short)3);
        if (name.length() == 0 && (deref = this.getDereferencedAttributes(attributeList, (short)49)) != null) {
            otherCU = deref.header;
            attributes = deref.attributeList;
            name = attributes.getAttributeValueAsString((short)3);
            isArtificial |= attributes.getAttributeValueAsInt((short)52) > 0;
            if (name.length() == 0 && (deref = this.getDereferencedAttributes(attributes, (short)71)) != null) {
                otherCU = deref.header;
                attributes = deref.attributeList;
                name = attributes.getAttributeValueAsString((short)3);
                isArtificial |= attributes.getAttributeValueAsInt((short)52) > 0;
            }
        }
        if (name.length() == 0 && (deref = this.getDereferencedAttributes(attributeList, (short)71)) != null) {
            otherCU = deref.header;
            attributes = deref.attributeList;
            name = attributes.getAttributeValueAsString((short)3);
        }
        if (name.length() == 0) {
            EDCDebugger.getMessageLogger().logError(String.valueOf(DwarfMessages.DwarfInfoReader_SubprogramNameNotFound1) + Long.toHexString(offset) + DwarfMessages.DwarfInfoReader_SubprogramNameNotFound2, null);
            return;
        }
        DwarfFunctionScope function = new DwarfFunctionScope(name, this.currentCompileUnitScope, null, null, null);
        this.setupAddresses(attributeList, function);
        Scope originalParentScope = this.currentParentScope;
        this.registerScope(offset, function);
        this.currentParentScope = function;
        DwarfDebugInfoProvider.AttributeValue frameBaseAttribute = attributeList.getAttribute((short)64);
        ILocationProvider locationProvider = this.getLocationProvider(frameBaseAttribute);
        function.setLocationProvider(locationProvider);
        if (!(function.getLowAddress().isZero() || function.getHighAddress().isZero() || isArtificial)) {
            int declLine = attributeList.getAttributeValueAsInt((short)59);
            int declColumn = attributeList.getAttributeValueAsInt((short)57);
            int declFileNum = attributeList.getAttributeValueAsInt((short)58);
            if (otherCU != null) {
                function.setDeclFile(otherCU.scope.getFileEntry(declFileNum));
            } else {
                function.setDeclFileNum(declFileNum);
            }
            function.setDeclLine(declLine);
            function.setDeclColumn(declColumn);
            this.currentCompileUnitScope.addChild(function);
            List<IFunctionScope> functions = this.provider.functionsByName.get(name);
            if (functions == null) {
                functions = new ArrayList<IFunctionScope>();
                this.provider.functionsByName.put(name, functions);
            }
            functions.add(function);
        }
        if (!hasChildren) {
            this.currentParentScope = originalParentScope;
        }
    }

    private IType getTypeOrReference(DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        DwarfDebugInfoProvider.AttributeValue typeAttribute = attributeList.getAttribute((short)73);
        if (typeAttribute == null) {
            return null;
        }
        return this.getTypeOrReference(typeAttribute, header);
    }

    private IType getTypeOrReference(DwarfDebugInfoProvider.AttributeValue typeAttribute, DwarfDebugInfoProvider.CompilationUnitHeader header) {
        IType type;
        if (typeAttribute == null) {
            return null;
        }
        long debugInfoOffset = typeAttribute.getValueAsLong();
        if (typeAttribute.getActualForm() != 16) {
            debugInfoOffset += (long)header.debugInfoOffset;
        }
        if ((type = this.provider.typesByOffset.get(debugInfoOffset)) == null) {
            type = new DwarfDebugInfoProvider.ForwardTypeReference(this.provider, debugInfoOffset);
        }
        return type;
    }

    private void processInlinedSubroutine(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        List<IFunctionScope> functions;
        if (!attributeList.hasCodeRangeAttributes()) {
            return;
        }
        DereferencedAttributes deref = this.getDereferencedAttributes(attributeList, (short)49);
        if (deref == null) {
            if (attributeList.getAttribute((short)49) == null) assert (false);
            return;
        }
        DwarfDebugInfoProvider.CompilationUnitHeader otherCU = deref.header;
        DwarfDebugInfoProvider.AttributeList origAttributes = deref.attributeList;
        String name = origAttributes.getAttributeValueAsString((short)3);
        if (name.length() == 0 && (deref = this.getDereferencedAttributes(origAttributes, (short)71)) != null) {
            DwarfDebugInfoProvider.AttributeList declarationAttributes = deref.attributeList;
            name = declarationAttributes.getAttributeValueAsString((short)3);
        }
        if (name.length() == 0) {
            return;
        }
        int declLine = origAttributes.getAttributeValueAsInt((short)59);
        int declColumn = origAttributes.getAttributeValueAsInt((short)57);
        int declFileNum = origAttributes.getAttributeValueAsInt((short)58);
        if (declFileNum == 0) {
            assert (false);
            return;
        }
        DwarfFunctionScope function = new DwarfFunctionScope(name, this.currentParentScope, null, null, null);
        this.setupAddresses(attributeList, function);
        function.setDeclFile(otherCU.scope.getFileEntry(declFileNum));
        function.setDeclLine(declLine);
        function.setDeclColumn(declColumn);
        this.currentParentScope.addChild(function);
        this.registerScope(offset, function);
        if (hasChildren) {
            this.currentParentScope = function;
        }
        if ((functions = this.provider.functionsByName.get(name)) == null) {
            functions = new ArrayList<IFunctionScope>();
            this.provider.functionsByName.put(name, functions);
        }
        functions.add(function);
    }

    private void processSubroutineType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        SubroutineType type = new SubroutineType(this.currentParentScope, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processClassType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren) {
        int templateStart;
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        if ((name = this.unmangleType(name)).endsWith(">") && (templateStart = name.indexOf("<")) != -1) {
            name = name.substring(0, templateStart);
        }
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        ClassType type = new ClassType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processStructType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        String name = attributeList.getAttributeValueAsString((short)3);
        name = this.unmangleType(name);
        StructType type = new StructType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processUnionType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        String name = attributeList.getAttributeValueAsString((short)3);
        name = this.unmangleType(name);
        UnionType type = new UnionType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        boolean isRVCTAnonymousUnion = false;
        try {
            isRVCTAnonymousUnion = name.startsWith("__C") && name.length() > 3 && name.charAt(3) != '-' && Long.parseLong(name.substring(3)) > -1L;
        }
        catch (NumberFormatException numberFormatException) {}
        if (isRVCTAnonymousUnion && this.getCompositeParent(this.typeToParentMap.get(this.currentParentType)) != null) {
            ICompositeType compositeType = this.getCompositeParent(this.typeToParentMap.get(this.currentParentType));
            int accessibility = 0;
            if (compositeType instanceof ClassType) {
                accessibility = 2;
            }
            String fieldName = "$unnamed$" + (compositeType.fieldCount() + 1);
            FieldType fieldType = new FieldType(fieldName, this.currentParentScope, compositeType, -1L, 0, 0, byteSize, accessibility, null);
            fieldType.setType(type);
            compositeType.addField(fieldType);
            this.registerType(offset, fieldType, false);
        }
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processInheritance(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        ICompositeType compositeType = this.getCompositeParent();
        long fieldsOffset = 0L;
        byte[] offsetBlock = attributeList.getAttributeValueAsBytes((short)56);
        if (offsetBlock.length > 0 && offsetBlock[0] == 35) {
            int i = 1;
            int shift = 0;
            while (i < offsetBlock.length) {
                fieldsOffset += (long)((offsetBlock[i] & 0x7F) << shift);
                shift += 7;
                ++i;
            }
        }
        int accessibility = 2;
        if (attributeList.getAttribute((short)50) != null) {
            accessibility = attributeList.getAttributeValueAsInt((short)50);
            accessibility = accessibility == 1 ? 0 : (accessibility == 3 ? 2 : 1);
        }
        InheritanceType type = new InheritanceType(this.currentParentScope, accessibility, fieldsOffset, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        if (compositeType != null) {
            compositeType.addInheritance(type);
        }
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processField(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        name = name.replace('.', '$');
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        int bitSize = attributeList.getAttributeValueAsInt((short)13);
        int bitOffset = attributeList.getAttributeValueAsInt((short)12);
        long fieldOffset = 0L;
        byte[] offsetBlock = attributeList.getAttributeValueAsBytes((short)56);
        if (offsetBlock.length > 0 && offsetBlock[0] == 35) {
            int i = 1;
            int shift = 0;
            while (i < offsetBlock.length) {
                fieldOffset += (long)((offsetBlock[i] & 0x7F) << shift);
                shift += 7;
                ++i;
            }
        }
        ICompositeType compositeType = this.getCompositeParent();
        int accessibility = 0;
        if (attributeList.getAttribute((short)50) != null) {
            accessibility = attributeList.getAttributeValueAsInt((short)50);
            accessibility = accessibility == 1 ? 0 : (accessibility == 3 ? 2 : 1);
        } else if (compositeType != null && compositeType instanceof ClassType) {
            accessibility = 2;
        }
        if (name.length() == 0) {
            name = compositeType != null ? "$unnamed$" + (compositeType.fieldCount() + 1) : "$unnamed$";
        }
        FieldType type = new FieldType(name, this.currentParentScope, compositeType, fieldOffset, bitSize, bitOffset, byteSize, accessibility, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        if (compositeType != null) {
            compositeType.addField(type);
        }
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processTemplateTypeParam(long offset, DwarfDebugInfoProvider.AttributeList attributeList, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        IType paramType = this.getTypeOrReference(attributeList.getAttribute((short)73), this.currentCUHeader);
        TemplateParamType type = new TemplateParamType(name, paramType);
        ICompositeType compositeType = this.getCompositeParent();
        if (compositeType != null) {
            compositeType.addTemplateParam(type);
        }
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private ICompositeType getCompositeParent() {
        return this.getCompositeParent(this.currentParentType);
    }

    private ICompositeType getCompositeParent(IType parent) {
        while (parent != null) {
            if (parent instanceof ICompositeType) {
                return (ICompositeType)parent;
            }
            parent = this.typeToParentMap.get(parent);
        }
        return null;
    }

    private void processArrayType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        ArrayType type = new ArrayType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private IArrayType getArrayParent() {
        IType parent = this.currentParentType;
        while (parent != null) {
            if (parent instanceof IArrayType) {
                return (IArrayType)parent;
            }
            parent = this.typeToParentMap.get(parent);
        }
        return null;
    }

    private void processArrayBoundType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        long arrayBound = 0L;
        if (attributeList.getAttribute((short)47) != null) {
            arrayBound = attributeList.getAttributeValueAsLong((short)47) + 1L;
        }
        ArrayBoundType type = new ArrayBoundType(this.currentParentScope, arrayBound);
        IArrayType array = this.getArrayParent();
        if (array == null) {
            throw new IllegalStateException();
        }
        array.addBound(type);
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processReferenceType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        if (byteSize == 0) {
            byteSize = this.currentCUHeader.addressSize;
        }
        ReferenceType type = new ReferenceType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processPointerType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        if (byteSize == 0) {
            byteSize = this.currentCUHeader.addressSize;
        }
        PointerType type = new PointerType(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReferenceOrVoid(attributeList));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processPtrToMemberType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        String name;
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        if ((name = attributeList.getAttributeValueAsString((short)3)).length() == 0) {
            name = "" + offset;
        }
        PointerType type = new PointerType(name, this.currentParentScope, this.currentCUHeader.addressSize, null);
        type.setType(this.getTypeOrReferenceOrVoid(attributeList));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processConstType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        ConstType type = new ConstType(this.currentParentScope, null);
        type.setType(this.getTypeOrReferenceOrVoid(attributeList));
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processVolatileType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        VolatileType type = new VolatileType(this.currentParentScope, null);
        type.setType(this.getTypeOrReferenceOrVoid(attributeList));
        this.registerType(offset, type, hasChildren);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private IType getTypeOrReferenceOrVoid(DwarfDebugInfoProvider.AttributeList attributeList) {
        IType typeOrReference = this.getTypeOrReference(attributeList, this.currentCUHeader);
        if (typeOrReference != null) {
            return typeOrReference;
        }
        if (this.moduleScope != null && this.voidType == null) {
            this.voidType = new CPPBasicType("void", this.moduleScope, 1, 0, 0, null);
        }
        if (this.voidType != null) {
            return this.voidType;
        }
        return new CPPBasicType("void", this.currentParentScope, 1, 0, 0, null);
    }

    private void processEnumType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        name = this.unmangleType(name);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        Enumeration type = new Enumeration(name, this.currentParentScope, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private Enumeration getEnumerationParent() {
        IType parent = this.currentParentType;
        while (parent != null) {
            if (parent instanceof Enumeration) {
                return (Enumeration)parent;
            }
            parent = this.typeToParentMap.get(parent);
        }
        return null;
    }

    private void processEnumerator(long offset, DwarfDebugInfoProvider.AttributeList attributeList) {
        String name;
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        if (this.unmangler.isMangled(name = attributeList.getAttributeValueAsString((short)3))) {
            try {
                name = this.unmangler.unmangle(name);
            }
            catch (UnmanglingException unmanglingException) {}
        }
        long value = attributeList.getAttributeValueAsSignedLong((short)28);
        Enumerator enumerator = new Enumerator(name, value);
        Enumeration enumeration = this.getEnumerationParent();
        if (enumeration == null) {
            throw new IllegalStateException();
        }
        enumeration.addEnumerator(enumerator);
        ((Scope)enumeration.getScope()).addEnumerator(enumerator);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(enumerator));
        }
    }

    private void processTypeDef(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        name = this.unmangleType(name);
        TypedefType type = new TypedefType(name, this.currentParentScope, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processBasicType(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean hasChildren) {
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(offset));
        }
        String name = attributeList.getAttributeValueAsString((short)3);
        int byteSize = attributeList.getAttributeValueAsInt((short)11);
        int baseType = 0;
        int qualifierBits = 0;
        int encoding = attributeList.getAttributeValueAsInt((short)62);
        switch (encoding) {
            case 2: {
                baseType = 6;
                break;
            }
            case 4: {
                if (name.contains("float")) {
                    baseType = 4;
                    break;
                }
                if (name.contains("long double")) {
                    baseType = 5;
                    qualifierBits |= 1;
                    break;
                }
                if (!name.contains("double")) break;
                baseType = 5;
                break;
            }
            case 5: {
                baseType = 3;
                qualifierBits |= 4;
                if (name.contains("short")) {
                    qualifierBits |= 2;
                    break;
                }
                if (name.contains("long long")) {
                    qualifierBits |= 0x40;
                    break;
                }
                if (!name.contains("long")) break;
                qualifierBits |= 1;
                break;
            }
            case 6: {
                baseType = 2;
                qualifierBits |= 4;
                break;
            }
            case 7: {
                baseType = 3;
                qualifierBits |= 8;
                if (name.contains("short")) {
                    qualifierBits |= 2;
                    break;
                }
                if (name.contains("long long")) {
                    qualifierBits |= 0x40;
                    break;
                }
                if (!name.contains("long")) break;
                qualifierBits |= 1;
                break;
            }
            case 8: {
                baseType = 2;
                qualifierBits |= 8;
                break;
            }
            case 3: {
                qualifierBits |= 0x10;
                if (name.contains("float")) {
                    baseType = 4;
                    break;
                }
                if (name.contains("long double")) {
                    baseType = 5;
                    qualifierBits |= 1;
                    break;
                }
                if (!name.contains("double")) break;
                baseType = 5;
                break;
            }
            case 9: {
                qualifierBits |= 0x20;
                if (name.contains("float")) {
                    baseType = 4;
                    break;
                }
                if (name.contains("long double")) {
                    baseType = 5;
                    qualifierBits |= 1;
                    break;
                }
                if (!name.contains("double")) break;
                baseType = 5;
                break;
            }
            case 0: {
                baseType = 1;
                break;
            }
        }
        if (name.equals("void") && byteSize == 0) {
            baseType = 1;
        }
        CPPBasicType type = new CPPBasicType(name, this.currentParentScope, baseType, qualifierBits, byteSize, null);
        type.setType(this.getTypeOrReference(attributeList, this.currentCUHeader));
        this.registerType(offset, type, hasChildren);
        this.storeTypeByName(name, type);
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(type));
        }
    }

    private void processVariable(long offset, DwarfDebugInfoProvider.AttributeList attributeList, boolean isParameter) {
        String mangledName;
        boolean global;
        DwarfDebugInfoProvider.AttributeValue locationAttribute;
        ILocationProvider locationProvider;
        if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(attributeList));
        }
        if ((locationProvider = this.getLocationProvider(locationAttribute = attributeList.getAttribute((short)2))) == null) {
            this.provider.functionsByOffset.put(offset, attributeList);
            return;
        }
        DwarfDebugInfoProvider.CompilationUnitHeader otherCU = this.currentCUHeader;
        DwarfDebugInfoProvider.AttributeList otherAttributes = attributeList;
        String name = attributeList.getAttributeValueAsString((short)3);
        if (name.length() == 0) {
            DereferencedAttributes deref = this.getDereferencedAttributes(attributeList, (short)71);
            if (deref == null) {
                deref = this.getDereferencedAttributes(attributeList, (short)49);
            }
            if (deref != null) {
                otherCU = deref.header;
                otherAttributes = deref.attributeList;
                name = otherAttributes.getAttributeValueAsString((short)3);
            }
        }
        boolean bl = global = otherAttributes.getAttributeValueAsInt((short)63) == 1;
        if (name.startsWith("_Z")) {
            name = this.unmangle(name);
        } else if (global && this.unmangler.isMangled(mangledName = otherAttributes.getAttributeValueAsString((short)8199))) {
            try {
                name = this.unmangler.unmangle(mangledName);
            }
            catch (UnmanglingException unmanglingException) {}
        }
        IType type = this.getTypeOrReference(otherAttributes.getAttribute((short)73), otherCU);
        if (type != null) {
            long startScope = attributeList.getAttributeValueAsLong((short)44);
            boolean isDeclared = otherAttributes.getAttributeValueAsInt((short)52) <= 0;
            int definingFileNum = otherAttributes.getAttributeValueAsInt((short)58);
            if (definingFileNum > 0 && attributeList.getAttributeValueAsInt((short)60) > 0) {
                definingFileNum = 0;
            }
            IPath definingFile = null;
            if (definingFileNum > 0) {
                IScope cuScope = this.currentParentScope;
                while (cuScope != null && !(cuScope instanceof DwarfCompileUnit)) {
                    cuScope = cuScope.getParent();
                }
                if (cuScope != null) {
                    definingFile = ((DwarfCompileUnit)cuScope).getFileEntry(definingFileNum);
                }
            }
            DwarfVariable variable = new DwarfVariable(name, (IScope)(global ? this.moduleScope : this.currentParentScope), locationProvider, type, isDeclared, definingFile);
            variable.setStartScope(startScope);
            if (isParameter) {
                if (this.currentParentScope instanceof FunctionScope) {
                    ((FunctionScope)this.currentParentScope).addParameter(variable);
                } else assert (false);
            } else {
                List<IVariable> variables;
                if (global) {
                    this.moduleScope.addVariable(variable);
                    if (this.currentCompileUnitScope != null) {
                        this.currentCompileUnitScope.addVariable(variable);
                    }
                } else {
                    this.currentParentScope.addVariable(variable);
                }
                if ((variables = this.provider.variablesByName.get(name)) == null) {
                    variables = new ArrayList<IVariable>();
                    this.provider.variablesByName.put(name, variables);
                }
                variables.add(variable);
            }
            if (EDCTrace.SYMBOL_READER_VERBOSE_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(variable));
            }
        }
    }

    private ILocationProvider getLocationProvider(DwarfDebugInfoProvider.AttributeValue locationValue) {
        if (locationValue != null) {
            byte actualForm = locationValue.getActualForm();
            if (actualForm == 6) {
                Collection<LocationEntry> entryList = this.getLocationRecord(locationValue.getValueAsLong());
                if (entryList != null) {
                    return new LocationList(entryList.toArray(new LocationEntry[entryList.size()]), this.exeReader.getByteOrder(), this.currentCUHeader.addressSize, this.currentParentScope);
                }
            } else {
                if (actualForm == 9 || actualForm == 10 || actualForm == 3 || actualForm == 4) {
                    MemoryStreamBuffer locationData = new MemoryStreamBuffer(locationValue.getValueAsBytes(), this.exeReader.getByteOrder());
                    return new LocationExpression(locationData, this.currentCUHeader.addressSize, this.currentParentScope);
                }
                assert (false);
            }
        }
        return null;
    }

    private void dumpSymbols() {
        if (DEBUG) {
            PrintStream out = null;
            try {
                out = new PrintStream(new File(dumpFileName));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(String.valueOf(DwarfMessages.DwarfInfoReader_DumpFileOpenOrCreateFailed) + dumpFileName);
                return;
            }
            out.println("Module - " + this.symbolFilePath);
            out.println("\tVariables - " + this.moduleScope.getVariables().size());
            out.println("\tCompile units - " + this.moduleScope.getChildren().size());
            out.println();
            for (IScope cu : this.moduleScope.getChildren()) {
                out.println("\tCompile unit - " + cu.toString());
                out.println("\t\tVariables - " + cu.getVariables().size());
                out.println("\t\tFunctions - " + cu.getChildren().size());
                out.println();
                for (IScope func : cu.getChildren()) {
                    out.println("\t\tFunction - " + func.toString());
                    out.println("\t\t\tVariables - " + func.getVariables().size());
                    out.println("\t\t\tParameters - " + ((IFunctionScope)func).getParameters().size());
                    out.println("\t\t\tLexical blocks - " + func.getChildren().size());
                    out.println();
                    for (IScope block : func.getChildren()) {
                        out.println("\t\t\tLexical block - " + block.toString());
                        out.println("\t\t\t\tVariables - " + block.getVariables().size());
                        out.println();
                    }
                }
            }
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseForFrameIndices() {
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            if (!this.provider.frameDescEntries.isEmpty()) {
                return;
            }
            IExecutableSection frameSection = this.exeReader.findExecutableSection(DWARF_DEBUG_FRAME);
            if (frameSection == null) {
                return;
            }
            IStreamBuffer buffer = frameSection.getBuffer();
            buffer.position(0L);
            int addressSize = 4;
            long cie_id = addressSize == 4 ? -1L : -1L;
            while (buffer.position() < buffer.capacity()) {
                try {
                    long fdePtr = buffer.position();
                    long headerLength = DwarfInfoReader.readAddress(buffer, addressSize);
                    long nextPosition = buffer.position() + headerLength;
                    long ciePtr = DwarfInfoReader.readAddress(buffer, addressSize);
                    if (ciePtr != cie_id) {
                        long initialLocation = DwarfInfoReader.readAddress(buffer, addressSize);
                        long addressRange = DwarfInfoReader.readAddress(buffer, addressSize);
                        IStreamBuffer instructions = buffer.wrapSubsection(nextPosition - buffer.position());
                        IRangeList.Entry entry = new IRangeList.Entry(initialLocation, initialLocation + addressRange);
                        DwarfFrameRegisterProvider.FrameDescriptionEntry fde = new DwarfFrameRegisterProvider.FrameDescriptionEntry(fdePtr, ciePtr, entry.low, entry.high, instructions, addressSize);
                        this.provider.frameDescEntries.put(entry, fde);
                    }
                    buffer.position(nextPosition);
                }
                catch (Throwable t) {
                    EDCDebugger.getMessageLogger().logError(DwarfMessages.DwarfInfoReader_FrameIndicesReadFailed, t);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DwarfFrameRegisterProvider.CommonInformationEntry parseCommonInfoEntry(Long ciePtr, int addressSize, IAddress framePC) throws IOException {
        DwarfDebugInfoProvider dwarfDebugInfoProvider = this.provider;
        synchronized (dwarfDebugInfoProvider) {
            long headerLength;
            IStreamBuffer buffer;
            block8: {
                IExecutableSection frameSection;
                block7: {
                    frameSection = this.exeReader.findExecutableSection(DWARF_DEBUG_FRAME);
                    if (frameSection != null) break block7;
                    return null;
                }
                buffer = frameSection.getBuffer();
                buffer.position(ciePtr);
                headerLength = DwarfInfoReader.readAddress(buffer, addressSize);
                if (headerLength <= buffer.capacity()) break block8;
                assert (false);
                return null;
            }
            long nextPosition = buffer.position() + headerLength;
            DwarfInfoReader.readAddress(buffer, addressSize);
            byte version = buffer.get();
            String augmentation = DwarfInfoReader.readString(buffer);
            long codeAlignmentFactor = DwarfInfoReader.read_unsigned_leb128(buffer);
            long dataAlignmentFactor = DwarfInfoReader.read_signed_leb128(buffer);
            int returnAddressRegister = version < 3 ? buffer.get() & 0xFF : (int)DwarfInfoReader.read_unsigned_leb128(buffer);
            IStreamBuffer instructions = buffer.wrapSubsection(nextPosition - buffer.position());
            String producer = null;
            ICompileUnitScope cuScope = this.provider.getCompileUnitForAddress(framePC);
            if (cuScope instanceof DwarfCompileUnit) {
                producer = ((DwarfCompileUnit)cuScope).getAttributeList().getAttributeValueAsString((short)37);
            }
            return new DwarfFrameRegisterProvider.CommonInformationEntry(codeAlignmentFactor, dataAlignmentFactor, returnAddressRegister, version, instructions, addressSize, producer, augmentation);
        }
    }

    private void storeTypeByName(String name, IType type) {
        if (name.length() == 0) {
            return;
        }
        List<IType> typeList = this.provider.typesByName.get(name);
        if (typeList == null) {
            typeList = new ArrayList<IType>();
            if (name.indexOf(60) != -1) {
                while (name.contains("  ")) {
                    name = name.replaceAll("  ", " ");
                }
                name = name.replaceAll(", ", ",");
                name = name.replaceAll("class ", "");
                name = name.replaceAll("struct ", "");
                name = name.replaceAll("union ", "");
            }
            this.provider.typesByName.put(name, typeList);
        }
        typeList.add(type);
    }

    private class BaseAndScopedNames {
        public String baseName;
        public String nameWithScope;

        private BaseAndScopedNames() {
        }
    }

    static class DereferencedAttributes {
        public DwarfDebugInfoProvider.CompilationUnitHeader header;
        public DwarfDebugInfoProvider.AttributeList attributeList;

        public DereferencedAttributes(DwarfDebugInfoProvider.CompilationUnitHeader header, DwarfDebugInfoProvider.AttributeList attributeList) {
            this.header = header;
            this.attributeList = attributeList;
        }
    }
}

