/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.debug.edc.internal.symbols.elf.BufferedRandomReadAccessFile;
import org.eclipse.cdt.debug.edc.internal.symbols.elf.Elf;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ElfExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ExecutableSymbolicsReaderFactory;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReaderFactory;
import org.eclipse.core.runtime.IPath;

public class ElfExecutableSymbolicsReaderFactory
implements IExecutableSymbolicsReaderFactory {
    public int getConfidence(IPath binaryFile) {
        IPath symbolFilePath;
        Elf elfFile = this.getElfFile(binaryFile);
        if (elfFile == null && (symbolFilePath = ExecutableSymbolicsReaderFactory.findSymbolicsFile(binaryFile)) != null) {
            elfFile = this.getElfFile(symbolFilePath);
        }
        return elfFile != null ? 50 : 0;
    }

    public IExecutableSymbolicsReader createExecutableSymbolicsReader(IPath binaryFile) {
        IPath symbolFilePath;
        IExecutableSymbolicsReader reader = this.detectExecutable(binaryFile);
        if (reader == null && (symbolFilePath = ExecutableSymbolicsReaderFactory.findSymbolicsFile(binaryFile)) != null) {
            reader = this.detectExecutable(symbolFilePath);
        }
        return reader;
    }

    private IExecutableSymbolicsReader detectExecutable(IPath binaryFile) {
        try {
            Elf elfFile = this.getElfFile(binaryFile);
            if (elfFile != null) {
                return new ElfExecutableSymbolicsReader(binaryFile, elfFile);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private Elf getElfFile(IPath binaryFile) {
        try {
            FileInputStream fis = new FileInputStream(binaryFile.toOSString());
            byte[] e_ident = new byte[16];
            fis.read(e_ident);
            if (e_ident[0] != 127 || e_ident[1] != 69 || e_ident[2] != 76 || e_ident[3] != 70) {
                throw new IOException(CCorePlugin.getResourceString((String)"Util.exception.notELF"));
            }
            boolean isle = e_ident[5] == 1;
            Elf elf = new Elf(new BufferedRandomReadAccessFile(binaryFile.toOSString(), isle), binaryFile.toOSString(), 0L);
            return elf;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

