/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.debug.internal.core.ICWatchpointTarget;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.WorkbenchJob;

public class AddWatchpointOnVariableActionDelegate
extends AddWatchpointActionDelegate
implements IObjectActionDelegate {
    private ICWatchpointTarget fVar;
    private IWorkbenchPart fActivePart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fActivePart = targetPart;
    }

    public void run(IAction action) {
        if (this.fVar == null) {
            return;
        }
        final String expr = this.fVar.getExpression();
        if (expr == null) {
            assert (false) : "how are we getting an empty expression?";
            return;
        }
        GetSizeRequest request = new GetSizeRequest(){

            public void done() {
                if (this.isSuccess()) {
                    final int size = this.getSize();
                    if (!$assertionsDisabled && size <= 0) {
                        throw new AssertionError((Object)"unexpected variale/expression size");
                    }
                    WorkbenchJob job = new WorkbenchJob("open watchpoint dialog"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            AddWatchpointDialog dlg = new AddWatchpointDialog(CDebugUIPlugin.getActiveWorkbenchShell(), AddWatchpointOnVariableActionDelegate.getMemorySpaceManagement());
                            dlg.setExpression(expr);
                            dlg.initializeRange(false, Integer.toString(size));
                            if (dlg.open() == 0) {
                                AddWatchpointOnVariableActionDelegate.this.addWatchpoint(dlg.getWriteAccess(), dlg.getReadAccess(), dlg.getExpression(), dlg.getMemorySpace(), dlg.getRange());
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                } else {
                    WorkbenchJob job = new WorkbenchJob("watchpoint error"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (AddWatchpointOnVariableActionDelegate.this.fActivePart != null) {
                                ErrorDialog.openError((Shell)AddWatchpointOnVariableActionDelegate.this.fActivePart.getSite().getWorkbenchWindow().getShell(), (String)ActionMessages.getString("AddWatchpointOnVariableActionDelegate.Error_Dlg_Title"), (String)ActionMessages.getString("AddWatchpointOnVariableActionDelegate.No_Element_Size"), (IStatus)this.getStatus());
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            }
        };
        this.fVar.getSize((ICWatchpointTarget.GetSizeRequest)request);
    }

    public void selectionChanged(final IAction action, ISelection selection) {
        this.fVar = null;
        if (selection == null || selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        if (selection instanceof TreeSelection) {
            Object obj = ((TreeSelection)selection).getFirstElement();
            this.fVar = (ICWatchpointTarget)DebugPlugin.getAdapter((Object)obj, ICWatchpointTarget.class);
            if (this.fVar != null) {
                CanCreateWatchpointRequest request = new CanCreateWatchpointRequest(){

                    public void done() {
                        action.setEnabled(this.getCanCreate());
                    }
                };
                this.fVar.canSetWatchpoint((ICWatchpointTarget.CanCreateWatchpointRequest)request);
                return;
            }
            assert (false) : "action should not have been available for object " + obj;
        } else if (selection instanceof StructuredSelection ? !$assertionsDisabled && ((StructuredSelection)selection).getFirstElement() != null : !$assertionsDisabled) {
            throw new AssertionError((Object)"action installed in unexpected type of view/part");
        }
        action.setEnabled(false);
    }

    private class CanCreateWatchpointRequest
    extends CRequest
    implements ICWatchpointTarget.CanCreateWatchpointRequest {
        boolean fCanCreate;

        private CanCreateWatchpointRequest() {
        }

        public boolean getCanCreate() {
            return this.fCanCreate;
        }

        public void setCanCreate(boolean value) {
            this.fCanCreate = value;
        }
    }

    private static class GetSizeRequest
    extends CRequest
    implements ICWatchpointTarget.GetSizeRequest {
        int fSize = -1;

        private GetSizeRequest() {
        }

        public int getSize() {
            return this.fSize;
        }

        public void setSize(int size) {
            this.fSize = size;
        }
    }
}

