/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.internal.core.sourcelookup.ICSourceNotFoundDescription;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSourceNotFoundDescriptionFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType.equals(ICSourceNotFoundDescription.class) && adaptableObject instanceof IStack.IFrameDMContext) {
            final IStack.IFrameDMContext frameDMC = (IStack.IFrameDMContext)adaptableObject;
            return new ICSourceNotFoundDescription(){

                public String getDescription() {
                    Query<IStack.IFrameDMData> query = new Query<IStack.IFrameDMData>(){

                        protected void execute(DataRequestMonitor<IStack.IFrameDMData> rm) {
                            DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), frameDMC.getSessionId());
                            IStack stack = (IStack)tracker.getService(IStack.class);
                            if (stack != null) {
                                stack.getFrameData(frameDMC, rm);
                            } else {
                                rm.setData(null);
                                rm.done();
                            }
                            tracker.dispose();
                        }
                    };
                    DsfSession session = DsfSession.getSession((String)frameDMC.getSessionId());
                    if (session != null && session.getExecutor() != null) {
                        session.getExecutor().execute((Runnable)query);
                        try {
                            IStack.IFrameDMData dmData = (IStack.IFrameDMData)query.get();
                            return CSourceNotFoundDescriptionFactory.getFrameDescription(dmData);
                        }
                        catch (Exception exception) {
                            return frameDMC.toString();
                        }
                    }
                    return frameDMC.toString();
                }
            };
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ICSourceNotFoundDescription.class};
    }

    private static String getFrameDescription(IStack.IFrameDMData frame) {
        String formatString = "";
        String[] propertyNames = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        CSourceNotFoundDescriptionFactory.fillFrameDataProperties(properties, frame);
        Integer line = (Integer)properties.get("frame_line");
        String file = (String)properties.get("frame_file");
        String function = (String)properties.get("frame_function");
        String module = (String)properties.get("frame_module");
        if (line != null && line >= 0 && file != null && file.length() > 0) {
            formatString = function != null && function.contains(")") ? MessagesForLaunchVM.StackFramesVMNode_No_columns__text_format : MessagesForLaunchVM.StackFramesVMNode_No_columns__add_parens__text_format;
            propertyNames = new String[]{"frame_address", "frame_function", "frame_file", "frame_line", "frame_column", "frame_module"};
        } else if (function != null && function.length() > 0 && module != null && module.length() > 0) {
            formatString = function.contains(")") ? MessagesForLaunchVM.StackFramesVMNode_No_columns__No_line__text_format : MessagesForLaunchVM.StackFramesVMNode_No_columns__add_parens__text_format;
            propertyNames = new String[]{"frame_address", "frame_function", "frame_module"};
        } else if (module != null && module.length() > 0) {
            formatString = MessagesForLaunchVM.StackFramesVMNode_No_columns__No_function__text_format;
            propertyNames = new String[]{"frame_address", "frame_module"};
        } else if (function != null && function.length() > 0) {
            formatString = function.contains(")") ? MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__text_format : MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__add_parens__text_format;
            propertyNames = new String[]{"frame_address", "frame_function"};
        } else {
            formatString = MessagesForLaunchVM.StackFramesVMNode_No_columns__Address_only__text_format;
            propertyNames = new String[]{"frame_address"};
        }
        Object[] propertyValues = new Object[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            propertyValues[i] = properties.get(propertyNames[i]);
            ++i;
        }
        return new MessageFormat(formatString).format(propertyValues, new StringBuffer(), null).toString();
    }

    private static void fillFrameDataProperties(Map<String, Object> properties, IStack.IFrameDMData data) {
        IAddress address = data.getAddress();
        if (address != null) {
            properties.put("frame_address", "0x" + address.toString(16));
        }
        properties.put("frame_file", data.getFile());
        properties.put("frame_function", data.getFunction());
        properties.put("frame_line", data.getLine());
        properties.put("frame_column", data.getColumn());
        properties.put("frame_module", data.getModule());
    }
}

