/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.register;

import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.UserEditEvent;

public class RegisterBitFieldCellModifier
extends WatchExpressionCellModifier {
    private AbstractCachingVMProvider fProvider;
    private BitFieldEditorStyle fStyle;
    private IRegisters.IBitFieldDMData fBitFieldData = null;
    private Object fElement = null;
    private SyncRegisterDataAccess fDataAccess = null;
    protected String formatInEditing;

    public RegisterBitFieldCellModifier(AbstractCachingVMProvider provider, BitFieldEditorStyle style, SyncRegisterDataAccess access) {
        this.fProvider = provider;
        this.fStyle = style;
        this.fDataAccess = access;
    }

    private IRegisters.IBitFieldDMContext getBitFieldDMC(Object element) {
        if (element instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)element).getDMContext();
            return (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IBitFieldDMContext.class);
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.getBitFieldDMC(element) == null) {
                return false;
            }
            this.fElement = element;
            this.fBitFieldData = this.fDataAccess.readBitField(element);
            return this.fBitFieldData == null || this.fBitFieldData.isWriteable();
        }
        return super.canModify(element, property);
    }

    public Object getValue(Object element, String property) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            if (element != this.fElement) {
                return false;
            }
            if (this.fStyle == BitFieldEditorStyle.BITFIELDTEXT) {
                String formatId = null;
                formatId = element instanceof IVMContext ? this.queryFormat((IVMContext)element) : "NATURAL.Format";
                this.formatInEditing = formatId;
                String value = this.fDataAccess.getFormattedBitFieldValue(this.fElement, formatId);
                if (value == null) {
                    value = "...";
                }
                return value;
            }
            IRegisters.IMnemonic curMnemonic = this.fBitFieldData.getCurrentMnemonicValue();
            int index = 0;
            IRegisters.IMnemonic[] iMnemonicArray = this.fBitFieldData.getMnemonics();
            int n = iMnemonicArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRegisters.IMnemonic mnemonic = iMnemonicArray[n2];
                if (mnemonic.equals(curMnemonic)) {
                    return new Integer(index);
                }
                ++index;
                ++n2;
            }
            return null;
        }
        return super.getValue(element, property);
    }

    public void modify(Object element, String property, Object value) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.fStyle == BitFieldEditorStyle.BITFIELDTEXT) {
                if (value instanceof String) {
                    String formatId = this.formatInEditing;
                    if (element instanceof IVMContext) {
                        if (formatId == null) {
                            formatId = this.queryFormat((IVMContext)element);
                        }
                    } else {
                        formatId = "NATURAL.Format";
                    }
                    this.fDataAccess.writeBitField(element, (String)value, formatId);
                    this.fProvider.handleEvent(new UserEditEvent(element));
                }
            } else if (value instanceof Integer) {
                Integer val = (Integer)value;
                this.fDataAccess.writeBitField(element, this.fBitFieldData.getMnemonics()[val]);
                this.fProvider.handleEvent(new UserEditEvent(element));
            }
        } else {
            super.modify(element, property, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BitFieldEditorStyle {
        NOTHING,
        BITFIELDCOMBO,
        BITFIELDTEXT;

    }
}

