/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredPathInfo
implements IDiscoveredPathManager.IPerProjectDiscoveredPathInfo,
IDiscoveredPathManager.IDiscoveredScannerInfoSerializable {
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    public static final String REMOVED = "removed";
    private final IProject project;
    private LinkedHashMap<String, Boolean> discoveredPaths;
    private LinkedHashMap<String, SymbolEntry> discoveredSymbols;
    private List<Path> activePaths;
    private Map<String, String> activeSymbols;

    public DiscoveredPathInfo(IProject project) {
        this.project = project;
        this.discoveredPaths = new LinkedHashMap();
        this.discoveredSymbols = new LinkedHashMap();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public synchronized Map<String, String> getSymbols() {
        if (this.activeSymbols == null) {
            this.createSymbolsMap();
        }
        Map<String, String> dSymbols = ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols);
        return dSymbols;
    }

    @Override
    public synchronized IPath[] getIncludePaths() {
        if (this.activePaths == null) {
            this.createPathLists();
        }
        return this.activePaths.toArray(new IPath[this.activePaths.size()]);
    }

    @Override
    public LinkedHashMap<String, Boolean> getIncludeMap() {
        return new LinkedHashMap<String, Boolean>(this.discoveredPaths);
    }

    @Override
    public synchronized void setIncludeMap(LinkedHashMap<String, Boolean> paths) {
        this.discoveredPaths = SafeStringInterner.safeIntern(new LinkedHashMap<String, Boolean>(paths));
        this.activePaths = null;
    }

    private void createPathLists() {
        List<Path> aPaths = this.getActivePathList();
        aPaths.clear();
        Set<String> paths = this.discoveredPaths.keySet();
        for (String path : paths) {
            Boolean removed = this.discoveredPaths.get(path);
            if (removed != null && removed.booleanValue()) continue;
            aPaths.add(new Path(path));
        }
    }

    @Override
    public LinkedHashMap<String, SymbolEntry> getSymbolMap() {
        return new LinkedHashMap<String, SymbolEntry>(this.discoveredSymbols);
    }

    @Override
    public synchronized void setSymbolMap(LinkedHashMap<String, SymbolEntry> symbols) {
        this.discoveredSymbols = SafeStringInterner.safeIntern(new LinkedHashMap<String, SymbolEntry>(symbols));
        this.activeSymbols = null;
    }

    private void createSymbolsMap() {
        Map<String, String> aSymbols = this.getActiveSymbolsMap();
        aSymbols.clear();
        aSymbols.putAll(SafeStringInterner.safeIntern(ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols)));
    }

    private List<Path> getActivePathList() {
        if (this.activePaths == null) {
            this.activePaths = new ArrayList<Path>();
        }
        return this.activePaths;
    }

    private Map<String, String> getActiveSymbolsMap() {
        if (this.activeSymbols == null) {
            this.activeSymbols = new HashMap<String, String>();
        }
        return this.activeSymbols;
    }

    @Override
    public void serialize(Element collectorElem) {
        Document doc = collectorElem.getOwnerDocument();
        LinkedHashMap<String, Boolean> includes = this.getIncludeMap();
        Set includesSet = includes.keySet();
        for (String include : includesSet) {
            Element pathElement = doc.createElement(INCLUDE_PATH);
            pathElement.setAttribute(PATH, include);
            Boolean removed = (Boolean)includes.get(include);
            if (removed != null && removed.booleanValue()) {
                pathElement.setAttribute(REMOVED, "true");
            }
            collectorElem.appendChild(pathElement);
        }
        LinkedHashMap<String, SymbolEntry> symbols = this.getSymbolMap();
        Set symbolsSet = symbols.keySet();
        for (String symbol : symbolsSet) {
            SymbolEntry se = (SymbolEntry)symbols.get(symbol);
            if (se == null) continue;
            List<String> activeValues = se.getActiveRaw();
            for (String value : activeValues) {
                Element symbolElement = doc.createElement(DEFINED_SYMBOL);
                symbolElement.setAttribute(SYMBOL, value);
                collectorElem.appendChild(symbolElement);
            }
            List<String> removedValues = se.getRemovedRaw();
            for (String value : removedValues) {
                Element symbolElement = doc.createElement(DEFINED_SYMBOL);
                symbolElement.setAttribute(SYMBOL, value);
                symbolElement.setAttribute(REMOVED, "true");
                collectorElem.appendChild(symbolElement);
            }
        }
    }

    @Override
    public void deserialize(Element collectorElem) {
        LinkedHashMap<String, Boolean> includes = this.getIncludeMap();
        LinkedHashMap<String, SymbolEntry> symbols = this.getSymbolMap();
        Node child = collectorElem.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals(INCLUDE_PATH)) {
                includes.put(SafeStringInterner.safeIntern((String)((Element)child).getAttribute(PATH)), Boolean.valueOf(((Element)child).getAttribute(REMOVED)));
            } else if (child.getNodeName().equals(DEFINED_SYMBOL)) {
                String symbol = SafeStringInterner.safeIntern((String)((Element)child).getAttribute(SYMBOL));
                String removed = ((Element)child).getAttribute(REMOVED);
                boolean bRemoved = removed != null && removed.equals("true");
                ScannerConfigUtil.scAddSymbolString2SymbolEntryMap(symbols, symbol, !bRemoved);
            }
            child = child.getNextSibling();
        }
        this.setIncludeMap(includes);
        this.setSymbolMap(symbols);
    }

    @Override
    public String getCollectorId() {
        return PerProjectSICollector.COLLECTOR_ID;
    }

    @Override
    public IDiscoveredPathManager.IDiscoveredScannerInfoSerializable getSerializable() {
        return this;
    }
}

