/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimilarFinderVisitor
extends ASTVisitor {
    private final ExtractFunctionRefactoring refactoring;
    private final Vector<IASTNode> trail;
    private final IASTName name;
    private final List<IASTNode> stmts;
    private int i = 0;
    private NodeContainer similarContainer;
    private final List<IASTStatement> stmtToReplace = new ArrayList<IASTStatement>();
    private final ModificationCollector collector;

    SimilarFinderVisitor(ExtractFunctionRefactoring refactoring, ModificationCollector collector, Vector<IASTNode> trail, IFile file, IASTName name, List<IASTNode> stmts, String title) {
        this.shouldVisitStatements = true;
        this.refactoring = refactoring;
        this.trail = trail;
        this.name = name;
        this.stmts = stmts;
        this.collector = collector;
        this.similarContainer = new NodeContainer();
    }

    public int visit(IASTStatement stmt) {
        boolean isAllreadyInMainRefactoring = this.isInSelection(stmt);
        if (!isAllreadyInMainRefactoring && this.refactoring.isStatementInTrail(stmt, this.trail, this.refactoring.getIndex())) {
            this.stmtToReplace.add(stmt);
            this.similarContainer.add((IASTNode)stmt);
            ++this.i;
            if (this.i == this.stmts.size()) {
                boolean similarOnReturnWays = true;
                for (NodeContainer.NameInformation nameInfo : this.similarContainer.getAllAfterUsedNames()) {
                    Integer nameOrderNumber;
                    if (!this.refactoring.names.containsKey(nameInfo.getDeclaration().getRawSignature()) || !this.refactoring.nameTrail.containsValue(nameOrderNumber = this.refactoring.names.get(nameInfo.getDeclaration().getRawSignature()))) continue;
                    String orgName = null;
                    boolean found = false;
                    for (Map.Entry<String, Integer> entry : this.refactoring.nameTrail.entrySet()) {
                        if (!entry.getValue().equals(nameOrderNumber)) continue;
                        orgName = entry.getKey();
                    }
                    if (orgName != null) {
                        for (NodeContainer.NameInformation orgNameInfo : this.refactoring.container.getAllAfterUsedNamesChoosenByUser()) {
                            if (!orgName.equals(orgNameInfo.getDeclaration().getRawSignature())) continue;
                            found = true;
                        }
                    }
                    if (found) continue;
                    similarOnReturnWays = false;
                }
                if (similarOnReturnWays) {
                    IASTNode call = this.refactoring.getMethodCall(this.name, this.refactoring.nameTrail, this.refactoring.names, this.refactoring.container, this.similarContainer);
                    ASTRewrite rewrite = this.collector.rewriterForTranslationUnit(this.stmtToReplace.get(0).getTranslationUnit());
                    TextEditGroup editGroup = new TextEditGroup(Messages.SimilarFinderVisitor_replaceDuplicateCode);
                    rewrite.replace((IASTNode)this.stmtToReplace.get(0), call, editGroup);
                    if (this.stmtToReplace.size() > 1) {
                        int i = 1;
                        while (i < this.stmtToReplace.size()) {
                            rewrite.remove((IASTNode)this.stmtToReplace.get(i), editGroup);
                            ++i;
                        }
                    }
                }
                this.clear();
            }
            return 1;
        }
        this.clear();
        return super.visit(stmt);
    }

    private boolean isInSelection(IASTStatement stmt) {
        List<IASTNode> nodes = this.refactoring.container.getNodesToWrite();
        for (IASTNode node : nodes) {
            if (!node.equals(stmt)) continue;
            return true;
        }
        return false;
    }

    private void clear() {
        this.i = 0;
        this.refactoring.names.clear();
        this.similarContainer = new NodeContainer();
        this.refactoring.namesCounter.setObject(ExtractFunctionRefactoring.NULL_INTEGER);
        this.refactoring.trailPos.setObject(ExtractFunctionRefactoring.NULL_INTEGER);
        this.stmtToReplace.clear();
    }
}

